#############################################################################
##                    Makefile to build xGCOMM.LIB                         ##
#############################################################################
!include $(WGDEV)\SRC\gcrules.mak

!if $(OS) == WNT
     PARSEOPTS = $(PARSEOPTS) -D__BUILDWGSERVER
!endif

!if !$d(SRCDBG)
     TCOMP = /0
!endif

SRCDIROS = .\$(OS)

.path.c = $(SRCDIROS);.
.path.asm = $(SRCDIROS);.
.path.mc = $(SRCDIROS);.

INCCMD = $(INCCMD);$(SRCDIROS)

OBJFILES =          \
     alcblok.obj    \
     alcdup.obj     \
     alcmem.obj     \
     alcrsz.obj     \
     alczer.obj     \
     alldgs.obj     \
     allhex.obj     \
     assert.obj     \
     audapi.obj     \
     audonl.obj     \
     b2ccpy.obj     \
     b2ccvt.obj     \
     bargph.obj     \
     bigdigit.obj   \
     binsrch.obj    \
     c2bcpy.obj     \
     c2bcvt.obj     \
     catfix1.obj    \
     cfgapi.obj     \
     choose.obj     \
     commas.obj     \
     cvtapi.obj     \
     cvtscn.obj     \
     datstm.obj     \
     depad.obj      \
     digit23b.obj   \
     digit2x3.obj   \
     digit2x5.obj   \
     digit3x3.obj   \
     dntapi.obj     \
     dynarr.obj     \
     dynpool.obj    \
     edtchc.obj     \
     edtval.obj     \
     explode.obj    \
     fgetstg.obj    \
     findstg.obj    \
     fioapi.obj     \
     firstwd.obj    \
     ftfcrc16.obj   \
     ftfcrc32.obj   \
     galmemdb.obj   \
     gccuros.obj    \
     gcdelay.obj    \
     gcwinver.obj   \
     gendpk.obj     \
     getasc.obj     \
     gmktemp.obj    \
     hexval.obj     \
     ibm2ans.obj    \
     iniscn.obj     \
     irps.obj       \
     isbigend.obj   \
     isfiln.obj     \
     isgoodpt.obj   \
     isrunpgm.obj   \
     isselc.obj     \
     istxvc.obj     \
     isuidc.obj     \
     itemidx.obj    \
     kbdapi.obj     \
     l2as.obj       \
     lastwd.obj     \
     lingo.obj      \
     lingyn.obj     \
     mcvapi.obj     \
     mdfgets.obj    \
     mdfutl.obj     \
     memstp.obj     \
     memrpl.obj     \
     mltstuff.obj   \
     msgrdr.obj     \
     msgscan.obj    \
     needupc.obj    \
     nextline.obj   \
     noalen.obj     \
     padfld.obj     \
     pascrit.obj    \
     phasedbg.obj   \
     prf.obj        \
     profan.obj     \
     readpfn.obj    \
     repmem.obj     \
     rmvwht.obj     \
     rtkick.obj     \
     sameas.obj     \
     samein.obj     \
     samend.obj     \
     sameto.obj     \
     scanch.obj     \
     setcnf.obj     \
     setcrit.obj    \
     sfxval.obj     \
     sizmem.obj     \
     skpans.obj     \
     skpwht.obj     \
     skpwrd.obj     \
     sortstgs.obj   \
     spr.obj        \
     stgidx.obj     \
     stlcpy.obj     \
     stpans.obj     \
     strins.obj     \
     strmove.obj    \
     strpln.obj     \
     strrpl.obj     \
     strsrep.obj    \
     strstp.obj     \
     stzcpy.obj     \
     sysinf.obj     \
     tasks.obj      \
     tfscan.obj     \
     undwin.obj     \
     unpad.obj      \
     validig.obj    \
     validyn.obj    \
     vbdatim.obj    \
     wcmatch.obj    \
     xtoi.obj

MISCOBJ = \
#%if CUSTOMER
#%else
     aprmod.obj     \
     astring.obj    \
#%endif
     catastro.obj   \
     getrno.obj     \
     vidapi.obj

!if $(OS) == WNT
     NTOBJS =            \
          canrun.obj     \
          ctrlbrk.obj    \
          dfaapi.obj     \
          elogapi.obj    \
          excphand.obj   \
          iswinnt.obj    \
          lerrtext.obj   \

     NTRES =             \
          wgsmsgs.res

     NTTAIL = -+$(SRCDIROS)\btrcall.obj
!elif $(OS) == W31
!    if $(MODEL) == V
          MISCOBJ =           \
               catastvb.obj
!    else # $(MODEL) == W
          MISCOBJ =           \
               catawin.obj
!    endif # $(MODEL)
     MISCOBJ =           \
          $(MISCOBJ)     \
          dfaapi.obj
!else # $(OS) == DOS
!    if $(MODEL) == LARGE
          DOSOBJS =                \
#%if CUSTOMER
#%else
               cputype.obj         \
               movmem.obj          \
               vapiasm.obj         \
#%endif
               dfaapi.obj          \
               pdstub.obj

#%if CUSTOMER
#%else
          DOSTAIL =                \
               lfopen.obj          \
               lfclose.obj         \
               lcloseal.obj        \
               lfflush.obj         \
               lfread.obj          \
               lfseek.obj          \
               lgetc.obj           \
               lputc.obj           \
               lfiles.obj          \
               lfiles2.obj         \
               lflushou.obj
#%endif
!    else # $(MODEL) == PHARLAP
          DOSOBJS =                \
#%if CUSTOMER
#%else
               cputype.obj         \
               movmem.obj          \
               vapiasm.obj         \
#%endif
               dfaapip.obj         \
               pdstub.obj

#%if CUSTOMER
#%else
          DOSTAIL =                \
               hfopen.obj          \
               hfclose.obj         \
               hcloseal.obj        \
               hfflush.obj         \
               hfread.obj          \
               hfseek.obj          \
               hgetc.obj           \
               hputc.obj           \
               hfiles.obj          \
               hfiles2.obj         \
               hflushou.obj

#%endif
!    endif # $(MODEL)
!endif # $(OS)

start:              \
     $(GCBUILD)     \
     $(LIBNAME)

!if $(OS) == WNT
$(LIBNAME):         \
     $(OBJFILES)    \
     $(MISCOBJ)     \
     $(NTRES)       \
     $(NTOBJS)
     if exist tlib.rsp del tlib.rsp
     makersp "-+$(OBJDIR:\=\\)\\!s &\n" &&|
         $(OBJFILES)
|   >> tlib.rsp
     makersp "-+$(OBJDIR:\=\\)\\!s &\n" &&|
         $(MISCOBJ)
|   >> tlib.rsp
     makersp "-+$(OBJDIR:\=\\)\\!s &\n" &&|
         $(NTOBJS)
|   >> tlib.rsp
     makersp "!s" &&|
         $(NTTAIL)
|   >> tlib.rsp
!elif $(OS) == W31
$(LIBNAME):         \
     $(OBJFILES)    \
     $(MISCOBJ)
     if exist tlib.rsp del tlib.rsp
     makersp "-+$(OBJDIR:\=\\)\\!s &\n" &&|
         $(OBJFILES)
|   >> tlib.rsp
     makersp "-+$(OBJDIR:\=\\)\\!s " &&|
         $(MISCOBJ)
|   >> tlib.rsp
!else # $(OS) == DOS
$(LIBNAME):         \
     $(OBJFILES)    \
     $(MISCOBJ)     \
     $(DOSOBJS)
     if exist tlib.rsp del tlib.rsp
     makersp "-+$(OBJDIR:\=\\)\\!s &\n" &&|
         $(OBJFILES)
|   >> tlib.rsp
     makersp "-+$(OBJDIR:\=\\)\\!s &\n" &&|
         $(MISCOBJ)
|   >> tlib.rsp
     makersp "-+$(OBJDIR:\=\\)\\!s " &&|
         $(DOSOBJS)
|   >> tlib.rsp
     makersp "-+$(SRCDIROS:\=\\)\\!s " &&|
         $(DOSTAIL)
|   >> tlib.rsp
!endif
     tlib $(LIBNAME) @tlib.rsp $(TCOMP)
     if exist tlib.rsp del tlib.rsp

cputype.obj: cputype.asm
     $(AS) $(SRCDIROS)\$&.asm,$(OBJDIR)\$&.obj,

movmem.obj: movmem.asm
     $(AS) $(SRCDIROS)\$&.asm,$(OBJDIR)\$&.obj,

vapiasm.obj: vapiasm.asm
     $(AS) $(SRCDIROS)\$&.asm,$(OBJDIR)\$&.obj,
