/***************************************************************************
 *                                                                         *
 *   GCCUROS.C                                                             *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Returns current operating system value.                               *
 *                                                                         *
 *                                            - Craig Yap 1/09/96          *
 *                                                                         *
 ***************************************************************************/

#define FILREV "$Revision: 4 $"

#include "gcomm.h"
#include "gccuros.h"

SHORT
curos(VOID)                        /*   return current OS                  */
{
#if   defined(GCWIN3X)
     return(OSWIN3X);
#elif defined(GCTNT86)
     return(OSTNT86);
#elif defined(GCWINNT)
     return(OSNTX86);
#elif defined(GCBSD2X)
     return(OSBSD2X);
#elif defined(GCSCO30)
     return(OSSCO30);
#elif defined(GCLNX1X)
     return(OSLNX1X);
#elif defined(GCUWR2X)
     return(OSUWR2X);
#elif defined(GCOSF30)
     return(OSOSF30);
#elif defined(GCSOL2X)
     return(OSSOL2X);
#elif defined(GCHPU10)
     return(OSHPU10);
#elif defined(GCDOSL)
     return(OSDOSL);
#elif defined(GCDOSP)
     return(OSDOSP);
#else
#error OS not defined, see GCCUROS.H!
#endif
}
