/***************************************************************************
 *                                                                         *
 *   FGETSTG.C                                                             *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Read a NUL-terminated string from a file.  Returns 1=string read      *
 *   and stored, or 0=no room or EOF encountered.  Either way, fgetstg()   *
 *   always puts a NUL-terminated string in the output buffer, that's      *
 *   guaranteed to fit within n bytes.                                     *
 *                                                                         *
 *                                            - R. Stein 1/9/93            *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

INT                                /*   rets 1=read string, 0=no room/ EOF */
fgetstg(                           /* read a NUL-terminated stg from a file*/
CHAR *stg,                         /*   dest (always NUL-terminated)       */
INT n,                             /*   max # of bytes to write, incl NUL  */
FILE *stream)                      /*   file pointer                       */
{
     INT c;

     while ((c=getc(stream)) != EOF) {
          *stg=c;
          if (c == '\0') {
               return(1);
          }
          if (--n <= 0) {
               break;
          }
          stg++;
     }
     *stg='\0';
     return(0);
}
