/***************************************************************************
 *                                                                         *
 *   EDTCHC.C                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the function suite that uses edtval() to choose one from      *
 *   a given series of character strings.                                  *
 *                                                                         *
 *                                             - TJS & SJB 3/23/92         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

static CHAR **vchcs;               /* copy of passed chcs for valech()     */
static INT nvchcs;                 /* number of entries in vchcs[]         */

static GBOOL valech(INT c,CHAR *stg);

INT                                /*   0 if ESC hit; otherwise 1          */
edtchc(                            /* edit a string value field            */
INT sx,                            /*   starting x coord (0-based)         */
INT sy,                            /*   starting y coord (0-based)         */
CHAR *sval,                        /*   value edit and return-buffer       */
CHAR *chcs[],                      /*   possible choices for value         */
INT flags)                         /*   option flags (see gcomm.h)         */
{
     INT maxlm1;

     for (nvchcs=0,maxlm1=0 ; chcs[nvchcs] != NULL ; nvchcs++) {
          maxlm1=max(maxlm1,(int)strlen(chcs[nvchcs]));
     }
     vchcs=chcs;
     return(edtval(sx,sy,maxlm1+1,sval,valech,flags));
}

static GBOOL
valech(c,stg)                      /* validate edtchc() keystroke          */
INT c;
CHAR *stg;
{
     INT i;

     for (i=0 ; i < nvchcs ; i++) {
          if (tolower(c) == tolower(*vchcs[i])) {
               break;
          }
     }
     if (i == nvchcs) {
          for (i=0 ; i < nvchcs ; i++) {
               if (sameas(stg,vchcs[i])) {
                    break;
               }
          }
          if (++i >= nvchcs) {
               i=0;
          }
     }
     strcpy(stg,vchcs[i]);
     return(0);
}
