/***************************************************************************
 *                                                                         *
 *   COMMAS.C    Add commas to l2as() output                               *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for adding commas to a string-          *
 *   representation of an integer of any size.  The string is converted    *
 *   in-place, so there must be enough room for it, and the passed value   *
 *   is also returned.                                                     *
 *                                                                         *
 *   Example:  prf("Count: %s",commas(l2as(lngint)));                      *
 *                                                                         *
 *                                            - R. Stein  11/12/93         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

CHAR *                             /*   returns ptr to intstg              */
commas(                            /* add commands to integer of any length*/
CHAR *intstg)                      /*   string to convert in-place         */
{
     INT m,n;

     for (n=strlen(intstg),m=4 ; n >= 4 && intstg[n-4] != '-' ; n-=3,m+=4) {
          movmem(intstg+n-3,intstg+n-2,m);
          intstg[n-3]=',';
     }
     return(intstg);
}
