/***************************************************************************
 *                                                                         *
 *   BARGPH.C                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Create a bar-graph string out of IBM characters.                      *
 *                                                                         *
 *                                            - R. Stein 1/16/93           *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 4 $"

SHORT bgperc;                      /* 0-100% of the most recent bargph()   */
SHORT bgpos;                       /* char offset of bar from last bargph()*/

CHAR *                             /*   returns ptr to bar                 */
bargph(                            /* compute a bar graph string           */
SHORT width,                       /*   character width (1 to 80)          */
LONG num,                          /*   numerator                          */
LONG den)                          /*   denominator                        */
{
     static CHAR bar[80+1];
     SHORT twolen,m;

     if (den == 0L) {
          bgperc=0;
          twolen=0;
     }
     else {
          bgperc=(SHORT)(((num*100)+(den>>1))/den);
          twolen=(SHORT)((((num<<1)*width)+(den>>1))/den);
     }
     bgperc=max((SHORT)0,bgperc);
     bgperc=min((SHORT)100,bgperc);
     twolen=min(width<<1,twolen);
     twolen=min(160,twolen);
     twolen=max(0,twolen);
     if ((bgpos=twolen>>1) > 0) {
          setmem(bar,bgpos,'');
     }
     if (twolen&1) {
          bar[bgpos++]='';
     }
     if ((m=((width<<1)-twolen)>>1) > 0) {
          setmem(bar+bgpos,m,' ');
     }
     bar[bgpos+m]='\0';
     return(bar);
}
