/***************************************************************************
 *                                                                         *
 *   B2CCPY.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for copying a VB-style string to a      *
 *   C-style string.  (The source must either be NUL-terminated or be      *
 *   a minimum of length-1 bytes in size.)                                 *
 *                                                                         *
 *                                            - C. Robert    11/29/93      *
 *                                              T. Stryker                 *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

VOID
b2ccpy(                            /* copies a VB-basic string to C format */
CHAR *dest,                        /*   destination buffer, C format       */
const CHAR *src,                   /*   source buffer, VB format           */
UINT length)                       /*   length to copy plus trailing '\0'  */
{
     const CHAR *fnb=NULL,*lnb;
     UINT i,movlen;

     if (length > 0) {
          for (i=1 ; i < length && *src != '\0' ; i++,src++) {
               if (!isspace(*src)) {
                    lnb=src;
                    if (fnb == NULL) {
                         fnb=src;
                    }
               }
          }
          movlen=(fnb == NULL ? 0 : (INT)(lnb-fnb)+1);
          movmem(fnb,dest,movlen);
          setmem(dest+movlen,length-movlen,0);
     }
}
