/***************************************************************************
 *                                                                         *
 *   ASSERT.C                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   ASSERT() and ASSERTM() support functions for xGCOMM.LIB.              *
 *                                                                         *
 *                              - R. Stein & D. Pitchford  1/30/95         *
 *   NT version uses exception handling for ASSERTs                        *
 *                              - Ilya Minkin  1/29/96                     *
 *                                                                         *
 ***************************************************************************/

#define FILREV "$Revision: 7 $"

#include "gcomm.h"
#ifdef GCDOS
#include "phasedbg.h"
#else
#include <windows.h>
#include "excprprt.h"
#endif // GCDOS

SHORT astmode=ASTCAT;              /* assertion failure mode               */
CHAR *astrptfil="GALASSRT.RPT";    /* default assert file                  */

VOID
galastfail(                        /* assertion failure                    */
CHAR *filinf,                      /*   source file name and revision      */
ULONG linnum,                      /*   source file line number            */
CHAR *message)                     /*   ad hoc message (no %-parms allowed)*/
{
#ifdef GCDOS
     extern VOID *catbpsav;
     FILE *fp;
     CHAR *catfix1(),*catfix2();
     VOID *bpsav2;
#else
     static CHAR errMsg[512];
     CONTEXT thContext;
#endif // GCDOS
     static GBOOL recurs=FALSE;

     switch (astmode) {
     case ASTIGN:
          break;
     case ASTCAT:
          if (catact == 0) {
               catastro("ASSERTION FAILED: \"%s\", %s, line %lu\n",
                        message,filinf,linnum);
               break;
          }
     case ASTRPT:
          if (!recurs) {
               recurs=TRUE;
#ifdef GCDOS
               if ((fp=fopen(astrptfil,FOPAA)) != NULL) {
                    fprintf(fp,"\n%s %s ASSERTION FAILED: \"%s\", %s, line %s\n",
                               ncdate(today()),nctime(now()),
                               message,filinf,l2as(linnum));
                    fprintf(fp,"%s %s\n",catfix1(),catfix2());
                    fflush(fp);
                    rptphs(fp);
                    fclose(fp);
                    bpsav2=catbpsav;
                    catbpsav=MK_FP(_SS,_BP);
                    (*catrpt)(astrptfil);
                    catbpsav=bpsav2;
               }
#else
               if (strlen(message) > sizeof(errMsg)-100) {
                    message[sizeof(errMsg)-100]='\0';
               }
               sprintf(errMsg,"ASSERTION FAILED: \"%s\", %s, line %lu\n",
                       message,filinf,linnum);
               thContext.ContextFlags=CONTEXT_FULL;
               GetThreadContext(GetCurrentThread(),&thContext);
               printExcpReport(&thContext,errMsg,(VOID *)galastfail,astrptfil);
#endif // GCDOS
               recurs=FALSE;
          }
          break;
     }
}
