/***************************************************************************
 *                                                                         *
 *   ALCDUP.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the GCOMM.LIB routine for allocating memory for a copy of     *
 *   a string, with protection against an out-of-memory condition.         *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

CHAR *                             /*   returns ptr to newly allocated stg */
alcdup(                            /* allocate mem for stg and copy to it  */
const CHAR *stg)                   /*   string to duplicate                */
{
     CHAR *retval;

     ASSERT(stg != NULL);
     retval=alcmem(strlen(stg)+1);
     strcpy(retval,stg);
     return(retval);
}
