/***************************************************************************
 *                                                                         *
 *   GDPV3.C                                                               *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Generic dynapak database routines that were modified for WG3, for     *
 *   backward compatibility with earlier WG versions.                      *
 *                                                                         *
 *                                           - C. Robert    1/17/94        *
 *                                             T. Stryker                  *
 *   Backward compatibility version          - J. Alvrus    04/29/97       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gcspsrv.h"

USHORT                             /*   return number of bytes read        */
v3readgdp(                         /* read dpk from GDP db w/ conversion   */
INT dir,                           /*   direction to read (1, -1)          */
struct saunam *name,               /*   dpk to read and dest for name read */
USHORT length,                     /*   length of passed dest buffer       */
VOID *dest,                        /*   destination (NULL=leave in GDPBTR) */
CHAR *suffix)                      /*   suffix for minimal match           */
{
     USHORT rv;

     return((rv=readgdp(dir,name,length,dest)) != 0
         && sameto(suffix,(GDPBTR->name.suffix)) ? rv : 0);
}
