/***************************************************************************
 *                                                                         *
 *   DNTV3.C                                                               *
 *                                                                         *
 *   Copyright (C) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Date and Time API -- commonly used functions added for WG3, for       *
 *   backward compatibility with earlier WG versions.                      *
 *                                                                         *
 *                            - RNStein  B03F  2952  01/31/88  31 JAN 88   *
 *   Backward compatibility version          - J. Alvrus    04/24/97       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 2 $"

const CHAR *                       /*   returns string in requested format */
prntim(                            /* print <time> in format <mode>        */
INT mode,                          /*   format mode                        */
USHORT time)                       /*   time to format                     */
{
     INT hour,hour2;
     static CHAR timret[20];
     CHAR tmpval[5];

     hour=hour2=dthour(time);
     tmpval[0]='\0';
     if (mode%5 != 0) {
          if (hour != 0) {
               hour%=12;
          }
          if (hour == 0) {
               hour=12;
          }
          if (mode%5 >= 3) {
               strcpy(tmpval," ");
          }
          strcat(tmpval,((hour2 < 12) ? "a" : "p"));
          if (mode%5 == 2 || mode%5 == 4) {
               strcat(tmpval,"m");
          }
     }
     if (mode >= 10) {
          sprintf(timret,"%d:%02d:%02d%s",hour,dtmin(time),dtsec(time),tmpval);
     }
     else {
          sprintf(timret,"%d:%02d%s",hour,dtmin(time),tmpval);
     }
     if (mode%10 >= 6) {
          strupr(timret);
     }
     return(timret);
}

const CHAR *                       /*   returns string in requested format */
prndat(                            /* print <date> in format <mode>        */
INT mode,                          /*   format mode                        */
USHORT date,                       /*   date to format                     */
CHAR sep)                          /*   separator character                */
{
     INT year;
     static CHAR datret[30];
     static CHAR *months[]={
          "January","February","March","April","May","June","July","August",
          "September","October","November","December"
     };

     year=ddyear(date);
     if (mode <= 9) {
          year%=100;
     }
     switch (mode%12) {
     case 0:
     case 1:
          sprintf(datret,"%02d%c%02d",ddmon(date),sep,ddday(date));
          break;
     case 2:
     case 3:
          sprintf(datret,"%02d%c%d",ddmon(date),sep,year);
          break;
     case 4:
     case 5:
          sprintf(datret,"%02d%c%02d%c%d",ddmon(date),sep,ddday(date),sep,
                  year);
          break;
     case 6:
     case 7:
          sprintf(datret,"%02d%c%3.3s%c%d",ddday(date),sep,
                                           months[ddmon(date)-1],sep,year);
          break;
     case 8:
     case 9:
          sprintf(datret,"%3.3s %d, %d",months[ddmon(date)-1],ddday(date),
                  year);
          break;
     case 10:
     case 11:
          sprintf(datret,"%s %d, %d",months[ddmon(date)-1],ddday(date),year);
          break;
     }
     if (mode%2) {
          strupr(datret);
     }
     return(datret);
}

const CHAR *                       /*   returns string in day format       */
prnday(                            /* print <date> in day format           */
USHORT date,                       /*   date to format                     */
INT size)                          /*   size of buffer                     */
{
     static CHAR dayret[10];
     static CHAR *days[]={
          "Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday",
          "Monday"
     };

     strncpy(dayret,days[(UINT)cofdat(date)%7],size%10);
     return(dayret);
}
