/***************************************************************************
 *                                                                         *
 *   DFAV3.C                                                               *
 *                                                                         *
 *   Copyright (c) 1987-1996 Galacticomm, Inc.   All Rights Reserved.      *
 *                                                                         *
 *   This file contains a library of routines for accessing BTRIEVE files  *
 *   with fixed or variable length records, from Windows NT and Large      *
 *   Model DOS -- backward compatibility for versions of WG prior to 3.0.  *
 *                                                                         *
 *                                           - T. Stryker 9/30/86          *
 *   Dup Ins/Upd, File Create, Misc others   - S. Brinker/R. Skurnick      *
 *   Step Based Btrieve Support Added        - R. Skurnick                 *
 *   Windows DLL interface                   - T. Stryker                  *
 *   Locking/transaction support             - TJS/CLR/RLS 6/18/94         *
 *   Backward compatibility version          - J. Alvrus    04/24/97       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 2 $"

static GBOOL dfaCopyFile(CHAR *src,CHAR *dst);

GBOOL                              /*   returns TRUE=success               */
dfaVirgin(                         /* copy virgin file into database file  */
const CHAR *src,                   /*   virgin database file name w/o ext  */
const CHAR *dst)                   /*   destination file name or NULL      */
{
     CHAR srcfil[GCMAXPTH];
     CHAR dstfil[GCMAXPTH];

     stlcat(stlcpy(srcfil,src,GCMAXPTH),".vir",GCMAXPTH);
     stlcat(stlcpy(dstfil,(dst == NULL) ? src : dst,GCMAXPTH),".dat",GCMAXPTH);
     return(dfaCopyFile(srcfil,dstfil));
}

static GBOOL                       /*   returns TRUE=success               */
dfaCopyFile(                       /* copy file src to dst                 */
CHAR *src,                         /*   source filename                    */
CHAR *dst)                         /*   destination filename               */
{
     INT frsiz;
     FILE *fvir,*fnew;
     static CHAR inbuf[4096];

     if ((fvir=fopen(src,FOPRB)) == NULL) {
          return(FALSE);
     }
     if ((fnew=fopen(dst,FOPWB)) == NULL) {
          fclose(fvir);
          return(FALSE);
     }
     while (!feof(fvir)) {
          if ((frsiz=(INT)fread(inbuf,1,4096,fvir)) > 0) {
               fwrite(inbuf,1,frsiz,fnew);
          }
          if (ferror(fnew) || ferror(fvir)) {
               fclose(fvir);
               fclose(fnew);
               unlink(dst);
               return(FALSE);
          }
     }
     fclose(fvir);
     fclose(fnew);
     return(TRUE);
}
