/***************************************************************************
 *                                                                         *
 *   TXTVBL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1991-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the default suite of "text variables" that comes with         *
 *   Worldgroup Baseline Edition.                                          *
 *                                                                         *
 *                                                 - C. Robert  2/7/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 9 $"

CHAR *tvar_userid(VOID),*tvar_portno(VOID),
      *tvar_channo(VOID),*tvar_usrnam(VOID),
      *tvar_usrad1(VOID),*tvar_usrad2(VOID),
      *tvar_usrad3(VOID),*tvar_usrad4(VOID),
      *tvar_usrpho(VOID),*tvar_systyp(VOID),
      *tvar_ansifl(VOID),*tvar_scnwid(VOID),
      *tvar_scnbrk(VOID),*tvar_usrage(VOID),
      *tvar_usrsex(VOID),*tvar_credat(VOID),
      *tvar_usedat(VOID),*tvar_curcls(VOID),
      *tvar_tckavl(VOID),*tvar_tcktot(VOID),
      *tvar_tckpai(VOID),*tvar_timonl(VOID),
      *tvar_timcal(VOID),*tvar_timday(VOID),
      *tvar_usdtdy(VOID),*tvar_dyslft(VOID),
      *tvar_dbtlmt(VOID),*tvar_bdrate(VOID),
      *tvar_ccrate(VOID),*tvar_pagnam(VOID),
      *tvar_parpag(VOID),*tvar_mnuttl(VOID),
      *tvar_sydate(VOID),*tvar_sytime(VOID),
      *tvar_sysnam(VOID),*tvar_syscmp(VOID),
      *tvar_sysad1(VOID),*tvar_sysad2(VOID),
      *tvar_syspho(VOID),*tvar_sysrst(VOID),
      *tvar_chhour(VOID),*tvar_chgmin(VOID),
      *tvar_regnum(VOID),*tvar_nmline(VOID),
      *tvar_ninuse(VOID),*tvar_ncalls(VOID),
      *tvar_dwnlds(VOID),*tvar_nuplds(VOID),
      *tvar_msgtot(VOID),*tvar_emlopn(VOID),
      *tvar_sigopn(VOID),*tvar_numact(VOID),
      *tvar_nummal(VOID),*tvar_numfem(VOID),
      *tvar_numcor(VOID),*tvar_numans(VOID),
      *tvar_vrsion(VOID),*tvar_minonl(VOID),
      *tvar_crdatl(VOID),*tvar_usdatl(VOID),
      *tvar_sydatl(VOID);


VOID EXPORT
init__galtxv(VOID)                 /* initialize & register text variables */
{
     register_textvar("USERID",tvar_userid);
     register_textvar("PORT",tvar_portno);
     register_textvar("CHANNEL",tvar_channo);
     register_textvar("NAME",tvar_usrnam);
     register_textvar("COMPANY",tvar_usrad1);
     register_textvar("ADDRESS1",tvar_usrad2);
     register_textvar("ADDRESS2",tvar_usrad3);
     register_textvar("ADDRESS3",tvar_usrad4);
     register_textvar("PHONE",tvar_usrpho);
     register_textvar("SYSTEM_TYPE",tvar_systyp);
     register_textvar("ANSI",tvar_ansifl);
     register_textvar("SCREEN_WIDTH",tvar_scnwid);
     register_textvar("SCREEN_LENGTH",tvar_scnbrk);
     register_textvar("AGE",tvar_usrage);
     register_textvar("SEX",tvar_usrsex);
     register_textvar("CREATION_DATE",tvar_credat);
     register_textvar("CREATION_DATE_L",tvar_crdatl);
     register_textvar("LAST_ON",tvar_usedat);
     register_textvar("LAST_ON_L",tvar_usdatl);
     register_textvar("CLASS",tvar_curcls);
     register_textvar("CREDITS",tvar_tckavl);
     register_textvar("CREDITS_EVER",tvar_tcktot);
     register_textvar("PAID_EVER",tvar_tckpai);
     register_textvar("TIME_ONLINE",tvar_timonl);
     register_textvar("CALL_TIME_LIMIT",tvar_timcal);
     register_textvar("DAY_TIME_LIMIT",tvar_timday);
     register_textvar("TIME_TODAY",tvar_usdtdy);
     register_textvar("DAYS_LEFT",tvar_dyslft);
     register_textvar("DEBT_LIMIT",tvar_dbtlmt);
     register_textvar("BAUD",tvar_bdrate);
     register_textvar("CREDIT_RATE",tvar_ccrate);
     register_textvar("PAGE",tvar_pagnam);
     register_textvar("PARENT",tvar_parpag);
     register_textvar("TITLE",tvar_mnuttl);
     register_textvar("DATE",tvar_sydate);
     register_textvar("DATE_L",tvar_sydatl);
     register_textvar("TIME",tvar_sytime);
     register_textvar("SYSTEM_NAME",tvar_sysnam);
     register_textvar("SYSTEM_COMPANY",tvar_syscmp);
     register_textvar("SYSTEM_ADDRESS1",tvar_sysad1);
     register_textvar("SYSTEM_ADDRESS2",tvar_sysad2);
     register_textvar("SYSTEM_PHONE",tvar_syspho);
     register_textvar("RESTRICTED_PHO",tvar_sysrst);
     register_textvar("CHARGE_PER_HOUR",tvar_chhour);
     register_textvar("MINIMUM_CHARGE",tvar_chgmin);
     register_textvar("REG_NUMBER",tvar_regnum);
     register_textvar("NUMBER_OF_LINES",tvar_nmline);
     register_textvar("OTHERS_ONLINE",tvar_ninuse);
     register_textvar("TOTAL_CALLS",tvar_ncalls);
     register_textvar("DOWNLOADS",tvar_dwnlds);
     register_textvar("UPLOADS",tvar_nuplds);
     register_textvar("TOTAL_MESSAGES",tvar_msgtot);
     register_textvar("OPEN_FORUM_MSGS",tvar_sigopn);
     register_textvar("OPEN_EMAIL_MSGS",tvar_emlopn);
     register_textvar("TOTAL_ACCOUNTS",tvar_numact);
     register_textvar("TOTAL_MALE",tvar_nummal);
     register_textvar("TOTAL_FEMALE",tvar_numfem);
     register_textvar("TOTAL_CORP",tvar_numcor);
     register_textvar("TOTAL_ANSI",tvar_numans);
     register_textvar("BBS_VERSION",tvar_vrsion);
     register_textvar("MIN_ONLINE",tvar_minonl);
}

VOID EXPORT
initwc__galtxv(VOID)
{
     init__galtxv();
}

CHAR *
tvar_userid(VOID)                  /* current User-ID text variable        */
{
     return(usaptr->userid);
}

CHAR *
tvar_portno(VOID)                  /* current user's port number text vbl  */
{
     return(spr("%d",usrnum));
}

CHAR *
tvar_channo(VOID)                  /* current user's chan number text vbl  */
{
     return(strupr(spr("%x",channel[usrnum])));
}

CHAR *
tvar_usrnam(VOID)                  /* current user's real name text vbl    */
{
     return(usaptr->usrnam);
}

CHAR *
tvar_usrad1(VOID)                  /* current user's company name text vbl */
{
     return(usaptr->usrad1);
}

CHAR *
tvar_usrad2(VOID)                  /* current user's address line 1 t. vbl */
{
     return(usaptr->usrad2);
}

CHAR *
tvar_usrad3(VOID)                  /* current user's address line 2 t. vbl */
{
     return(usaptr->usrad3);
}

CHAR *
tvar_usrad4(VOID)                  /* current user's address line 3 t. vbl */
{
     return(usaptr->usrad4);
}

CHAR *
tvar_usrpho(VOID)                  /* current user's phone number t. vbl   */
{
     return(usaptr->usrpho);
}

CHAR *
tvar_systyp(VOID)                  /* current user's system type text vbl  */
{
     return(sysstg[(SHORT)usaptr->systyp]);
}

CHAR *
tvar_ansifl(VOID)                  /* current user's ANSI setting text vbl */
{
     return(ansstg[(SHORT)usaptr->ansifl]);
}

CHAR *
tvar_scnwid(VOID)                  /* current user's screen width text vbl */
{
     return(spr("%d",usaptr->scnwid));
}

CHAR *
tvar_scnbrk(VOID)                  /* current user's screen len text vbl   */
{
     return(usaptr->scnbrk == CTNUOS ? "(continuous)"
            : spr("%d",usaptr->scnbrk));
}

CHAR *
tvar_usrage(VOID)                  /* current user's age text variable     */
{
     if (usaptr->age > 0) {
          return(spr("%d",usaptr->age));
     }
     else {
          return("N/A");
     }
}

CHAR *
tvar_usrsex(VOID)                  /* current user's sex text variable     */
{
     return(usaptr->sex == 'M' ? "Male" : usaptr->sex == 'F' ? "Female"
         : "Unknown");
}

CHAR *
tvar_credat(VOID)                  /* current user's creation date txt vbl */
{
     return((CHAR *)ncdate(usaptr->credat));
}

CHAR *
tvar_crdatl(VOID)                  /* long form of creation date           */
{
     return((CHAR *)ncdatel(usaptr->credat));
}

CHAR *
tvar_usedat(VOID)                  /* current user's last logon text vbl   */
{
     return((CHAR *)ncdate(usaptr->usedat));
}

CHAR *
tvar_usdatl(VOID)                  /* long form of last logon              */
{
     return((CHAR *)ncdatel(usaptr->usedat));
}

CHAR *
tvar_curcls(VOID)                  /* current user's class text variable   */
{
     return(usaptr->curcls);
}

CHAR *
tvar_tckavl(VOID)                  /* current user's credits text variable */
{
     return(usaptr->creds > 0L ? spr("+%ld",usaptr->creds)
            : l2as(usaptr->creds));
}

CHAR *
tvar_tcktot(VOID)                  /* current user's total creds ever tvbl */
{
     return(l2as(usaptr->totcreds));
}

CHAR *
tvar_tckpai(VOID)                  /* current user's total paid ever tvbl  */
{
     return(l2as(usaptr->totpaid));
}

CHAR *
tvar_timonl(VOID)                  /* current user's time online text vbl  */
{                                  /* (see also tvar_minonl())             */
     INT mins;

     mins=(usrptr->minut4+2)/4;
     return(spr("%d minute%c",mins,mins != 1 ? 's' : '\0'));
}

CHAR *
tvar_timcal(VOID)                  /* current user's time allowed per call */
{
     return(usrptr->cltptr->limcal == -1 ? "UNLIMITED"
            : spr("%d minutes",usrptr->cltptr->limcal));
}

CHAR *
tvar_timday(VOID)                  /* current user's time allowed per day  */
{
     return(usrptr->cltptr->limday == -1 ? "UNLIMITED"
            : spr("%d minutes",usrptr->cltptr->limday));
}

CHAR *
tvar_usdtdy(VOID)                  /* current user's time used today t. vbl*/
{
     LONG mins;

     mins=(usaptr->timtdy+30L)/60L;
     return(spr("%ld minute%c",mins,mins != 1L ? 's' : '\0'));
}

CHAR *
tvar_dyslft(VOID)                  /* current user's days left in class tvb*/
{
     struct clstab *tabptr;

     tabptr=usrptr->cltptr;
     return((tabptr->flags&DAYEXP) ? spr("%d",usaptr->daystt) : "UNLIMITED");
}

CHAR *
tvar_dbtlmt(VOID)                  /* current user's debt limit text vbl   */
{
     struct clstab *tabptr;

     tabptr=usrptr->cltptr;
     return(tabptr->dbtlmt == -1L ? "UNLIMITED" : tabptr->dbtlmt > 0L
            ? spr("%ld",tabptr->dbtlmt) : "None");
}

CHAR *
tvar_bdrate(VOID)                  /* current user's baud rate text vbl    */
{
     return(l2as(usrptr->baud));
}

CHAR *
tvar_ccrate(VOID)                  /* current user's cred consume rate tvbl*/
{
     return(spr("%u",usrptr->crdrat));
}

CHAR *
tvar_pagnam(VOID)                  /* current user's menu page name tvbl   */
{
     struct usrmnu *mnupag;

     mnupag=mnuoff(usrnum);
     return(mnupag->curpag[0] == '\0' ? "Logon" : mnupag->curpag);
}

CHAR *
tvar_parpag(VOID)                  /* current user's parent page name tvbl */
{
     struct usrmnu *mnupag;

     mnupag=mnuoff(usrnum);
     return(mnupag->parpag[0] == '\0' ? "None" : mnupag->parpag);
}

CHAR *
tvar_mnuttl(VOID)                  /* current user's menu page title tvbl  */
{
     struct usrmnu *mnupag;

     mnupag=mnuoff(usrnum);
     return(mnupag->curpag[0] == '\0' ? "Logon"
            : mnupag->mnuttl[0] == '\0' ? mnupag->curpag : mnupag->mnuttl);
}

CHAR *
tvar_sydate(VOID)                  /* current system date text variable    */
{
     return((CHAR *)ncedat(today()));
}

CHAR *
tvar_sydatl(VOID)                  /* long form of system date             */
{
     return((CHAR *)ncedatl(today()));
}

CHAR *
tvar_sytime(VOID)                  /* current system time text variable    */
{
     return((CHAR *)nctime(now()));
}

CHAR *
tvar_sysnam(VOID)                  /* system name text variable            */
{
     return(bbsttl);
}

CHAR *
tvar_syscmp(VOID)                  /* system company name text variable    */
{
     return(company);
}

CHAR *
tvar_sysad1(VOID)                  /* system adress line 1 text variable   */
{
     return(addres1);
}

CHAR *
tvar_sysad2(VOID)                  /* system adress line 2 text variable   */
{
     return(addres2);
}

CHAR *
tvar_syspho(VOID)                  /* system phone text variable           */
{
     return(dataph);
}

CHAR *
tvar_sysrst(VOID)                  /* system restricted phone text variable*/
{
     return(liveph);
}

CHAR *
tvar_chhour(VOID)                  /* system charge per hour text variable */
{
     return(chghour);
}

CHAR *
tvar_chgmin(VOID)                  /* system minimum charge text variable  */
{
     return(chgmin);
}

CHAR *
tvar_regnum(VOID)                  /* system registration number text var  */
{
     return(bturno);
}

CHAR *
tvar_nmline(VOID)                  /* system number of lines defined tvar  */
{
     return(spr("%d",nterms));
}

CHAR *
tvar_ninuse(VOID)                  /* system number of other users online  */
{
     INT othusn,retval;

     retval=0;
     for (othusn=0 ; othusn < nterms ; othusn++) {
          if (incusr(othusn,FALSE,FALSE) > VACANT) {
               retval++;
          }
     }
     return(spr("%d",retval));
}

CHAR *
tvar_ncalls(VOID)                  /* system number of calls to date       */
{
     return(l2as(sv2.totcalls));
}

CHAR *
tvar_dwnlds(VOID)                  /* system number of downloads to date   */
{
     return(l2as(sv.dwnlds));
}

CHAR *
tvar_nuplds(VOID)                  /* system number of uploads to date     */
{
     return(l2as(sv.uplds));
}

CHAR *
tvar_msgtot(VOID)                  /* system number of messages to date    */
{
     return(l2as(sv.msgtot));
}

CHAR *
tvar_sigopn(VOID)                  /* system number of open forum messages */
{
     return(spr("%u",sv.sigopn));
}

CHAR *
tvar_emlopn(VOID)                  /* system number of open email messages */
{
     return(spr("%u",sv.emlopn));
}

CHAR *
tvar_numact(VOID)                  /* system total number of user accounts */
{
     return(spr("%ld",sv2.numact));
}

CHAR *
tvar_nummal(VOID)                  /* system total number of male accounts */
{
     return(spr("%ld",sv2.numact-sv2.numfem));
}

CHAR *
tvar_numfem(VOID)                  /* system total number of female accts  */
{
     return(spr("%ld",sv2.numfem));
}

CHAR *
tvar_numcor(VOID)                  /* system total number of corporate usrs*/
{
     return(spr("%ld",sv2.numcor));
}

CHAR *
tvar_numans(VOID)                  /* system total number of ANSI users    */
{
     return(spr("%ld",sv2.numans));
}

CHAR *
tvar_vrsion(VOID)                  /* BBS version                          */
{
     int lcoff;
     static char retval[VERSIZ];

     stlcpy(retval,version,VERSIZ);
     lcoff=strlen(retval)-1;
     if (lcoff > 0 && (retval[lcoff] < 32 || retval[lcoff] > 126)) {
          switch (retval[lcoff]) { /* some things (Web server, primarily)  */
          case '':                /* rely on strictly printable ASCII     */
               retval[lcoff]='a';  /* version codes...  thus this code     */
               break;
          case '':
               retval[lcoff]='b';
               break;
          default:
               retval[lcoff]='x';
          }
     }
     return(retval);
}

CHAR *
tvar_minonl(VOID)                  /* current user's minutes online        */
{                                  /* (just number, see also tvar_timonl())*/
     INT mins;

     mins=(usrptr->minut4+2)/4;
     return(spr("%d",mins));
}
