/***************************************************************************
 *                                                                         *
 *   GALTEXT.C                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This module contains functions for handling formatted text.           *
 *                                                                         *
 *                                                - J. Alvrus  7/17/95     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galrtf.h"
#include "galtext.h"

#define FILREV "$Revision: 8 $"

INT nfmthl=0;                      /* number of registered format handlers */
struct fmthlr **fhlarr=NULL;       /* array of format handlers             */

static GBOOL rtftoasc(const CHAR *rtfsrc,CHAR *ascdst,UINT bufsiz);
static GBOOL rtfstrip(const CHAR *rtfsrc,CHAR *ascdst,UINT bufsiz);

static
struct fmthlr rtfhlr={             /* RTF format handler                   */
     "RTF",                        /*   RTF format name                    */
     0,                            /*   handler flags                      */
     isrtf,                        /*   detect RTF handler                 */
     rtftoasc,                     /*   convert to ASCII handler           */
     rtfinasc,                     /*   insert ASCII handler               */
     rtfstrip                      /*   format stripping handler           */
};

VOID EXPORT
init__galtext(VOID)                /* initialize text handling DLL         */
{
     initrtf(RTFSTKSZ);
     register_fmthlr(&rtfhlr);
}

VOID EXPORT
initwc__galtext(VOID)
{
     init__galtext();
}

VOID
register_fmthlr(                   /* register formatted text handler      */
struct fmthlr *fmthlr)             /*   formatted text handling struct     */
{
     if (nfmthl == 0) {
          fhlarr=(struct fmthlr **)alcmem(sizeof(struct fmthlr *));
     }
     else {
          fhlarr=(struct fmthlr **)alcrsz(fhlarr,
                                          nfmthl*sizeof(struct fmthlr *),
                                          (nfmthl+1)*sizeof(struct fmthlr *));
     }
     fhlarr[nfmthl++]=fmthlr;
}

INT
nfmthlr(VOID)                      /* number of registered format handlers */
{
     return(nfmthl);
}

struct fmthlr const * const *
fharr(VOID)                        /* ptr to array of ptrs to fmt handlers */
{
     return((struct fmthlr const * const *)fhlarr);
}

GBOOL                              /*   is this text formatted?            */
isfmtted(                          /* check for formatted text             */
const CHAR *srcstr)                /*   string to examine                  */
{
     INT i;

     for (i=0 ; i < nfmthl ; ++i) {
          if ((*(fhlarr[i]->detect))(srcstr)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

const CHAR *                       /*   returns name of format             */
fmtname(                           /* get name of format used in this text */
const CHAR *fmtstr)                /*   string containing formatted text   */
{
     INT i;

     for (i=0 ; i < nfmthl ; ++i) {
          if ((*(fhlarr[i]->detect))(fmtstr)) {
               return(fhlarr[i]->fmtdesc);
          }
     }
     return("");
}

GBOOL                              /*   was able to convert?               */
cvt2asc(                           /* convert formatted text to ASCII      */
const CHAR *fmtsrc,                /*   formatted source string            */
CHAR *ascdst,                      /*   ASCII destination buffer           */
UINT dstsiz)                       /*   destination buffer size            */
{
     INT i;

     for (i=0 ; i < nfmthl ; ++i) {
          if ((*(fhlarr[i]->toasc))(fmtsrc,ascdst,dstsiz)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

GBOOL                              /*   was able to insert?                */
insasc(                            /* insert ASCII into formatted text     */
GBOOL endflg,                      /*   insert at end (vs. at beginning)   */
const CHAR *srcbuf,                /*   buffer containing ASCII text       */
CHAR *dstbuf,                      /*   buffer containing formatted text   */
UINT dstsiz)                       /*   destination buffer size            */
{
     INT i;

     for (i=0 ; i < nfmthl ; ++i) {
          if ((*(fhlarr[i]->detect))(dstbuf)) {
               return((*(fhlarr[i]->insasc))(endflg,srcbuf,dstbuf,dstsiz));
          }
     }
     return(FALSE);
}

GBOOL                              /*   was able to convert?               */
stripfmt(                          /* strip formatting                     */
const CHAR *fmtsrc,                /*   formatted source string            */
CHAR *ascdst,                      /*   ASCII destination buffer           */
UINT dstsiz)                       /*   destination buffer size            */
{
     INT i;

     for (i=0 ; i < nfmthl ; ++i) {
          if ((*(fhlarr[i]->stpfmt))(fmtsrc,ascdst,dstsiz)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

static GBOOL                       /*   was able to convert?               */
rtftoasc(                          /* convert RTF to ASCII (fmthlr style)  */
const CHAR *rtfsrc,                /*   RTF source buffer                  */
CHAR *ascdst,                      /*   ASCII destination buffer           */
UINT bufsiz)                       /*   destination buffer size            */
{
     INT rc;

     if (!isrtf(rtfsrc)) {
          return(FALSE);
     }
     rc=rtf2asc(rtfsrc,ascdst,bufsiz);
     if (rc != RTFOK) {
          shocst("RTF CONVERSION ERROR","RTF reader error %d in rtftoasc",rc);
     }
     return(rc == RTFOK);
}

static GBOOL                       /*   was able to convert?               */
rtfstrip(                          /* super-simple RTF to ASCII converter  */
const CHAR *rtfsrc,                /*   RTF source buffer                  */
CHAR *ascdst,                      /*   ASCII destination buffer           */
UINT bufsiz)                       /*   destination buffer size            */
{
     int rc;

     if (!isrtf(rtfsrc)) {
          return(FALSE);
     }
     rc=striprtf(rtfsrc,ascdst,bufsiz);
     if (rc != RTFOK) {
          shocst("RTF CONVERSION ERROR","RTF reader error %d in rtfstrip",rc);
     }
     return(rc == RTFOK);
}
