/***************************************************************************
 *                                                                         *
 *   SMFILE.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997      Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Swap file API for searchable memory block API.                        *
 *                                                                         *
 *                                           - J. Alvrus    5/21/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __SMFILE_H
#define __SMFILE_H

#include "gcomm.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct smFile {            /* swap file control info structure     */
     FILE *fp;                     /*   file pointer                       */
     SMBPTR freeList;              /*   head of free block list            */
     size_t blockSize;             /*   size of blocks                     */
     CHAR fileName[GCMAXPTH];      /*   name of swap file                  */
} SMFILE;

VOID
smfInit(                           /* initialize swap file API             */
const CHAR *swapPath);             /*   location for swap files            */

SMFILE *                           /*   pointer to control info            */
smfOpen(                           /* open a swap file                     */
size_t blockSize);                 /*   size of blocks                     */

VOID
smfClose(                          /* close a swap file                    */
SMFILE *smf);                      /*   swap file to close                 */

SMBPTR                             /*   pointer to allocated block         */
smfAlloc(                          /* allocate a block in swap file        */
SMFILE *smf);                      /*   swap file control info             */

GBOOL                              /*   returns TRUE if successful         */
smfFree(                           /* free a block in swap file            */
SMFILE *smf,                       /*   swap file control info             */
SMBPTR ref);                       /*   block to free                      */

GBOOL                              /*   returns TRUE if successful         */
smfRead(                           /* read a block from swap file          */
SMFILE *smf,                       /*   swap file control info             */
VOID *buf,                         /*   buffer to read into                */
SMBPTR ref);                       /*   block to read                      */

GBOOL                              /*   returns TRUE if successful         */
smfWrite(                          /* write a block to swap file           */
SMFILE *smf,                       /*   swap file control info             */
const VOID *src,                   /*   pointer to block to write          */
SMBPTR ref);                       /*   position to write block to         */

GBOOL                              /*   returns TRUE if successful         */
smfSeek(                           /* set position in swap file            */
SMFILE *smf,                       /*   swap file control info             */
SMBPTR ref);                       /*   block to point to                  */

SMBPTR                             /*   returns pointer to current block   */
smfTell(                           /* get position in swap file            */
SMFILE *smf);                      /*   swap file control info             */

#ifdef DEBUG

GBOOL
smfIsValidBlock(                   // is this a valid block pointer?
SMFILE *smf,                       //   swap file control info
SMBPTR ref);                       //   block to check

#endif // DEBUG

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __SMFILE_H
