/***************************************************************************
 *                                                                         *
 *   SMBLOCK.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997      Galacticomm, Inc.       All Rights Reserved.  *
 *                                                                         *
 *   Block management API for searchable memory block API.                 *
 *                                                                         *
 *                                           - J. Alvrus    5/21/97        *
 *                                                                         *
 ***************************************************************************/

#ifndef __SMBLOCK_H
#define __SMBLOCK_H

#include "gcomm.h"
#include "smbapi.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

VOID *                             /*   ptr to block in cache, NULL if err */
smbAlloc(                          /* allocate a block                     */
SMBHANDLE smb,                     /*   block control struct               */
SMBPTR *pRef);                     /*   buffer to receive reference        */

VOID
smbFree(                           /* free a block                         */
SMBHANDLE smb,                     /*   block control struct               */
SMBPTR ref);                       /*   buffer to receive reference        */

#ifdef GCDOS

VOID *                             /*   ptr to block in cache, NULL if err */
smbGet(                            /* get pointer a block                  */
SMBHANDLE smb,                     /*   block control struct               */
SMBPTR ref);                       /*   block to get                       */

#ifdef DEBUG

GBOOL
smbIsValidBlock(                   // is this a valid block pointer?
SMBHANDLE smb,                     //   block control struct
SMBPTR ref);                       //   block to check

#endif // DEBUG

#else // GCDOS

#define smbGet(smb,ref) (ref)

#ifdef DEBUG
#define smbIsValidBlock(smb,ref) (ref != NULL)
#endif // DEBUG

#endif // GCDOS

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __SMBLOCK_H
