/***************************************************************************
 *                                                                         *
 *   WGMHSCFG.C                                                            *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Config file editor for OUTPOST program.  Uses file OUTPOST.CFG.       *
 *   (was BBSPCFG.C)                                                       *
 *                                                                         *
 *                                        - R. Skurnick 3/21/92            *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"

#define FILREV "$Revision: 3 $"

VOID getdata(VOID);
VOID savdata(VOID);
INT stpnew(CHAR *dirptr,CHAR *olddir);
VOID getbbs(VOID);
VOID getsmt(VOID);
GBOOL chkkey(INT c);
VOID exitpgm(VOID);

#define XPOS   42
#define BBSY    8
#define SMTY   10

INT oldx,                          /* save x position on invocation        */
    oldy;                          /* save y position on invocation        */

INT state;                         /* what field is being edited           */

static CHAR dosscn[GVIDSCNSIZ];    /* saved DOS screen image               */
extern CHAR scntbl[][GVIDSCNSIZ];  /* array of screens (c/o MAKESCNS)      */

CHAR bbsdir[30],                   /* Dir to write BBS bound messages      */
     oldbbs[30],                   /* Old dir to write BBS bound messages  */
     smtdir[30],                   /* Dir for submitting "BAD" messages    */
     oldsmt[30];                   /* Old dir for submitting "BAD" messages*/

FILE *fp;                          /* file pointer for config file         */
CHAR *fname="OUTPOST.CFG";         /* config file name                     */

INT
main(VOID)                         /* main driver                          */
{
TRY
     initvid();
     scn2mem(dosscn,0,GVIDSCNSIZ);
     oldx=curcurx();
     oldy=curcury();
     monorcol();
     cvtscn(scntbl[0]);
     getdata();
     explodeto(scntbl[0],0,0,78,14,1,6);
     prat(XPOS,BBSY,"%s",bbsdir);
     prat(XPOS,SMTY,"%s",smtdir);
     while (TRUE) {
          switch (state) {
          case 0:
               getbbs();
               break;
          default:
               getsmt();
          }
     }
EXCEPT
}

VOID
getdata(VOID)                      /* get existing data if any             */
{
     if ((fp=fopen(fname,FOPRA)) != NULL) {
          fgets(bbsdir,sizeof(bbsdir)-1,fp);
          if (stpnew(bbsdir,oldbbs) != 0) {
               fclose(fp);
               return;
          }
          strcpy(oldbbs,bbsdir);
          fgets(smtdir,sizeof(smtdir)-1,fp);
          stpnew(smtdir,oldsmt);
          fclose(fp);
     }
}

VOID
savdata(VOID)                      /* save data                            */
{
     if ((fp=fopen(fname,FOPWA)) == NULL) {
          catastro("Unable to open \"%s\" for writing",fname);
     }
     fprintf(fp,"%s\n",unpad(bbsdir));
     fprintf(fp,"%s\n",unpad(smtdir));
     fclose(fp);
     exitpgm();
}

INT
stpnew(                            /* strip newline character if any       */
CHAR *dirptr,
CHAR *oldptr)
{
     CHAR *ptr;

     if ((ptr=strchr(dirptr,'\n')) == NULL) {
          dirptr='\0';
          return(1);
     }
     *ptr='\0';
     strcpy(oldptr,dirptr);
     return(0);
}

VOID
getbbs(VOID)                       /* get the bbs directory name           */
{
     do {
          if (edtval(XPOS,BBSY,sizeof(bbsdir),bbsdir,chkkey,
                    (ALLCAPS+USEPOFF))) {
               if (isvaldn(bbsdir)) {
                    state=!state;
                    return;
               }
               else {
                    printf("\7");
               }
          }
          else {
               strcpy(bbsdir,oldbbs);
               prat(XPOS,BBSY,"%s",bbsdir);
          }
     } while (1);
}

VOID
getsmt(VOID)                       /* get the smt directory name           */
{
     do {
          if (edtval(XPOS,SMTY,sizeof(smtdir),smtdir,chkkey,
                    (ALLCAPS+USEPOFF))) {
               if (isvaldn(smtdir)) {
                    state=!state;
                    return;
               }
               else {
                    printf("\7");
               }
          }
          else {
               strcpy(smtdir,oldsmt);
               prat(XPOS,SMTY,"%s",smtdir);
          }
     } while (1);
}

GBOOL
chkkey(                            /* check for valid input                */
INT c)
{
     if (edtvalc == ALT_X) {
          exitpgm();
     }
     if (edtvalc == ALT_S) {
          if (isvaldn(unpad(bbsdir)) && isvaldn(unpad(smtdir))) {
               savdata();
          }
          return(FALSE);
     }
     return((c == '.' || isvalds(c) || isvalfc(c)) && c != '*' && c != '?');
}

VOID
exitpgm(VOID)                      /* exit the program                     */
{
     mem2scn(dosscn,0,GVIDSCNSIZ);
     locate(oldx,oldy);
     clsvid();
     exit(0);
}
