#define NAMESIZE      9            /* Size off Names +1                    */
#define PWSIZE       10            /* Size off passwords                   */
#define DSCRSIZE     25            /* Size of descriptions                 */
#define SERLEN       15            /* Size of serial numbers               */
#define PHONESIS     40            /* Size of phone numbers                */
#define ENTRYSIZE   128            /* Size of NETDIR records               */


struct hdrentry {
     char e_etype;                 /* 00H is placed in this header         */
     char s_conz;                  /* ^Z: (to prevent DOS TYPE)            */
     char s_hname[NAMESIZE];       /* This host's name                     */
     char s_hpass[PWSIZE];         /* Password for access to other hubs    */
     char s_hfull[DSCRSIZE];       /* This host's description              */
     char s_admin[NAMESIZE];       /* This host's admin name               */
     char s_print[NAMESIZE];       /* This host's default printer          */
     char s_modem[NAMESIZE];       /* This host's default modem            */
     unsigned s_port;              /* This host's default modem port (1or2)*/
     char s_notinw;                /* Is this host in a multihost Workgroup*/
     char s_entprs[NAMESIZE];      /* Not supported                        */
     char s_pad1[3];               /* Reserved                             */
     char s_htype;                 /* Type of this host                    */
     char s_prhub[NAMESIZE];       /* Primary Hub                          */
     char s_baud;                  /* Speed of s_port                      */
     char s_serial[SERLEN];        /* Serial number                        */
     unsigned s_nlocal;            /* Number of local users                */
     char s_version;               /* SMF version                          */
     char s_netw[NAMESIZE];        /* Network Name                         */
     char s_nopthr;                /* Pass through HUB                     */
};

