/***************************************************************************
 *                                                                         *
 *   GALQSCVT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Quickscan data file conversion utility.                               *
 *                                                                         *
 *                                           - J. Alvrus    7/1/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"
#include "gme.h"
#include "dfcapi.h"

_NOSCNS_                           /* keep DFCDISP.C happy                 */

#define DSTDAT ((struct qscfg *)dstbb->data) /* cast for dest data file    */

static VOID supFlags(CHAR *argv[],INT *srcflg,INT *dstflg);

INT
main(INT argc,CHAR *argv[])
{
     INT i,cvtflg,nforums,srcflg=0,dstflg=0;
     GBOOL fnd,haveSpare;
     LONG dfree,dneed;
     ULONG currec,totrec;
     CHAR *oldnam;
     struct ffblk fb;
     struct fmidky *fmptr;

TRY
     initvid();
     if (argc < REQNARG) {
          catastro("GALQSCVT: Incorrect number of arguments!");
     }
     dfcDspInit(NOSHOWIN);
     haveSpare=TRUE;
     oldnam="GALQSCAN.DAT";
#ifdef GCWINNT
     if (sameas(getUpdType(),"3.0 to NT")) {
          haveSpare=FALSE;
          rename("galqsc2.dat",oldnam="GALQSC2.D_T");
     }
#endif
     dfree=dskfre(NULL);
     if (!fndfile(&fb,oldnam,0)) {
          catastro("Quickscan data file does not exist:  %s",oldnam);
     }
     dneed=fb.ff_fsize/1024;
#ifdef GCWINNT
     dneed=dneed+dneed/5;          /* ratio approximately 1.2 */
#endif
     if (dfree < dneed) {
          catastro("Insufficient disk space to convert quickscan data file.\n"
                   "(%ld k free, %ld k required)",dfree,dneed);
     }
     if (!dfaVirgin("galqsc2",NULL)) {
          catastro("Unable to create new data file: galqsc2.dat");
     }
     dfaMode(ACCLBV);
     dstbb=dfaOpen("galqsc2.dat",qsrlen(MAXNQSF),NULL);
     dfaMode(PRIMBV);
     srcbb=dfaOpen(oldnam,16384,NULL);
     currec=0L;
     totrec=dfaCountRec();
     supFlags(argv,&srcflg,&dstflg);
     for (fnd=dfaStepLO(NULL) ; fnd ; fnd=dfaStepNX(NULL)) {
          dfcDspRecs(++currec,totrec);
          memset(dstbb->data,0,qsrlen(MAXNQSF));
          takeInit(srcbb->data,dfaLastLen(),srcflg,dstflg);
          cvtflg=takeChar(DSTDAT->userid,UIDSIZ);
          cvtflg&=takeChar(DSTDAT->fwdee,MAXADR);
          cvtflg&=takeShort(&DSTDAT->fwdate,1);
          cvtflg&=takeChar(DSTDAT->kwds,MAXSKWD);
          cvtflg&=takeShort(&DSTDAT->curfor,1);
          cvtflg&=takeShort(&DSTDAT->nforums,1);
          cvtflg&=takeShort(&DSTDAT->flags,1);
          cvtflg&=takeLong(&DSTDAT->stmsg,1);
          if (haveSpare) {
               cvtflg&=takeChar(NULL,26);         /* old spare space */
          }
          if ((nforums=DSTDAT->nforums) != 0) {
               fmptr=(struct fmidky *)DSTDAT->accmsg;
               for (i=0 ; i < nforums ; ++i) {
                    cvtflg&=takeShort(&fmptr[i].forum,1);
                    cvtflg&=takeLong(&fmptr[i].msgid,1);
               }
               memset(&fmptr[nforums],0xFF,(nforums+1)/2);
               cvtflg&=takeChar((CHAR *)&fmptr[nforums],0); /* access lvls */
          }
          if (cvtflg&1) {
               dfaSetBlk(dstbb);
               dfaInsertV(NULL,qsrlen(nforums));
          }
          dfaSetBlk(srcbb);
     }
     dfaClose(srcbb);
     dfaClose(dstbb);
     dfcClrRecs();
     clsvid();
EXCEPT
     return(0);
}

static VOID
supFlags(                               /* set up conversion flags         */
CHAR *argv[],                           /*   cmd line parms                */
INT *srcflg,                            /*   source conversion flags       */
INT *dstflg)                            /*   dest conversion flags         */
{
     if (sameas(argv[SRCPKDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          catastro("GALQSCVT: Unable to perform conversion: "
                  "SourcePacked not specified!");
     }
     if (sameas(argv[SRCPKDIDX],"yes")) {
          *srcflg|=CVTPACKED;
     }
     if (sameas(argv[SRCBORDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          catastro("GALQSCVT: Unable to perform conversion: "
                  "SourceByteOrder not specified!");
     }
     if (sameas(argv[SRCBORDIDX],"big")) {
          *srcflg|=CVTBIGEND;
     }
     if (sameas(argv[DSTPKDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          catastro("GALQSCVT: Unable to perform conversion: "
                  "DestPacked not specified!");
     }
     if (sameas(argv[DSTPKDIDX],"yes")) {
          *dstflg|=CVTPACKED;
     }
     if (sameas(argv[DSTBORDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          catastro("GALQSCVT: Unable to perform conversion: "
                  "DestByteOrder not specified!");
     }
     if (sameas(argv[DSTBORDIDX],"big")) {
          *dstflg|=CVTBIGEND;
     }
}
