/***************************************************************************
 *                                                                         *
 *   GMEOFF.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains routines necessary to use the GME in offline       *
 *   utilities.                                                            *
 *                                                                         *
 *                                           - J. Alvrus   6/9/94          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gme.h"
#include "gmeutl.h"
#include "gmeloc.h"
#include "gmeoff.h"

#define FILREV "$Revision: 11 $"

static GBOOL gmeinit=FALSE;        /* has init__galme() been called yet?   */
static ULONG cyccntr=0L;           /* system cycle counter                 */
INT nterms;                        /* number of channels (always 1)        */
struct sysvbl sv;                  /* global system vars (loaded and saved)*/
static DFAFILE *svbb;              /* Btrieve file ptr for system vars     */

VOID
init__galme(VOID)                  /* GME initialization function          */
{
     if (!gmeinit) {
          gmeinit=TRUE;
          nterms=1;
          svbb=dfaOpen("wgsvbl2.dat",sizeof(struct sysvbl),NULL);
          stzcpy(sv.key,"key",sizeof(sv.key));
          dfaGetEQ(&sv,sv.key,0);
          inimsg(OPTSIZE);
          iniutl();
          iniloc();
          inidft();
     }
}

VOID
clsogme(                           /* close down offline GME               */
GBOOL updfors)                     /*   update all the Forums on disk?     */
{
     clsloc(updfors);
     clsutl();
     dfaSetBlk(svbb);
     dfaGetEQ(NULL,sv.key,0);
     dfaUpdateV(&sv,sizeof(struct sysvbl));
     dfaClose(svbb);
}

GBOOL
gmeoffl(VOID)                      /* is the GME running in offline mode?  */
{
     return(TRUE);
}

CHAR *
getmsg(                            /* get a message                        */
INT msgnum)                        /*   ...by message number               */
{
     return(rawmsg(msgnum));
}

VOID
shocst(                            /* offline stub for the real shocst()   */
const CHAR *tex1,                  /*   first line of audit entry          */
const CHAR *tex2,                  /*   second line of audit entry         */
...)                               /*   printf()-style parameters          */
{
     (VOID)tex1;
     (VOID)tex2;
}

GBOOL                              /*   returns TRUE if a conflict         */
gencfl(                            /* stub for the real gencfl()           */
VOID *pWork,                       /*   pWork area in use                   */
USHORT forum,                      /*   forum ID to check                  */
LONG msgid)                        /*   msg ID to check (0L for forum only)*/
{
     (VOID)pWork;
     (VOID)forum;
     (VOID)msgid;
     return(FALSE);
}

GBOOL                              /*   was lock successful?               */
gmelok(                            /* stub for the real gmelok()           */
VOID *pWork,                       /*   work area associated w/lock        */
USHORT forum,                      /*   forum ID to lock                   */
LONG msgid)                        /*   message ID to lock                 */
{
     (VOID)pWork;
     (VOID)forum;
     (VOID)msgid;
     return(TRUE);
}

VOID
gmeulk(                            /* stub for the real gmeulk()           */
VOID *pWork,                       /*   work area associated w/lock        */
USHORT forum,                      /*   forum ID to unlock                 */
LONG msgid)                        /*   message ID to unlock               */
{
     (VOID)pWork;
     (VOID)forum;
     (VOID)msgid;
}

VOID
gmeulkr(                           /* stub for the real gmeulkr()          */
VOID *pWork)                       /*   work area associated w/request     */
{
     (VOID)pWork;
}

ULONG
cyccnt(VOID)                       /* get system cycle count               */
{
     return(++cyccntr);
}

INT                                /*   returns updated hook index         */
notnwml(                           /* stub for new message notification    */
INT curidx,                        /*   current hook index (NOIDX == first)*/
const struct message *msg,         /*   header of new message              */
const CHAR *text,                  /*   message text                       */
const CHAR *appinf)                /*   app-defined info ("" if none)      */
{
     (VOID)curidx;
     (VOID)msg;
     (VOID)text;
     (VOID)appinf;
     return(NOIDX);
}

INT                                /*   returns updated hook index         */
notnwf(                            /* handle new forum notification hooks  */
INT curidx,                        /*   current hook index (NOIDX == first)*/
const struct fordsk *newdef,       /*   new forum definition structure     */
const CHAR *desc,                  /*   descriptive text                   */
const CHAR *echoes)                /*   pointer to array of echo addresses */
{
     (VOID)curidx;
     (VOID)newdef;
     (VOID)desc;
     (VOID)echoes;
     return(NOIDX);
}

INT                                /*   returns updated hook index         */
notnwg(                            /* handle new forum notification hooks  */
INT curidx,                        /*   current hook index (NOIDX == first)*/
const struct forgrp *grpbuf)       /*   new forum group structure          */
{
     (VOID)curidx;
     (VOID)grpbuf;
     return(NOIDX);
}

INT                                /*   returns updated hook index         */
notmdf(                            /* handle forum update notification     */
INT curidx,                        /*   current hook index (NOIDX == first)*/
const struct fordef *def,          /*   forum definition structure         */
const CHAR *desc,                  /*   descriptive text                   */
const CHAR *echoes)                /*   pointer to array of echo addresses */
{
     (VOID)curidx;
     (VOID)def;
     (VOID)desc;
     (VOID)echoes;
     return(NOIDX);
}

INT                                /*   returns updated hook index         */
notmodg(                           /* handle group modify notification     */
INT curidx,                        /*   current hook index (NOIDX == first)*/
const struct forgrp *grpbuf)       /*   new forum group structure          */
{
     (VOID)curidx;
     (VOID)grpbuf;
     return(NOIDX);
}

VOID
notdlm(                            /* handle message delete notification   */
INT deltyp,                        /*   delete type code                   */
VOID *pWork,                       /*   work area in use                   */
struct message *msg,               /*   header of new message              */
const CHAR *text)                  /*   message text                       */
{
     (VOID)deltyp;
     (VOID)pWork;
     (VOID)msg;
     (VOID)text;
}

VOID
notdlml(                           /* low-level message delete notification*/
USHORT forum,                    /*   forum ID                           */
LONG msgid)                        /*   message ID                         */
{
     (VOID)forum;
     (VOID)msgid;
}

VOID
notdlf(                            /* forum delete notification stub       */
const struct fordsk *def,          /*   forum definition structure         */
const CHAR *desc,                  /*   descriptive text                   */
const CHAR *echoes)                /*   pointer to array of echo addresses */
{
     (VOID)def;
     (VOID)desc;
     (VOID)echoes;
}

INT                                /*   returns updated hook index         */
notdlfl(                           /* low-level forum delete notification  */
INT curidx,                        /*   current hook index (NOIDX == first)*/
USHORT forum)                      /*   forum ID of deleted forum          */
{
     (VOID)curidx;
     (VOID)forum;
     return(NOIDX);
}

VOID
notdlg(                            /* handle group delete notification     */
const struct forgrp *grpbuf)       /*   new forum group structure          */
{
     (VOID)grpbuf;
}

INT                                /*   returns updated hook index         */
notdlgl(                           /* low-level group delete notification  */
INT curidx,                        /*   current hook index (NOIDX == first)*/
USHORT grpid)                      /*   group ID of deleted group          */
{
     (VOID)curidx;
     (VOID)grpid;
     return(NOIDX);
}

INT                                /*   returns index or NOIDX if not found*/
nexthook(                          /* find next GME hook stub              */
INT hooktype,                      /*   of a given type                    */
INT curidx)                        /*   after this index (NOIDX == first)  */
{
     (VOID)hooktype;
     (VOID)curidx;
     return(NOIDX);
}

VOID
clsdist(                           /* stub for the real clsdist()          */
VOID *pWork)                       /*   GME work space (provided by caller)*/
{
     (VOID)pWork;
}
