/***************************************************************************
 *                                                                         *
 *   GMELOC.H                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Galacticomm Messaging Engine local message base manager's *
 *   exported variables, functions, etc.  THESE RESOURCES SHOULD ONLY BE   *
 *   USED BY INTERNAL GME FILES.                                           *
 *                                                                         *
 *                                            - J. Alvrus   6/5/94         *
 *                                                                         *
 ***************************************************************************/

#ifndef __GMELOC_H
#define __GMELOC_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define TMPBSZ 4096                /* size of temporary buffer             */
#define NOGRP ((USHORT)(-1))       /* no-such-group indicator              */

#define DFDFNPV RDAXES             /* default default non-privileged access*/
#define DFDFPRV ULAXES             /* default default privileged access    */
#define DFMXNPV COAXES             /* default maximum non-privileged access*/

                                   /* GME Btrieve file keys                */
#define ETOMKY 0                   /*   E-mail: to + message ID key        */
#define EFRMKY 1                   /*   E-mail: from + message ID key      */
#define ETIDKY 2                   /*   E-mail: thread ID key              */
#define EMIDKY 3                   /*   E-mail: message ID key             */
#define FFMKY  0                   /*   forum: forum ID + message ID key   */
#define FFTKY  1                   /*   forum: forum ID + thread ID key    */
#define FGIDKY 2                   /*   forum: global ID key               */
#define DIDKY  0                   /*   forum def: forum ID key            */
#define DNMKY  1                   /*   forum def: forum name key          */
#define GGIDKY 0                   /*   group: group ID key                */
#define GPNMKY 1                   /*   group: parent ID + name key        */

struct umidky {                    /* User-ID/msgID composite key          */
     CHAR usrid[UIDSIZ];
     LONG msgid;
};

struct etidky {                    /* E-mail threadID/msgID composite key  */
     LONG thrid;
     LONG msgid;
};

struct ftidky {                    /* forumID/threadID/msgID composite key */
     USHORT forum;
     LONG thrid;
     LONG msgid;
};

struct pnamky {                    /* group parent ID/name composite key   */
     USHORT pargrp;
     CHAR name[FORNSZ];
};

struct msgdsk {                    /* on-disk message structure            */
     USHORT forum;                 /*   ID of forum message belongs to     */
     LONG msgid;                   /*   unique message identifier          */
     struct globid gmid;           /*   unique global message identifier   */
     LONG thrid;                   /*   ID of thread message is part of    */
     CHAR from[UIDSIZ];            /*   originator                         */
     CHAR to[UIDSIZ];              /*   recipient                          */
     CHAR topic[TPCSIZ];           /*   main topic, editable, carried over */
     CHAR history[HSTSIZ];         /*   history/routing (reply to #88888,  */
                                   /*     fw by Aaaaaaaaa, cc: of #99999)  */
     CHAR attname[GCSTRFNM];       /*   attached file name                 */
     USHORT crdate;                /*   message creation date              */
     USHORT crtime;                /*   message creation time of day       */
     struct globid rplto;          /*   message that this is a reply to    */
     SHORT nrpl;                   /*   number of times replied to         */
     LONG flags;                   /*   message/attachment flag bits       */
     CHAR info[1];                 /*   variable-length message            */
};                                 /*   text/address/pointer region        */

extern LONG _highmsg;              /* highest message number on system     */

extern INT nfdf;                   /* number of forum data files           */

#ifdef STARTER
#define maxfdf MAXSFORS            /* max forum data files allowed starter */
#else
extern INT maxfdf;                 /* max forum data files allowed by Sysop*/
#endif // STARTER

extern DFAFILE **fdfarr;           /* forum data file array                */

extern GBOOL bgcipg;               /* is background cleanup in progress?   */
extern
DFAFILE *qscbb,                    /* user quickscan data file             */
        *qikbb;                    /* user !QUICK list data file           */
extern VOID *tmpbuf;               /* temporary buffer, one-cycle use only */
extern VOID *usrqs;                /* head of per-user quickscan array     */
extern CHAR *emldp;                /* E-mail data file path and file name  */
extern struct qscfg *utlqsc;       /* GME utility quickscan buffer         */
extern CHAR *utlapi;               /* GME utility app-defined info buffer  */
extern struct ffblk gmefb;         /* for finding files (one-shot only)    */
extern struct forgrp *utlgrp;      /* temporary group info buffer          */

#define qkdptr ((struct qikdat *)(qikbb->data))/* !QUICK dfafile data      */
#define qsdptr ((struct qscfg *)(qscbb->data))/* quickscan file buffer ptr */
#define qsoffln(qsc) ((qsc) == utlqsc)
#define nxtgrp(pargrp,name) getgrpd(RDNEXT,(pargrp),(name))
#define prvgrp(pargrp,name) getgrpd(RDPREV,(pargrp),(name))
#define xctgrp(pargrp,name) getgrpd(RDEXCT,(pargrp),(name))

VOID
iniloc(VOID);                      /* initialize GME local message base    */

VOID
clsloc(                            /* close GME local message base         */
GBOOL updfors);                    /*   update all the Forums on disk?     */

struct fordef *                    /*   returns NULL if doesn't exist      */
getdef(                            /* get pointer to forum definition      */
USHORT fid);                       /*   given forum ID                     */

struct fordef *                    /*   returns NULL if doesn't exist      */
idxdef(                            /* get pointer to forum definition      */
INT idx);                          /*   given def array index              */

struct fordef *                    /*   returns NULL if doesn't exist      */
fiddef(                            /* get pointer to forum definition      */
INT idx);                          /*   given xrf array index              */

struct fordef *                    /*   returns NULL if doesn't exist      */
seqdef(                            /* get pointer to forum definition      */
USHORT seqid);                     /*   given sequence ID                  */

INT                                /*   (returns NOIDX if not found)       */
prvfnmi(                           /* get index of prev forum in def array */
const CHAR *name);                 /*   base forum name                    */

INT                                /*   (returns NOIDX if not found)       */
nxtfnmi(                           /* get index of next forum in def array */
const CHAR *name);                 /*   after this forum name              */

VOID
cleandlf(VOID);                    /* removes all traces of deleted forums */

VOID
cleandla(                          /* clean up after a deleted account     */
const CHAR *userid);               /*   account to clean up after          */

VOID
cpymdef(                           /* copy modifyable part of in-memory def*/
struct fordef *dest,               /*   destination definition             */
const struct fordef *src);         /*   source definition                  */

const CHAR *                       /*   returns pointer to path string     */
attpfn(                            /* attachment path+file name            */
USHORT fid,                        /*   for specified forum                */
LONG mid);                         /*   and message number                 */

const CHAR *                       /*   pointer to static name buffer      */
attnam(                            /* attachment name                      */
LONG mid);                         /*   given message number               */

const CHAR *                       /*   returns pointer to path string     */
attpth(                            /* attachment path                      */
USHORT fid);                       /*   for specified forum                */

GBOOL
needbgc(VOID);                     /* do we need to do background cleanup? */

GBOOL                              /*   keep pumping?                      */
pumpcup(VOID);                     /* pump the normal cleanup process      */

VOID
gmeclean(                          /* do full GME cleanup                  */
GBOOL crashed);                    /*   have we crashed some time today?   */

GBOOL                              /*   returns TRUE if started OK         */
iniqksnd(                          /* start up !QUICK distribution         */
VOID *pWork,                       /*   work area to initialize            */
const CHAR *userid);               /*   user ID to use                     */

GBOOL                              /*   returns TRUE if started OK         */
nxtqik(                            /* get next !QUICK entry                */
VOID *pWork,                       /*   work area to use                   */
CHAR *addr);                       /*   buffer for address                 */

VOID
clsqik(                            /* shut down !QUICK dist                */
VOID *pWork);                      /*   work area used                     */

VOID
setfop(                            /* set the forum-op                     */
USHORT fid,                        /*   for this forum                     */
const CHAR *uid);                  /*   to this user                       */

INT                                /*   returns index of data file in array*/
opnfdf(                            /* open forum data file & add to array  */
const CHAR *name);                 /*   path and file name of data file    */

GBOOL                              /*   return TRUE if file created        */
creatfdf(                          /* create a new forum data file         */
const CHAR *name);                 /*   name of new forum data file        */

GBOOL
fdfisopn(                          /* is forum data file already open?     */
const CHAR *name);                 /*   path+name of forum data file       */

struct forgrp *                    /*   returns NULL if group ID not found */
getgrp(                            /* load & return ptr to group info      */
USHORT grpid);                     /*   group ID to load                   */

struct forgrp *                    /*   returns NULL if not found          */
getgrpd(                           /* directional get group                */
INT rddir,                         /*   dir to read (RDNEXT,RDPREV,RDEXCT) */
USHORT pargrp,                     /*   with this parent                   */
const CHAR *name);                 /*   base group name                    */

VOID
grpfix(                            /* fix up list of forums in a group     */
struct forgrp *grpptr);            /*   group info record                  */

INT                                /*   index in cache array or NOIDX      */
grpinmem(                          /* find a group if already in memory    */
USHORT grpid);                     /*   group ID to find                   */

struct forgrp *
grpbuf(VOID);                      /* get least-recently-used group buf    */

VOID
smemgrp(                           /* re-sort forums for in-memory groups  */
USHORT forum);                     /*   forum ID that changed              */

VOID
rmemgrp(                           /* remove del forum from in-memory grps */
USHORT forum);                     /*   forum ID deleted                   */

CHAR *                             /*   returns pointer to description     */
gme1fdsc(                          /* get forum description                */
USHORT fid);                       /*   given forum ID                     */

VOID
gme1afi(                           /* get all forum info                   */
USHORT forum,                      /*   forum ID to get                    */
struct fordsk *workdef,            /*   on-disk forum definition format    */
CHAR *desc,                        /*   buffer for description             */
CHAR *echoes);                     /*   buffer for echoes                  */

INT                                /*   returns standard GME status codes  */
recfdf(                            /* recommend a forum data file          */
VOID *pWork,                       /*   GME work space (provided by caller)*/
CHAR *recname);                    /*   buffer for recommended name        */

INT                                /*   returns standard GME status codes  */
gme1crf(                           /* create a new forum                   */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct fordsk *newdef,             /*   new forum definition structure     */
const CHAR *desc,                  /*   descriptive text                   */
const CHAR *echoes);               /*   pointer to array of echo addresses */
                                   /*   (may be NULL if no echoes)         */

INT                                /*   returns standard GME status codes  */
gme1dlf(                           /* delete a forum                       */
VOID *pWork,                       /*   GME work space (provided by caller)*/
USHORT forum);                     /*   forum ID to delete                 */

INT                                /*   returns standard GME status codes  */
gme1modf(                          /* modify a forum definition            */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct fordef *newdef,             /*   modified forum description         */
const CHAR *desc,                  /*   descriptive text                   */
const CHAR *echoes);               /*   pointer to array of echo addresses */
                                   /*(desc & echoes may be NULL if no chng)*/

INT                                /*   returns standard GME status codes  */
gme1crg(                           /* create a new group                   */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct forgrp *crtbuf);            /*   group information structure        */

INT                                /*   returns standard GME status codes  */
gme1modg(                          /* modify a group                       */
VOID *pWork,                       /*   GME work space (provided by caller)*/
GBOOL inclfor,                     /*   including a new forum list         */
struct forgrp *grpbuf);            /*   group information structure        */

INT                                /*   returns standard GME status codes  */
gme1mgf(                           /* modify a group's forums              */
VOID *pWork,                       /*   GME work space (provided by caller)*/
USHORT grpid,                      /*   group ID to modify                 */
INT nforums,                       /*   number of forums in list           */
const USHORT *forlst);             /*   new list of forums                 */

INT                                /*   returns standard GME status codes  */
gme1adgf(                          /* add to a group's forums              */
VOID *pWork,                       /*   GME work space (provided by caller)*/
USHORT grpid,                      /*   group ID to modify                 */
USHORT forum);                     /*   new forum ID to add                */

INT                                /*   returns standard GME status codes  */
gme1dlgf(                          /* delete a forum from a group          */
VOID *pWork,                       /*   GME work space (provided by caller)*/
USHORT grpid,                      /*   group ID to modify                 */
USHORT forum);                     /*   forum ID to delete                 */

INT                                /*   returns standard GME status codes  */
gme1delg(                          /* delete a forum group                 */
VOID *pWork,                       /*   GME work space (provided by caller)*/
USHORT grpid);                     /*   group ID to delete                 */

INT                                /*   returns standard GME status codes  */
gme1wnm(                           /* send a new message                   */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
const CHAR *text,                  /*   message body text                  */
const CHAR *filatt);               /*   path+file name of attachment       */

INT                                /*   returns standard GME status codes  */
gme1wap(                           /* write message as pointer to another  */
VOID *pWork,                       /*   GME work space (provided by caller)*/
USHORT orgfor,                     /*   forum ID of original message       */
LONG orgmid,                       /*   message ID of original message     */
GBOOL truecopy,                    /*   is pointer a complete copy?        */
struct message *msg,               /*   message header structure           */
const CHAR *filatt);               /*   path+file name of attachment       */

INT                                /*   returns standard GME status codes  */
gme1rti(                           /* read info on a thread (orig message) */
VOID *pWork,                       /*   GME work space (provided by caller)*/
INT direct,                        /*   direction (0=same, 1=next, -1=prev)*/
USHORT *nmsgs,                     /*   number of messages in thread       */
struct message *msg,               /*   message header structure buffer    */
CHAR *text);                       /*   message body text buffer           */

INT                                /*   returns standard GME status codes  */
gme1rdm(                           /* read a message utility               */
VOID *pWork,                       /*   GME work space (provided by caller)*/
INT direct,                        /*   read direction code                */
struct message *msg,               /*   message header structure buffer    */
CHAR *text);                       /*   message body text buffer           */

INT                                /*   returns standard GME status codes  */
gme1rdg(                           /* read a message given global ID       */
VOID *pWork,                       /*   GME work space (provided by caller)*/
const struct globid *gmid,         /*   global message ID of parent        */
struct message *msg,               /*   message header structure buffer    */
CHAR *text);                       /*   message body text buffer           */

GBOOL
gidxst(                            /* does message with global ID exist    */
USHORT forum,                      /*   in this forum                      */
const struct globid *globid);      /*   with this global ID                */

GBOOL                              /*   returns TRUE if could get message  */
grabmsg(                           /* grab message using file position     */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
CHAR *text);                       /*   message body text buffer           */

GBOOL                              /*   returns TRUE if update successful  */
updmsg(                            /* update message on disk               */
VOID *pWork,                       /*   GME work space (provided by caller)*/
const struct message *msg,         /*   message header structure buffer    */
const CHAR *text,                  /*   message body text buffer           */
const CHAR *appinf);               /*   app-defined info buffer            */

GBOOL                              /*   returns TRUE if delete successful  */
gme1dlm(                           /* delete message (and attachment)      */
VOID *pWork);                      /*   GME work space (provided by caller)*/

VOID
estctx(                            /* establish read context               */
struct rdctx *rdctx,               /*   context structure to establish     */
const struct message *msg);        /*   message to use as context          */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __GMELOC_H                           */
