/***************************************************************************
 *                                                                         *
 *   GALEMCVT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   E-mail Message Data File Conversion utility.                          *
 *                                                                         *
 *                                           - J. Alvrus    7/1/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"
#include "gme.h"
#include "gmeutl.h"
#include "gmeloc.h"
#include "dfcapi.h"

_NOSCNS_                           /* keep DFCDISP.C happy                 */

GBOOL keepflg=TRUE;                /* keep old data file                   */

extern size_t cvtmsg(struct msgdsk *dst,VOID *src,size_t srclen,
                     INT srcflg,INT dstflg,GBOOL src20);

static VOID supFlags(CHAR *argv[],INT *srcflg,INT *dstflg);

INT
main(INT argc,CHAR *argv[])
{
     size_t reclen;
     GBOOL fnd,src20;
     LONG dfree,dneed;
     ULONG currec,totrec;
     CHAR *cp,srcpth[GCMAXPTH],dstpth[GCMAXPTH],renpth[GCMAXPTH+1];
     CHAR oldnam[GCMAXFNM],newnam[GCMAXFNM];
     FILE *fp;
     struct ffblk fb;
     INT srcflg=0,dstflg=0;

TRY
     initvid();
     if (argc < REQNARG) {
          catastro("GALEMCVT: Incorrect number of arguments!");
     }
     dfcDspInit(NOSHOWIN);
     src20=TRUE;
#ifdef GCWINNT
     if (sameas(getUpdType(),"3.0 to NT")) {
          src20=FALSE;
     }
#endif
     if (argc > KEEPIDX && sameas(argv[KEEPIDX],"discard")) {
          keepflg=FALSE;
     }
     *renpth='\0';
     if ((fp=fopen(CVTCFGFIL,FOPRA)) != NULL) {
          if (fgets(renpth,sizeof(renpth),fp) != NULL) {
               if (*(cp=renpth+strlen(renpth)-1) == '\n') {
                    *cp--='\0';
               }
               if (*cp != SL) {
                    *++cp=SL;
                    *++cp='\0';
               }
          }
          fclose(fp);
     }
     stlcpy(srcpth,mstscan("galme.msg",src20 ? "EMLDPTH" : "EMLDPTH2",GCMAXPTH),
            GCMAXPTH);
     reclen=strlen(renpth);
     fileparts(GCPART_FNAM,srcpth,renpth+reclen,GCMAXPTH-reclen);
     fileparts(GCPART_PATH,srcpth,dstpth,GCMAXPTH);
     stlcat(dstpth,"galeml",GCMAXPTH);
     cp=dstpth+strlen(dstpth);
     reclen=2;
     do {
          *(cp+1)='\0';
          *cp='0'+reclen++;
          if (reclen > 9) {
               normspec(dstpth,srcpth);
               fileparts(GCPART_PATH,dstpth,dstpth,GCMAXPTH);
               catastro("Unable to create new E-mail message data file.\n"
                        "Too many similarly named files in %s",dstpth);
          }
          stlcat(dstpth,".dat",GCMAXFNM);
     } while (isfile(dstpth));
     dfcDspFiles(strupr(fileparts(GCPART_FNAM,srcpth,oldnam,GCMAXFNM)),
                 strupr(fileparts(GCPART_FNAM,dstpth,newnam,GCMAXFNM)));
     dfree=dskfre(NULL);
     if (!fndfile(&fb,srcpth,0)) {
          catastro("E-mail data file %s does not exist!",srcpth);
     }
     dneed=fb.ff_fsize/1024;
     if (dfree < dneed) {
          catastro("Insufficient disk space to convert E-mail data file:\n"
                   "%s (%ld k free, %ld k required)",srcpth,dfree,dneed);
     }
     *(cp=&dstpth[strlen(dstpth)-4])='\0';
     if (!dfaVirgin("galeml2",dstpth)) {
          *cp='.';
          catastro("Unable to create new data file: %s",dstpth);
     }
     *cp='.';
     dfaMode(ACCLBV);
     dstbb=dfaOpen(dstpth,32798U,NULL);
     while (dfaStepLO(NULL)) {
          dfaDelete();
     }
     dfaMode(PRIMBV);
     srcbb=dfaOpen(srcpth,32768U,NULL);
     currec=0L;
     totrec=dfaCountRec();
     supFlags(argv,&srcflg,&dstflg);
     for (fnd=dfaStepLO(NULL) ; fnd ; fnd=dfaStepNX(NULL)) {
          dfcDspRecs(++currec,totrec);
          if ((reclen=cvtmsg((struct msgdsk *)dstbb->data,srcbb->data,
                             dfaLastLen(),srcflg,dstflg,src20)) != 0) {
               dfaSetBlk(dstbb);
               dfaInsertV(NULL,reclen);
          }
          dfaSetBlk(srcbb);
     }
     dfaClose(srcbb);
     dfaClose(dstbb);
     setcnf("EMLDPTH2",dstpth);
     applyem("galme.msg");
     if (keepflg) {
          if (*renpth != '\0' && rename(srcpth,renpth) != 0) {
               movefile(srcpth,renpth);
          }
     }
     else {
          remove(srcpth);
     }
     dfcClrRecs();
     clsvid();
EXCEPT
     return(0);
}

static VOID
supFlags(                               /* set up conversion flags         */
CHAR *argv[],                           /*   cmd line parms                */
INT *srcflg,                            /*   source conversion flags       */
INT *dstflg)                            /*   dest conversion flags         */
{
     if (sameas(argv[SRCPKDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          catastro("GALEMCVT: Unable to perform conversion: "
                  "SourcePacked not specified!");
     }
     if (sameas(argv[SRCPKDIDX],"yes")) {
          *srcflg|=CVTPACKED;
     }
     if (sameas(argv[SRCBORDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          catastro("GALEMCVT: Unable to perform conversion: "
                  "SourceByteOrder not specified!");
     }
     if (sameas(argv[SRCBORDIDX],"big")) {
          *srcflg|=CVTBIGEND;
     }
     if (sameas(argv[DSTPKDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          catastro("GALEMCVT: Unable to perform conversion: "
                  "DestPacked not specified!");
     }
     if (sameas(argv[DSTPKDIDX],"yes")) {
          *dstflg|=CVTPACKED;
     }
     if (sameas(argv[DSTBORDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          catastro("GALEMCVT: Unable to perform conversion: "
                  "DestByteOrder not specified!");
     }
     if (sameas(argv[DSTBORDIDX],"big")) {
          *dstflg|=CVTBIGEND;
     }
}
