/***************************************************************************
 *                                                                         *
 *   CVTMSG23.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Convert a message from WG v2.0 to WG v3.0 format.                     *
 *                                                                         *
 *                                           - J. Alvrus    7/1/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gme.h"
#include "gmeutl.h"
#include "gmeloc.h"
#include "dfcapi.h"

#define MINMSGREC (fldoff(msgdsk,info)+sizeof(struct fmidky))
                                   /* minimum message record size          */

size_t                             /*   returns size of converted data     */
cvtmsg(                            /* convert message from 2.0 to 3.0 fmt  */
struct msgdsk *dst,                /*   destination buffer                 */
VOID *src,                         /*   source buffer                      */
size_t srclen,                     /*   source length                      */
INT srcflg,                        /*   source conversion flags            */
INT dstflg,                        /*   destination conversion flags       */
GBOOL src20)                       /*   source is 2.0 format               */
{
     INT cvtflg;
     size_t varlen,reclen;
     struct fmidky fmidky;

     memset(dst,0,sizeof(struct msgdsk));
     takeInit(src,srclen,srcflg,dstflg);
     cvtflg=takeShort(&dst->forum,1);
     cvtflg&=takeLong(&dst->msgid,1);
     cvtflg&=takeLong(&dst->gmid.sysid,1);
     cvtflg&=takeLong(&dst->gmid.msgid,1);
     cvtflg&=takeLong(&dst->thrid,1);
     cvtflg&=takeChar(dst->from,UIDSIZ);
     cvtflg&=takeChar(dst->to,UIDSIZ);
     cvtflg&=takeChar(dst->topic,TPCSIZ);
     cvtflg&=takeChar(dst->history,HSTSIZ);
     cvtflg&=takeChar(dst->attname,src20 ? 13 : GCSTRFNM);
     cvtflg&=takeShort(&dst->crdate,1);
     cvtflg&=takeShort(&dst->crtime,1);
     cvtflg&=takeLong(&dst->rplto.sysid,1);
     cvtflg&=takeLong(&dst->rplto.msgid,1);
     cvtflg&=takeShort(&dst->nrpl,1);
     cvtflg&=takeLong(&dst->flags,1);
     if (src20) {
          cvtflg&=takeChar(NULL,27);         /* old spare space */
     }
     if (dst->flags&ISMPTR) {
          cvtflg&=takeShort(&fmidky.forum,1);
          cvtflg&=takeLong(&fmidky.msgid,1);
          memmove(dst->info,&fmidky,sizeof(struct fmidky));
          varlen=sizeof(struct fmidky);
     }
     else {
          varlen=takeleft;
          cvtflg&=takeChar(dst->info,0);
     }
     if (cvtflg&1) {
          if ((reclen=fldoff(msgdsk,info)+varlen) < MINMSGREC) {
               reclen=MINMSGREC;
          }
          return(reclen);
     }
     return(0);
}
