/***************************************************************************
 *                                                                         *
 *   GMECORE.H                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Galacticomm Messaging Engine core shared variables,       *
 *   functions, etc. FOR USE BY GMEUTL.C ONLY                              *
 *                                                                         *
 *                                            - J. Alvrus   6/5/94         *
 *                                                                         *
 ***************************************************************************/

#ifndef __GMECORE_H
#define __GMECORE_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

                                   /* Miscellaneous GME-use strings        */
#define DLKRQS  "key required="    /*   dist list "key req" string         */
#define DLCHGS  "charge=%hd\n"     /*   dist list "surcharge" string       */
#define DFFAPTH "FORUMS"           /*   default forum attachment directory */
#define AUTFWD  "Auto-fwd from %s" /*   auto-forward history string        */
#define CCOF    "cc: of #%s"       /*   carbon copy of history string      */
#define COPYBY  "Copy by %s"       /*   copy by history string             */
#define FWDBY   "Fw by %s"         /*   forwarded by history string        */
#define RPLTO   "Reply to #%s"     /*   reply to history string            */
#define DSTMSG  "Distributed"      /*   !QUICK or !MASS history string     */
#define SDLMSG  "Distributed to %s"/*   Sysop dist list history string     */

struct gmetag {                    /* GME-specific attachment tag structure*/
     LONG mid;                     /*   message ID of message              */
     LONG pos;                     /*   file position of message           */
     LONG chg;                     /*   charge for download                */
     USHORT fid;                   /*   forum in which message is located  */
};

extern INT nexp;                   /* number of registered exporters       */
extern struct exporter **exphlr;   /* array of registered exporters        */

extern CHAR dlstpth[GCMAXPTH];     /* path to sysop distribution lists     */
extern
GBOOL supu2s,                      /* signups generate E-Mail to Sysop?    */
      supe2u,                      /* signups generate E-Mail to user?     */
      ewraud,                      /* audit E-mail messages written?       */
      eupaud,                      /* audit E-mail attachment uploads?     */
      erdaud,                      /* audit E-mail messages read?          */
      ednaud,                      /* audit E-mail attachment downloads?   */
      edaaud,                      /* audit aborted E-mail att downloads?  */
      fwraud,                      /* audit forum messages written?        */
      fupaud,                      /* audit forum attachment uploads?      */
      frdaud,                      /* audit forum message read?            */
      fdnaud,                      /* audit forum attachment downloads?    */
      fdaaud,                      /* audit aborted forum att downloads?   */
      fcrtaud,                     /* audit forum creations?               */
      fmodaud,                     /* audit forum modifications?           */
      fdelaud,                     /* audit forum deletions?               */
      gcrtaud,                     /* audit group creations?               */
      gmodaud,                     /* audit group modifications?           */
      gdelaud,                     /* audit group deletions?               */
      autqsc;                      /* put new forums in quickscan?         */
extern
CHAR *esysuid,                     /* E-mail Sysop User-ID                 */
     *nuemto,                      /* User-ID to whom new user e-mail sent */
     *nuemtp,                      /* topic of new-user E-Mail to sysop    */
     *e2ufrm,                      /* new user e-mail from User-ID         */
     *e2utpc,                      /* topic of new-user E-Mail to user     */
     *e2uatt,                      /* attachment to E-Mail to user         */
     *e2uanm,                      /* name of attachment to new-user E-mail*/
     *rrtpc,                       /* return receipt topic                 */
     *curapi;                      /* current app-defined info buffer      */

VOID
inicore(VOID);                     /* initialize GME core                  */

INT                                /*   returns standard GME status codes  */
gme2scn(                           /* scan for a message                   */
VOID *pWork,                       /*   GME work space (provided by caller)*/
INT direct,                        /*   read direction code                */
struct message *msg,               /*   message header structure buffer    */
CHAR *text);                       /*   message body text buffer           */

GBOOL                              /*   returns TRUE if another forum      */
nxtscnf(                           /* set up for next forum in scan        */
VOID *pWork);                      /*   GME work space (provided by caller)*/

GBOOL                              /*   returns TRUE if another forum      */
prvscnf(                           /* set up for previous forum in scan    */
VOID *pWork);                      /*   GME work space (provided by caller)*/

GBOOL
chkscn(                            /* check if message is in one-time scan */
VOID *pWork,                       /*   GME work space (provided by caller)*/
const struct message *msg,         /*   message header structure buffer    */
const CHAR *text);                 /*   message body text buffer           */

GBOOL                              /*   returns FALSE if invalid search str*/
parsrch(                           /* parse search string                  */
const CHAR *usrstr,                /*   string user typed in               */
CHAR *kwdbuf,                      /*   buffer to store keywords in        */
CHAR *search);                     /*   buffer to store search template    */

const CHAR *                       /*   returns ptr to string buffer       */
hdrstr(                            /* generate msg header string for search*/
const struct message *msg);        /*   message header structure buffer    */

const CHAR *
datlin(                            /* build date/time string               */
USHORT date,                       /*   from DOS packed date               */
USHORT time);                      /*   and DOS packed time                */

const CHAR *
nrstr(                             /* generate "number of replies" string  */
INT nr);                           /*   number of replies                  */

GBOOL
chkwds(                            /* check if a string matches keywords   */
const CHAR *hstr,                  /*   message header to check            */
const CHAR *tstr,                  /*   message text to check              */
const CHAR *kwds,                  /*   ' '-delimited keyword list         */
const CHAR *srch);                 /*   search template string             */

GBOOL
wrdinstr(                          /* is a word in a string?               */
const CHAR *wordstr,               /*   word to search for                 */
const CHAR *srchstr);              /*   string to search in                */

GBOOL
evalkwd(                           /* reduces and/or/not primitive to y/n  */
CHAR *p);                          /*   keyword primitive (!0&(0|!(1^0)))  */

INT                                /*   returns standard GME status codes  */
gme3cc(                            /* send cc:s when writing or replying   */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
const CHAR *text,                  /*   message text                       */
const CHAR *cclist);               /*   list of cc: addresses              */

INT                                /*   returns standard GME status codes  */
gme2dst(                           /* send dist list                       */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
const CHAR *text,                  /*   message body text                  */
const CHAR *filatt);               /*   path+file name of att (if any)     */

INT                                /*   returns standard GME status codes  */
gme2wnm(                           /* send a message                       */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
const CHAR *text,                  /*   message body text                  */
const CHAR *filatt);               /*   path+file name of att (if any)     */

VOID
formrr(                            /* form return receipt message          */
struct message *msg,               /*   message header structure to use    */
CHAR *text);                       /*   text buffer to use                 */

INT                                /*   returns standard GME status codes  */
sndexp(                            /* send a message an exporter           */
VOID *pWork,                       /*   work area in use                   */
const CHAR *to,                    /*   address to send message to         */
const struct message *msg,         /*   new message structure              */
const CHAR *text,                  /*   message body text                  */
const CHAR *filatt);               /*   path+file name of att (if any)     */

GBOOL
iniecho(                           /* start up forum echoing               */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct message *msg);              /*   new message structure              */

INT                                /*   returns standard GME status codes  */
gme1echo(                          /* send message to forum echoes         */
VOID *pWork,                       /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
const CHAR *text,                  /*   message body text                  */
const CHAR *filatt);               /*   path+file name of att (if any)     */

VOID
invecho(                           /* audit invalid echo address           */
const CHAR *addr,                  /*   echo address                       */
const CHAR *fnam);                 /*   forum name                         */

GBOOL
valdest(                           /* is this a valid to address?          */
const CHAR *to,                    /*   to address                         */
USHORT dest);                      /*   destination (forum ID or E-mail)   */

GBOOL                              /*   returns TRUE if a valid address    */
massage(                           /* convert address to final format      */
const CHAR *from,                  /*   User-ID of sender                  */
CHAR *to,                          /*   to address                         */
USHORT dest);                      /*   destination (forum ID or E-mail)   */

GBOOL
valexa(                            /* is this a valid E-mail export addr?  */
const CHAR *to);                   /*   address to check                   */

GBOOL                              /*   returns TRUE if a valid address    */
masexa(                            /* convert export address to proper form*/
const CHAR *from,                  /*   User-ID of sender                  */
CHAR *to);                         /*   address to check                   */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __GMECORE_H                          */
