/***************************************************************************
 *                                                                         *
 *   CHANDIR.H                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Channel-specific directories, named CHANXX, where XX is the hex       *
 *   channel number, 00 to FF.                                             *
 *                                                                         *
 *                                              - R. Stein  7/20/94        *
 *                                                                         *
 ***************************************************************************/

#ifndef __CHANDIR_H
#define __CHANDIR_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#if defined(GCWINNT)
#ifdef __BUILDGALCHDIR
#define CHDIREXP __export
#else
#define CHDIREXP __import
#endif                             /* __BUIDLGALCHDIR                      */
#else
#define CHDIREXP
#endif                             /* GCWINNT                              */

extern CHAR* CHDIREXP chdpfx;      /* channel directory prefix             */
extern LONG CHDIREXP chdsiz;       /* max bytes users allowed to store here*/

VOID
chdmak(VOID);                      /* make a channel directory             */

INT
chdrem(VOID);                      /* remove a channel directory           */
                                   /* returns 0=ok, else=error             */

CHAR *
chdpath(                           /* path of file in current channel dir  */
CHAR *filespec);                   /* file name, wildcard, or NULL=dir name*/

CHAR *
uchdpath(                          /* path of file in a channel directory  */
INT unum,                          /* user number, 0 to nterms-1           */
CHAR *filespec);                   /* file name, wildcard, or NULL=dir name*/

LONG
chdroom(VOID);                     /* find room in current channel dir     */
                                   /* also sets numfils, numbyts, numbytp  */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __CHANDIR_H                          */
