/***************************************************************************
 *                                                                         *
 *   CHANDIR.C                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Channel-specific directories, named CHANXX, where XX is the hex       *
 *   channel number, 00 to FF.                                             *
 *                                                                         *
 *                                              - R. Stein  7/20/94        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "chandir.h"
#include "galchdir.h"

#define FILREV "$Revision: 8 $"

static VOID chdfin(VOID);

static VOID (*oldfin)(VOID);       /* old value of module[0]->finrou       */

HMCVFILE chdmb;                    /* galchdir.mcv file                    */

CHAR *chdpfx;                      /* channel directory prefix             */
LONG chdsiz;                       /* max bytes users allowed to store here*/
CHAR *sysroom;                     /* key required to circumvent CHDSIZ    */

VOID EXPORT
init__galchdir(VOID)
{
     INT unmsav;

     chdmb=opnmsg("galchdir.mcv");
     chdpfx=stgopt(CHDPFX);
     chdsiz=lngopt(CHDSIZ,0,GCMAXLONG);
     sysroom=stgopt(SYSROOM);
     clsmsg(chdmb);
     unmsav=usrnum;
     usrnum=nterms-1;
     chdmak();                     /* make sure CHDPFX will work on chan 00*/
     chdrem();
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          if (isdir(chdpath(NULL))
           && !deldir(chdpath(NULL))) {
               catastro("CANNOT EMPTY THE CHANNEL-SPECIFIC DIRECTORY %s:\n%s",
                        chdpath(NULL),deldirerr);
          }
     }
     usrnum=unmsav;
     oldfin=module[0]->finrou;
     module[0]->finrou=chdfin;
}

VOID EXPORT
initwc__galchdir(VOID)
{
     init__galchdir();
}

VOID
chdmak(VOID)                       /* make a channel directory             */
{
     CHAR *cp;
     struct ffblk fb;

     if (MKDIR(cp=chdpath(NULL)) != 0
      && (!fndfile(&fb,cp,FAMDIR) || !(fb.ff_attrib&FAMDIR))) {
          catastro("Can't make the %s directory "
                   "specified by option CHDPFX",cp);
     }
}

INT
chdrem(VOID)                       /* remove a channel directory           */
{
     return(rmdir(chdpath(NULL)));
}

CHAR *
chdpath(                           /* path of file in current channel dir  */
CHAR *filespec)                    /* file name, wildcard, or NULL=dir name*/
{                                  /* (usrnum implicit input)              */
     return(uchdpath(usrnum,filespec));
}

CHAR *
uchdpath(                          /* path of file in a channel directory  */
INT unum,                          /* user number, 0 to nterms-1           */
CHAR *filespec)                    /* file name, wildcard, or NULL=dir name*/
{
     if (filespec == NULL) {
          return(spr("%s%02X",chdpfx,channel[unum]));
     }
     else {
          return(spr("%s%02X"SLS"%s",chdpfx,channel[unum],filespec));
     }
}

LONG
chdroom(VOID)                      /* find room in current channel dir     */
{                                  /* also sets numfils, numbyts, numbytp  */
     LONG nfree;                   /* In kbytes                            */

     nfree=dskfre(chdpath(NULL));
     if (chdsiz == 0L || haskey(sysroom)) {
          return(nfree > (GCMAXLONG>>10) ? GCMAXLONG : (nfree<<10));
     }
     cntdirs(chdpath(STAR));
     return(min(
                nfree > (GCMAXLONG>>10) ? GCMAXLONG : (nfree<<10),
                (chdsiz-numbytp)));
}

static VOID
chdfin(VOID)                       /* shutdown, try to empty chan-spec dirs*/
{
     INT unmsav;

     unmsav=usrnum;
     for (usrnum=0 ; usrnum < nterms ; usrnum++) {
          deldir(chdpath(NULL));
     }
     usrnum=unmsav;
     (*oldfin)();
}
