/***************************************************************************
 *                                                                         *
 *   TAKE.C                                                                *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Declarations for Take utility.  The Take utility allows you to        *
 *   extract properly converted, typed data from a buffer in a stream-     *
 *   like fashion.                                                         *
 *                                                                         *
 *                                           - J. Alvrus    7/1/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "dfcapi.h"

CHAR *takeptr;                     /* current take API source pointer      */
size_t takeleft;                   /* number of bytes left in take source  */
INT takesf;                        /* source conversion flags              */
INT takedf;                        /* destination conversion flags         */

MARKSOURCE(take);

VOID
takeInit(                          /* initialize take API for new source   */
VOID *src,                         /*   data input source                  */
size_t len,                        /*   length of source                   */
INT srcflg,                        /*   source conversion flags            */
INT dstflg)                        /*   destination conversion flags       */
{
     takeptr=src;
     takeleft=len;
     takesf=srcflg;
     takedf=dstflg;
}

INT                                /*   returns 1 if ok, 0 if overflow     */
takeUtil(                          /* take bytes out of source             */
VOID *dst,                         /*   where to put bytes (NULL to eat)   */
size_t num,                        /*   bytes to take (0 for rest)         */
struct flddef *fda)                /*   FDA to use for conversion          */
{
     if (takeleft == 0 || num > takeleft) {
          takeleft=0;
          return(0);
     }
     if (num == 0) {
          num=takeleft;
     }
     if (dst != NULL) {
          num=cvtData(takeptr,dst,num,fda,takesf,takedf,CHAN_NUL);
     }
     takeptr+=num;
     takeleft-=num;
     return(1);
}
