/***************************************************************************
 *                                                                         *
 *   DFCDISP.C                                                             *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Data file conversion utility functions for managing display.  These   *
 *   utilities all assume that the calling module has the file DFCDSP.SCN  *
 *   linked into it.                                                       *
 *                                                                         *
 *                                           - Bill Hyatt   8/3/96         *
 *                                                                         *
 ***************************************************************************/
#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "dfcapi.h"

INT savcsrx,                       /* saved cursor X position              */
    savcsry,                       /* saved cursor X position              */
    savcsr;                        /* saved cursor type                    */

CHAR dspsavscn[GVIDSCNSIZ],        /* saved screen buffer                  */
     scnatr;                       /* progress window screen attribute     */

MARKSOURCE(dfcdisp);

VOID
dfcDspInit(                        /* init display window, save scn info   */
SHORT scnidx)                      /*   idx of std window in scntbl[]      */
{
     (VOID)scnidx;
}

VOID
dfcDspCvtNum(                      /* display "Converion X of Y"           */
USHORT cvtnum,                     /*   current conversion                 */
USHORT cvttot)                     /*   total conversions                  */
{
     (VOID)cvtnum;
     (VOID)cvttot;
}

VOID
dfcDspCvtDesc(                     /* display conversion description       */
CHAR *cvtdesc)                     /*   description to display             */
{
     dfcDisplayInfo(cvtdesc,NULL,NULL,0);
}

VOID
dfcDspFiles(                       /* display source and destination files */
CHAR *srcdatfil,                   /*   source file name                   */
CHAR *dstdatfil)                   /*   destination file name              */
{
     dfcDisplayInfo(NULL,srcdatfil,dstdatfil,0);
}

VOID
dfcDspRecs(                        /* display "Record X of Y"              */
ULONG currec,                      /*   current record                     */
ULONG totrec)                      /*   total records (NODISP to not disp) */
{
     dfcDisplayStats(totrec,currec);
}

VOID
dfcClrRecs(VOID)                   /* clear record display                 */
{
     dfcDisplayStats(0,0);
}

VOID
dfcDspFin(VOID)                    /* restore screen                       */
{
     dfcDisplayShutdown();
}
