/***************************************************************************
 *                                                                         *
 *   DFCCUST.C                                                             *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Utility routines for custom conversion utilities.                     *
 *                                                                         *
 *                                           - Bill Hyatt   8/5/96         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "dfcapi.h"

#define ERRBUFSZ 512

static
CHAR idstg[GCMAXFNM],                   /* id string passed from caller    */
     errbuf[ERRBUFSZ],                  /* buffer for error messages       */
     **uargv;                           /* args passed to cust util        */

static
GBOOL newgen=FALSE;               /* did dfcCustInitGen create a new file? */

static
CHAR *tmpsrcnam,                     /* tmp name for src dat file, if necc */
     *srcdatfil;      /* ptr to src file name (uargv[SRCIDX] or tmpsrcnam) */

MARKSOURCE(dfccust);

USHORT                                  /*   0=all ok, err otherwise       */
dfcCustInit(                            /* chk things / init environment   */
INT argc,                               /*   # args passed to cust util    */
CHAR *argv[],                           /*   args passed to cust util      */
CHAR *id)                               /*   cust utility id stg           */
{
     CHAR dstnam[GCMAXFILE+1];

     initvid();
     cursiz(GVIDNOCURS);
     dfcDspInit(NOSHOWIN);
     stlcpy(idstg,id,GCMAXFNM);
     uargv=argv;
     errbuf[0]='\0';
     if (argc < REQNARG) {
          sprintf(errbuf,"%s: Incorrect number of arguments!",idstg);
          return(ERR_NARG);
     }
     chkSrcDstNams(uargv[SRCIDX],uargv[DSTIDX],&tmpsrcnam);
     if (tmpsrcnam != NULL && !isfile(tmpsrcnam)) {
          if (rename(uargv[SRCIDX],tmpsrcnam) != 0) {
               sprintf(errbuf,"%s: Source and dest are same, unable to "
                       "rename %s to %s! (Error %d)",idstg,uargv[SRCIDX],
                       tmpsrcnam,errno);
               return(ERR_TMPNAM);
          }
     }
     srcdatfil=tmpsrcnam == NULL ? uargv[SRCIDX] : tmpsrcnam;
     fileparts(GCPART_FILE,uargv[DSTIDX],dstnam,GCMAXFILE+1);
     if (!dfaVirgin(dstnam,NULL)) {
          sprintf(errbuf,"%s: Unable to create new data file: %s",
                  idstg,uargv[DSTIDX]);
          return(ERR_VIR);
     }
     return(0);
}

USHORT                                  /*   0=all ok, err otherwise       */
dfcCustInitGen(                         /* init evironment for gen db cvt  */
INT argc,                               /*   # args passed to cust util    */
CHAR *argv[],                           /*   args passed to cust util      */
CHAR *id)                               /*   cust utility id stg           */
{
     CHAR dstnam[GCMAXFILE+1];

     initvid();
     cursiz(GVIDNOCURS);
     dfcDspInit(NOSHOWIN);
     stlcpy(idstg,id,GCMAXFNM);
     uargv=argv;
     errbuf[0]='\0';
     if (argc < REQNARG) {
          sprintf(errbuf,"%s: Incorrect number of arguments!",idstg);
          return(ERR_NARG);
     }
     chkSrcDstNams(uargv[SRCIDX],uargv[DSTIDX],&tmpsrcnam);
     if (tmpsrcnam != NULL && !isfile(tmpsrcnam)) {
          if (rename(uargv[SRCIDX],tmpsrcnam) != 0) {
               sprintf(errbuf,"%s: Source and dest are same, unable to "
                       "rename %s to %s! (Error %d)",idstg,uargv[SRCIDX],
                       tmpsrcnam,errno);
               return(ERR_TMPNAM);
          }
     }
     srcdatfil=tmpsrcnam == NULL ? uargv[SRCIDX] : tmpsrcnam;
     if (!isfile(uargv[DSTIDX])) {
          fileparts(GCPART_FILE,uargv[DSTIDX],dstnam,GCMAXFILE+1);
          if (!dfaVirgin(dstnam,NULL)) {
               sprintf(errbuf,"%s: Unable to create new data file: %s!",
                       idstg,uargv[DSTIDX]);
               return(ERR_VIR);
          }
          newgen=TRUE;
     }
     if (sameas(uargv[MODULEIDX],NOTSPEC)) {
          sprintf(errbuf,"%s: Unable to perform conversion: "
                  "ModuleName not specified!",idstg);
          return(ERR_MODNAM);
     }
     if (atoi(itemidxd(uargv[RECORDIDX],1,",")) == 0
      && sameas(uargv[USERIDIDX],NOTSPEC)) {
          sprintf(errbuf,"%s: Unable to perform conversion: "
                  "UserID not specified!",idstg);
          return(ERR_USERID);
     }
     return(0);
}

VOID
dfcOpenFiles(                           /* open data files                 */
USHORT srcreclen,                       /*   source record length          */
USHORT dstreclen)                       /*   destination record length     */
{
     dfaMode(ACCLBV);
     dstbb=dfaOpen(uargv[DSTIDX],dstreclen,NULL);
     while (dfaStepLO(NULL)) {
          dfaDelete();
     }
     dfaMode(PRIMBV);
     srcbb=dfaOpen(srcdatfil,srcreclen,NULL);
}

GBOOL                                   /*   TRUE=opened ok                */
dfcOpenFilesGen(                        /* open data files for gen db cvt  */
USHORT srcreclen,                       /*   source record length          */
LONG *srcfsiz,                          /*   size of source data file      */
USHORT dstreclen)                       /*   destination record length     */
{
     struct ffblk fb;

     dfaMode(ACCLBV);
     dstbb=dfaOpen(uargv[DSTIDX],dstreclen,NULL);
     if (newgen) {
          while (dfaStepLO(NULL)) {
               dfaDelete();
          }
     }
     dfaMode(PRIMBV);
     if (!fndfile(&fb,srcdatfil,0)) {
          sprintf(errbuf,"%s: Counldn't find %s!",idstg,srcdatfil);
          return(FALSE);
     }
     *srcfsiz=fb.ff_fsize;
     srcbb=dfaOpen(srcdatfil,srcreclen,NULL);
     return(TRUE);
}

GBOOL                                   /*   TRUE=enough disk space        */
dfcChkDskSpc(                           /* check HD room for conversion    */
ULONG ratiobase)                        /*   base ratio multiplier         */
{
     LONG dfree,spcneed;

     dfree=dskfre(NULL);
     spcneed=(LONG)((ratiobase*atof(uargv[RATIOIDX]))/1024);
     if (dfree < spcneed) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          sprintf(errbuf,"%s: Insufficient disk space to convert data file "
                  "%s!\n(%ldK free, %ldK required)",idstg,srcdatfil,dfree,
                  spcneed);
          return(FALSE);
     }
     return(TRUE);
}

USHORT                                  /*   0=all ok, err otherwise       */
dfcSupFlags(                            /* set up conversion flags         */
INT *srcflg,                            /*   source conversion flags       */
INT *dstflg)                            /*   dest conversion flags         */
{
     if (sameas(uargv[SRCPKDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          sprintf(errbuf,"%s: Unable to perform conversion: "
                  "SourcePacked not specified!",idstg);
          return(ERR_SRCPKD);
     }
     if (sameas(uargv[SRCPKDIDX],"yes")) {
          *srcflg|=CVTPACKED;
     }
     if (sameas(uargv[SRCBORDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          sprintf(errbuf,"%s: Unable to perform conversion: "
                  "SourceByteOrder not specified!",idstg);
          return(ERR_SRCBORD);
     }
     if (sameas(uargv[SRCBORDIDX],"big")) {
          *srcflg|=CVTBIGEND;
     }
     if (sameas(uargv[DSTPKDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          sprintf(errbuf,"%s: Unable to perform conversion: "
                  "DestPacked not specified!",idstg);
          return(ERR_DSTPKD);
     }
     if (sameas(uargv[DSTPKDIDX],"yes")) {
          *dstflg|=CVTPACKED;
     }
     if (sameas(uargv[DSTBORDIDX],NOTSPEC)) {
          dfaClose(srcbb);
          dfaClose(dstbb);
          sprintf(errbuf,"%s: Unable to perform conversion: "
                  "DestByteOrder not specified!",idstg);
          return(ERR_DSTBORD);
     }
     if (sameas(uargv[DSTBORDIDX],"big")) {
          *dstflg|=CVTBIGEND;
     }
     return(0);
}

CHAR *
dfcLastErr(VOID)                        /* return last error message       */
{
     return(errbuf);
}
