############################################################################
## General Rules for Building Worldgroup Files                            ##
############################################################################
.autodepend
.silent
!if $d(NOSILENT)
.nosilent
!endif

############################################################################
## Check for OS and CMP variables                                         ##
############################################################################
!if !$d(OS)
!    error OS environment variable not set!
!endif
!if !$d(CMP)
!    error CMP environment variable not set!
!endif

!if $(OS) == DOS && !$d(BUDOS)
!    message You are not set up to properly build VIR files.
!    message Check your documentation if you would like to build VIR files
!    message from your make files.
     NOVIRS= 
!endif

############################################################################
## Operating system include                                               ##
############################################################################
TEMPDIR   = .\GCBUILD
VIRDIR    = $(TEMPDIR)
RUNDIR    = .
WGSRCDIR  = $(WGDEV)\SRC
WGLIBDIR  = $(WGDEV)\LIB
TOOLDIR   = $(WGDEV)\BIN
MAKDIR    = $(WGSRCDIR)

!if !$d(NUMERRS)
     NUMERRS = 10
!endif

!include $(MAKDIR)\$(OS).MAK

############################################################################
##  Directories, defined by environment variables                         ##
############################################################################
DLIBDIR   = $(TEMPDIR)
OBJDIR    = $(TEMPDIR)
MSGDIR    = .
MSGHDIR   = $(TEMPDIR)
BCRDIR    = .
INCDIR    = $(WGDEV)\INC
STDINC    = $(INCDIR);$(MSGHDIR);$(OSINCDIR)

############################################################################
## Search paths                                                           ##
############################################################################
.path.h =   $(STDINC)
.path.lib = $(TEMPDIR);$(WGLIBDIR)
.path.def = $(TEMPDIR);$(WGLIBDIR)
.path.obj = $(OBJDIR)
.path.exe = $(RUNDIR)
.path.msg = $(TEMPDIR)
.path.dll = $(RUNDIR)
.path.vir = $(VIRDIR)
.path.bcr = $(TEMPDIR)
.path.cfg = $(TOOLDIR)
.path.mak = $(MAKDIR)
.path.dum = $(TOOLDIR)
.path.res = $(TEMPDIR)
.path.rc  = .;$(TEMPDIR)
.path.c   = .;$(TEMPDIR)                     # For screen files            #

###############################################################################
#####          Set up parse files                                         #####
###############################################################################
PARSEFILES =             \
     $(PARSEFILES)       \
     *.msg               \
     *.bcr               \
     *.dmd               \
     *.mdf               \
     *.htm               \
     *.cvt               \
     *.def

MDFFILES =               \
     $(TEMPDIR)\*.dmd    \
     $(TEMPDIR)\*.mdf

HTMLFILES =              \
     $(TEMPDIR)\*.htm

CVTFILES =               \
     $(TEMPDIR)\*.cvt

CVTFILDIR = $(RUNDIR)\wgsdfcvt

HTMLDIR = $(RUNDIR)\webpages


GIFFILES = *.gif
GIFDIR = $(RUNDIR)\webpages\images

JPGFILES = *.jpg

BINFILES = *.bin
BINDIR = $(RUNDIR)

###############################################################################
#####          Compile/Assemble/Link based on OS, MODEL, and DEBUG        #####
###############################################################################
!include $(MAKDIR)\$(CMP).MAK

!if !$d(COMPILER)
!    error "COMPILER environment variable not defined!"
!endif

###############################################################################
#####          For source debugging...                                    #####
###############################################################################
!if $d(SRCDBG)
     PARSEOPTS = $(PARSEOPTS) -DSRCDBG
     CC = $(CC) -v -y
!    if $(OS) == DOS || $(OS) == WG2
          LINK = $(LINK) /v /l
!    else
          LINK = $(LINK) /v
!    endif

!endif

###############################################################################
#####          For special server versions...                             #####
###############################################################################
!if !$d(TIMESTAMP)
     TIMESTAMP = 03:10:00          # Current server version                
!    if $d(WEBCAST)
          TIMESTAMP = 02:00:00     # Current webcast version number        
!    endif
!    if $d(ACTIBASE)
          TIMESTAMP = 01:00:00     # Current ActiBase server version       
!    endif
!endif

#!if !$d(DATESTAMP)
#     DATESTAMP = 01/01/97          # Date of current builds                #
#!    if $d(WEBCAST)
#          DATESTAMP = 01/01/97     # Current webcast date                  #
#!    endif
#!endif

!if $d(WEBCAST)
     PARSEOPTS = $(PARSEOPTS) -DWEBCAST
!elif $d(ACTIBASE)
     PARSEOPTS = $(PARSEOPTS) -DACTIBASE
!else
     PARSEOPTS = $(PARSEOPTS) -DWORLDGROUP
     WORLDGROUP =
!endif
!if $d(GCV30)
     PARSEOPTS = $(PARSEOPTS) -DGCV30
!endif

###############################################################################
#####          For Code Guard debugging...                                #####
###############################################################################
!if $d(CGDBG)
!    if $(OS) == WNT
          CC = $(CC) -v -vG
          LINK = $(LINK) /v
          DLLLIB = $(COMPILER)\lib\cg32.lib $(DLLLIB)
          EXELIB = $(COMPILER)\lib\cg32.lib $(EXELIB)
          STATLIB = $(COMPILER)\lib\cg32.lib $(STATLIB)
!    endif
!endif

###############################################################################
#####          For "mangled" c++ symbols in MAP file                      #####
###############################################################################
!if $d(MANGLE)
     LINK = $(LINK) /Gm
!endif

###############################################################################
#####          For generating ASM output for compiles                     #####
###############################################################################
!if $d(GENASM)
     CC = $(CC) -S
!endif

###############################################################################
#####          For generating STARTER version of certain files            #####
###############################################################################
!if $d(STARTER)
     CC = $(CC) -DSTARTER
!endif

###############################################################################
#####          Miscellaneous useful macro definitions                     #####
###############################################################################
SCNBGN = copy /a $(WGSRCDIR)\scnbgn.c $(TEMPDIR)\$&.c > nul
SCNMAK = &add2c $** $(TEMPDIR)\makescns.$$t $(TEMPDIR)\$&.c > nul
SCNEND = copy /a $(TEMPDIR)\$&.c + $(WGSRCDIR)\scnend.c $(TEMPDIR)\$&.c> nul

!ifdef DEBUG
     DONEMSG = Build Complete! (DEBUG Version)
!else
     DONEMSG = Build Complete!
!endif

###############################################################################
#####               Generates the compiler option file                    #####
###############################################################################
!if $d(DEBUG)
     PARSEOPTS = $(PARSEOPTS) -DDEBUG
!    if $(OS) == DOS || $(OS) == WG2
!         if $(MODEL) == LARGE
               PARSEOPTS = $(PARSEOPTS) -N
!         endif
!    endif
!endif

GCBUILD = tmpbld.bld

###############################################################################
#####          Implicit Rule Definitions                                  #####
###############################################################################
.dum.bld:
#Rename old build file
     if exist $(TEMPDIR)\$&.bld rename $(TEMPDIR)\$&.bld $&.old
#Create current temp build file in another directory
# just in case $(TEMPDIR) does not exist yet
     type &&|
          $(PARSEOPTS)
| > $(TOOLDIR)\tmp.bld
#Sync everything up, delete directory if needed
     galsync $(TOOLDIR)\tmp.bld $(TEMPDIR)\$&.old $(TEMPDIR) -Q
     del $(TOOLDIR)\tmp.bld
#Parse all needed files
     galparsf &&|
          $(PARSEOPTS)
          $(PARSEFILES)
|    $(TEMPDIR) -Q
#save current build options
     type &&|
          $(PARSEOPTS)
| > $(TEMPDIR)\$&.bld
     if exist $(TEMPDIR)\$&.old del $(TEMPDIR)\$&.old
     if exist *.obj galcopy *.obj $(TEMPDIR) -Q
!if $d(BUILD)
     galmkdir $(RUNDIR)
     galparsf &&|
          $(PARSEOPTS)
          $(MDFFILES)
|    $(RUNDIR) -Q -B
     galmkdir $(HTMLDIR)
     galparsf &&|
          $(PARSEOPTS)
          $(HTMLFILES)
|    $(HTMLDIR) -Q -B
     galmkdir $(CVTFILDIR)
     galparsf &&|
          $(PARSEOPTS)
          $(CVTFILES)
|    $(CVTFILDIR) -Q -B
     galmkdir $(GIFDIR)
     galmkdir $(BINDIR)
     galcopy $(GIFFILES) $(GIFDIR) -Q
     galcopy $(JPGFILES) $(GIFDIR) -Q
     galcopy $(BINFILES) $(BINDIR) -Q
!endif

.c.obj:
     $(CC) @&&|
          $(PARSEOPTS)
          $(INCCMD)
          $(INCCMD1)
          $(OBJCMD)
          $(CFIG)
| $<

.cpp.obj:
     $(CC) @&&|
          $(PARSEOPTS)
          $(INCCMD)
          $(INCCMD1)
          $(OBJCMD)
          $(CFIG)
| $<

.c.lst:
     $(CC) -S @&&|
          $(PARSEOPTS)
          $(INCCMD)
          $(INCCMD1)
          $(OBJCMD)
          $(CFIG)
| $<
     tasmx /kh10000 $(TEMPDIR)\$&,nul,$(TEMPDIR)\$&
     del $*.asm

.cpp.lst:
     $(CC) -S @&&|
          $(PARSEOPTS)
          $(INCCMD)
          $(INCCMD1)
          $(OBJCMD)
          $(CFIG)
| $<
     tasmx /kh10000 $(TEMPDIR)\$&,nul,$(TEMPDIR)\$&
     del $*.asm

.def.lib:
     galparse @&&|
          $<
          $(TEMPDIR)\$&.def
          -Q
          $(PARSEOPTS)
|
     $(IMPLIB) $(TEMPDIR)\$& $(TEMPDIR)\$&.def
     del $(TEMPDIR)\$&.def >nul

.msg.h:
     $(TOOLDIR)\galmerge $(MSGHDIR)\$&.msg $(RUNDIR)\$&.msg -Q
     $(TOOLDIR)\wgsmsx $(MSGHDIR)\$&.msg nul $(MSGHDIR)\$&.h

.bcr.vir:
     galmkdir $(VIRDIR)
!if !$d(NOVIRS)
!if "$(VIRSTART)" != ""
     $(VIRSTART)
!endif
     $(VIRPRO) $@ $(TEMPDIR)\$&.bcr
     if exist $&.$(VIRFILLEX) $(VIRFILL) $&.$(VIRFILLEX) $@
!if "$(VIRSTOP)" != ""
     $(VIRSTOP)
!endif
!endif

.rc.res:
     $(COMPILER)\bin\brc32 $(PARSEOPTS) -r -fo $(TEMPDIR)\$&.res $<

.mc.rc:
     $(COMPILER)\sdktools\mc -v $*.mc
     if exist $(TEMPDIR)\$&.rc del $(TEMPDIR)\$&.rc
     move $&.rc $(TEMPDIR)

