/***************************************************************************
 *                                                                         *
 *   INFTVAH.CPP                                                          *
 *   Dynamic Text variables
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "galacth.h"
#include <strstrea.h>

#include "tvb.h"
#include "majorbbs.h"  // for shocst()

#include "inftvah.h"

#define FILREV "$Revision: 2 $"
#define PPFIX "galacth/inftvah/"  // path prefix for DynaFiles and other media
#define NUMTV 20             // number of dynamic text variables

HMCVFILE  inftvmb;           // message file

class tvAgent : public acthAgent {
public:
     tvAgent() : acthAgent("INF text var Agent","tv")
     {
          CHAR *actvcode;

          registerAgent(acthVersion);
          inftvmb  = opnmsg("inftvah.mcv");
          setmbk(inftvmb);
          actvcode = stgopt(ACTVCODE);
          clsmsg(inftvmb);
     }

     acthSynthesis *               //   my session info (NULL=can't)
     newSynthesis(                 // instantiate my Synthesis class
     acthSession *ses);            //   for passing to acthSynthesis's ctor
};

class hloSynthesis : public acthSynthesis { // hello-world response synthesis
public:
     hloSynthesis(acthSession *_ses) : acthSynthesis(_ses) { }

     ACTHCODE                      //   enumerated response (see galacth.h)
     proceed();                    // process request, synthesize response
};

tvAgent thetvAgent;              // the one and only instance of tvAgent

acthSynthesis *                    //   new session-specific structure
tvAgent::newSynthesis(            // instantiate Synthesis class
acthSession *ses)                  //   passed to acthSynthesis's constructor
{
     return(new hloSynthesis(ses));
}

ACTHCODE
hloSynthesis::proceed()            // proceed with HTML synthesis
{
     return(ACTHDONE);
}

static CHAR *tvnam[NUMTV];  // text variable name
static CHAR *tvval[NUMTV];  // text variable value
bool tvAny;                 // True if any text variabnles defined
CHAR tvBuf[4000];
GBOOL strsrep2(CHAR *stg,CHAR *from,CHAR *to);

class tvTVB : public tvbDefinition {
public:
     tvTVB(
     const CHAR *name) : tvbDefinition(name)
     {
          int msg,t;
          registerDef();
          inftvmb  = opnmsg("inftvah.mcv");
          setmbk(inftvmb);
          tvAny=false;
          for (t=0,msg=0; t < 20; t++,msg+=TVNAM02-TVNAM01 ) {
              tvnam[t] = stgopt(msg+TVNAM01);
              tvval[t] = stpans(stgopt(msg+TVVAL01));
              if (tvnam[t][0] != '\0') tvAny=true;
          }
          //for (t=0; t < 20; t++) {
          //    shocst("tvname","%d) %s:%s",t,tvnam[t],tvval[t]);
          //}
          clsmsg(inftvmb);

     }

     virtual GBOOL
     claim(
     const CHAR *nam);

     virtual const CHAR *          // value of variable
     resolve(                      // overriden resolve method
     const CHAR *nam);             // name of variable
};


tvTVB tvTvb("");             // since no name defined, use Claim()

GBOOL
tvTVB::claim(                // claim text variable
const CHAR *nam)             // name of text variable
{
    GBOOL retval=FALSE;

    if (!tvAny) return(retval);  // for speed
    for (int t=0; t < 20; t++) {
        if (sameas(nam,tvnam[t])) retval=TRUE;
    }
    return(retval);
}

const CHAR *                 // value of text variable
tvTVB::resolve(              // resolve text variable
const CHAR *nam)             // name of text variable
{
    for (int t=0; t < 20; t++) {
        if (sameas(nam,tvnam[t])) {
           // Process the [AD] text variable if it's in the dynamic tex variable string.
           // That's the only one we do for now. avoids any infinite loop problems.
           if (samein("[AD]",tvval[t])) {
              strcpy(tvBuf,tvval[t]);
              strsrep2(tvBuf,"[AD]",(char *)textVar("AD"));
              return(tvBuf);
           } else {
              return(tvval[t]);
           }
        }
    }
    return("");
}

GBOOL
strsrep2(                          // replace a stg in a stg w/ a stg (bigger buffer)
CHAR *stg,                         //   the string to search
CHAR *from,                        //   the string to be replaced
CHAR *to)                          //   the string to replace with
{
     static CHAR rs[4000];
     INT loop,len;
     CHAR *o;

     setmem(rs,4000,0);
     len=strlen(o=stg);
     if (len >= 2000) {
          return(FALSE);
     }
     for (loop=0 ; loop < len ; loop++) {
          if (sameto(from,o)) {
               strcat(rs,to);
               strcat(rs,&o[strlen(from)]);
               strcpy(stg,rs);
               return(TRUE);
          }
          rs[loop]=*o++;
     }
     return(FALSE);
}


