/***************************************************************************
 *                                                                         *
 *   USRACC.H                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the user account/billing header file.                         *
 *                                                                         *
 *                                            - T. Stryker 6/24/86         *
 *                                                                         *
 ***************************************************************************/

#ifndef __USRACC_H
#define __USRACC_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#include "ustructs.h"

EXPWGSV(struct usracc*) usaptr;/* user accting block pointer for usrnum    */
EXPWGSV(struct usracc*) othuap;/* gen purp other-user accting data ptr     */
EXPWGSV(struct usracc) acctmp; /* temporary user account storage area      */

struct keyrec {               /* key (or keyring) structure                */
     CHAR userid[UIDSIZ];     /*   User-ID (or keyring name)               */
     CHAR keys[1];            /*   variable length list of key names       */
};

struct uidxrf {                    /* user-id cross reference structure    */
     CHAR xrfstg[XRFSIZ+1];        /*   cross reference string             */
     CHAR userid[UIDSIZ];          /*   user-id for this cross reference   */
#ifdef GCV2
     CHAR spare[6];                /*   former spare space                 */
#endif // GCV2
};

EXPWGSV(struct uidxrf) uidxrf;

EXPWGSV(INT) numcls;          /* total number of classes in system         */
EXPWGSV(USHORT) dtrack;       /* days tracked so far (for statistic avgs)  */

EXPWGSV(struct clstab*) clshead;/* head record for class table             */
EXPWGSV(struct clstab*) clsptr; /* general ptr to class table entry        */

                              /* csbump() return values for immediate bump */
#define BMPDEL -1             /*   user account deleted due to bad class   */
#define BMPAOK  0             /*   user account OK: no immediate bump      */
#define BMPTIM  1             /*   out of time for today                   */
#define BMPLNV  2             /*   user not validated to logon yet         */
#define BMPSNV  3             /*   user not validated to logon after signup*/
#define BMPOTH  4             /*   app-defined error, message in prfbuf    */

EXPWGSV(DFAFILE*) accbb;      /* user account database file ptr             */
EXPWGSV(DFAFILE*) clsbb;      /* class database file ptr                    */

                              /*-- options for decevy() and (*decusr)() ---*/
EXPWGSV(INT) decusn;          /* user number                               */
EXPWGSV(struct user*) decusp; /* user online information (MAJORBBS.H)      */
EXPWGSV(struct usracc*) decuap;/* user account information (USRACC.H)      */
EXPWGSV(LONG) deccst;         /* cost of online time since last (*decusr)()*/
EXPWGSF(VOID,decusr)(VOID);   /* decevy() service vector                   */

/* ACCOUNT.C 03/04/92 11.19.18 */
VOID iniacc(VOID);
struct usracc *uacoff(INT unum);
INT crtclass(struct acclass *cptr);
struct clstab *fndcls(const CHAR *clsname);
VOID swtcls(struct usracc *uacc,GBOOL makprm,const CHAR *clsnam,INT dest,INT days);
INT namacls(CHAR *clsname);
LONG tfcchg(LONG nbytes,LONG credpk);
INT dedcrd(LONG amt,GBOOL asmuch);
INT rdedcrd(LONG amt,GBOOL asmuch);
INT odedcrd(INT unum,LONG amt,GBOOL real,GBOOL asmuch);
INT ndedcrd(const CHAR *uid,LONG amt,GBOOL real,GBOOL asmuch);
INT gdedcrd(const CHAR *uid,LONG amt,GBOOL real,GBOOL asmuch);
INT ldedcrd(struct usracc *uptr,LONG amt,GBOOL real,GBOOL asmuch);
LONG hdedcrd(struct usracc *uptr,LONG amt,GBOOL real,GBOOL asmuch);
INT tstcrd(LONG amt);
INT rtstcrd(LONG amt);
INT otstcrd(INT unum,LONG amt,GBOOL real);
INT ntstcrd(const CHAR *uid,LONG amt,GBOOL real);
INT gtstcrd(const CHAR *uid,LONG amt,GBOOL real);
INT ltstcrd(const struct usracc *uptr,LONG amt,GBOOL real);
VOID dltcls(struct clstab *tabptr);
INT addcrd(CHAR *keyuid,const CHAR *tckstg,GBOOL real);
INT crdusr(CHAR *keyuid,const CHAR *tckstg,GBOOL real,GBOOL affall);
INT saycrd(const CHAR *tckstg,GBOOL real);
VOID cpykey(CHAR *dest,const CHAR *src,INT len);
VOID decevy(VOID);
INT declog(VOID);
INT decsup(VOID);
INT dectdy(VOID);
INT deccal(VOID);
VOID dec15s(VOID);
VOID deccrd(LONG surdsc);
VOID chkliu(VOID);
VOID savvbl(VOID);
INT imbump(GBOOL logon);
INT csbump(GBOOL logon);
INT wtwait(INT lomin,INT himin);
INT nliniu(VOID);
VOID updacc(VOID);
VOID updaccu(struct usracc *puac);
INT accmcu(VOID);
VOID accacct(const struct usracc *accptr,INT plusor);
INT delacct(const CHAR *userid);
INT kiluid(const CHAR *userid);
VOID howbuy(VOID);
VOID clsacc(VOID);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __USRACC_H                           */
