/***************************************************************************
 *                                                                         *
 *   REMOTE.H                                                              *
 *                                                                         *
 *   Copyright (c) 1991-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Header file for use with Remote Sysop stuff                           *
 *                                                                         *
 *                               - S. Brinker & R. Skurnick 3/29/91        *
 *                                                                         *
 *                               (based upon Functions and Utilities by    *
 *                                A. Von Gauss, R. Skurnick, & S. Brinker) *
 *                                                                         *
 ***************************************************************************/

#ifndef __REMOTE_H
#define __REMOTE_H

#include "FIOAPI.H"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#ifdef __BUILDREMSYS
#define EXPRSYV(x)       EXPORT_VARIABLE(EXPORT_TYPE,x)
#define EXPRSYF(x,y)     EXPORT_FUNCTION(EXPORT_TYPE,x,y)
#else
#define EXPRSYV(x)       EXPORT_VARIABLE(IMPORT_TYPE,x)
#define EXPRSYF(x,y)     EXPORT_FUNCTION(IMPORT_TYPE,x,y)
#endif // __BUILDREMSYS

#ifdef GCDOS
#define FNDSIZE     64
#else
#define FNDSIZE     GCMAXPTH
#endif

#ifndef UNIX
#include <sys/stat.h>
#endif                             /* UNIX                                 */

extern INT rmsyst;                 /* remote sysop state number            */

EXPWGSV(INT) kilipg;               /* kill-system command in progress      */
EXPWGSV(INT) errcod;               /* MS-DOS exit codes (for batch files)  */
EXPWGSV(INT) kilsrc;               /* kill-command source (-1=cons, -2=MCU,*/
                                   /* -3=timed event, >=0=chan #)          */
EXPWGSV(INT) kilctr;               /* kill-system in this many minutes     */
EXPWGSV(INT) rsetop;               /* reset option: busy=B; no-answer=N    */
EXPWGSV(INT) chnemd;               /* channel currently being emulated     */
EXPWGSV(INT) rmtsys;               /* remote sysop emul channel (-1 if no) */
EXPRSYV(HMCVFILE) rsymb;           /* Exported Message Block pointer       */
EXPRSYV(INT) rsykil;               /* Export kill timer                    */
EXPRSYV(ULONG) trkflgs;            /* Export tracking flags                */

struct rsysop {                    /* "remote Sysop" data structure        */
     FILE *sfp;                    /*   DOS functions source file pointer  */
     FILE *dfp;                    /*   DOS functions dest. file pointer   */
     LONG fpos;                    /*   DOS functions file position        */
     INT chan;                     /*   scratch channel number             */
     INT rkilctr;                  /*   kilctr for this remote sysop       */
     INT flags;                    /*   bit flags for remote sysop         */
     INT genctr;                   /*   general purpose counter            */
     CHAR dftinp;                  /*   default character handler input    */
     struct usracc acc;            /*   scratch userid buffer              */
     struct ffblk dirblk;          /*   structure used for directory lists */
     CHAR sfname[FNDSIZE];         /*   file name 1 for general use        */
     CHAR dfname[FNDSIZE];         /*   file name 2 for general use        */
     struct clstab *cltptr;        /*   pointer to class table element     */
     CHAR text[MTXSIZ];            /*   general purpose text area          */
};

#define CRTCLS      1              /*   remote sysop is creating a class   */
#define EDTCLS      2              /*   remote sysop is editing a class    */
#define EDTKYR      4              /*   remote sysop is editing a keyring  */

#define rsyptr ((struct rsysop *)vdaptr)
#define remoff(u) ((struct rsysop *)vdaoff(u))

/* REMSYS.C 23/05/92 14.20.58 */
VOID init__remsys(VOID);
GBOOL account(VOID);
VOID rcpydat(VOID);
VOID dspsts(VOID);
VOID dspmdu(VOID);
VOID dspsaa(VOID);
VOID dspcus(VOID);
VOID acsthn(VOID);
VOID emuinp(INT hangup);
VOID clremu(INT unum);
VOID updaxs(VOID);
VOID bgnmon(INT msg,ULONG wch);
VOID rblwof(INT msg);
VOID sisokq(VOID);
VOID dsponl(VOID);
VOID chkdat(INT date);
VOID chkcrd(LONG credits);
VOID xltescp(VOID);
VOID prfaxs(struct usracc *uacptr);
VOID clsfils(VOID);
INT fnamchk(CHAR *touse);
VOID shwdft(VOID);
VOID dspcll(VOID);

/* REMSYS2.C 23/05/92 13.56.52 */
VOID rsop62(VOID);
VOID rsop62a(VOID);
VOID rsop71(VOID);
VOID acczero(VOID);
INT acconex(VOID);
VOID clsrsy(VOID);
extern INT rsyevt(VOID);
INT emuinu(VOID);
INT wrdlen(CHAR *str);
INT anyaxs(struct usracc *uacptr);
VOID zaprsy(VOID);
extern INT ckfnams(CHAR *touse,CHAR *test);
SHORT dwedt11(SHORT flags);
SHORT dwedt12(SHORT flags);
SHORT dwedt13(SHORT flags);
SHORT dwedtj5(SHORT flags);
SHORT dwedtjj(SHORT flags);
VOID ntfysop(CHAR *audrec);
VOID init__galrsy(VOID);
VOID rsprom(INT msg);
/* C/S function declarations */
VOID inicsrsy(VOID);
extern CHAR * stpname(CHAR *fname);
extern CHAR * makpath(CHAR *fname);
extern CHAR * stppath(CHAR *fname);
extern CHAR * fixfil(CHAR *fname);
extern GBOOL iswild(CHAR *fname);
extern CHAR * rtmfmt(ULONG ntval);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __REMOTE_H                           */
