/***************************************************************************
 *                                                                         *
 *   GCTYPDEF.H                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Various type definitions.                                             *
 *                                                                         *
 *                                        - Craig Yap 01/10/96             *
 *                                                                         *
 ***************************************************************************/

#ifndef __GCTYPDEF_H
#define __GCTYPDEF_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#if defined( WIN32 ) && ! defined( GCWINNT )
#    define   GCWINNT
#endif

#if defined(UNIX)
#undef _FARFUNC
#undef _Cdecl
#undef _FAR
#undef far
#undef huge
#undef EXPORT
#define _FARFUNC
#define _Cdecl
#define _FAR
#define FAR
#define huge
#define EXPORT
#undef INT
#undef UINT

#elif defined(GCWINNT)
#    if ! defined( _FAR )
#         define _FAR
#    endif
#    if ! defined( far )
#         define far
#    endif
#    if ! defined( FAR )
#         define FAR far
#    endif
#    if ! defined( EXPORT )
#         define EXPORT _export
#    endif

#elif defined(GCDOSP)
#define _FAR
#undef FAR
#define FAR
#define EXPORT _export

#elif defined(GCWIN3X)
#define EXPORT _export

#elif defined(GCDOSL)
#define EXPORT
#undef FAR
#define FAR far
#endif // UNIX

#if !defined(CTREE)
#if !defined(GCWIN3X)
typedef unsigned int   UINT;
#endif // GCWIN3X

#ifdef GCOSF3X
typedef int            LONG;
typedef unsigned int   ULONG;
#else
#if defined(GCWIN3X) && MODEL == V
#define LONG           long
#define ULONG          unsigned long
#else
typedef long           LONG;
typedef unsigned long  ULONG;
#endif // GCWIN3X
#endif // GCOSF3X
#endif // CTREE

typedef int            INT;
#if defined(GCWIN3X) && MODEL == V
#define CHAR           char
#define SHORT          short
#define USHORT         unsigned short
#else
typedef char           CHAR;
typedef short          SHORT;
typedef unsigned short USHORT;
#endif // GCWIN3X
typedef unsigned char  UCHAR;
typedef signed char    SCHAR;
#ifndef VOID
#define VOID           void
#endif  // VOID
typedef double         DOUBLE;
typedef float          FLOAT;
typedef short          GBOOL;

#if !defined(TRUE)
#define FALSE 0
#define TRUE  (!FALSE)
#endif

                                   /* maximum values for types             */
#define GCMAXSHORT   (0x7FFF)
#define GCMAXLONG    (0x7FFFFFFFL)
#define GCMAXUSHORT  (0xFFFFU)
#define GCMAXULONG   (0xFFFFFFFFL)

#ifdef GCWINNT
#define GCMAXINT    GCMAXLONG
#define GCMAXUINT   GCMAXULONG
#else
#define GCMAXINT    GCMAXSHORT
#define GCMAXUINT   GCMAXUSHORT
#endif

#if !defined(GCWINNT) && !defined(GCWIN3X)
#define WINAPI
#endif // GCWINNT

#ifdef _MSC_VER
#define IMPORT_TYPE __declspec(dllimport)
#define EXPORT_TYPE __declspec(dllexport)
#define EXPORT_VARIABLE(inout,t)        extern inout t
#define EXPORT_FUNCTION(inout,t,n)      extern inout t (* n)
#else
#ifdef GCWINNT
#define IMPORT_TYPE __import
#define EXPORT_TYPE __export
#define EXPORT_VARIABLE(inout,t)        extern t inout
#define EXPORT_FUNCTION(inout,t,n)      extern t (* inout n)
#else
#define IMPORT_TYPE 
#define EXPORT_TYPE 
#define EXPORT_VARIABLE(inout,t)        extern t
#define EXPORT_FUNCTION(inout,t,n)      extern t (* n)
#endif // GCWINNT
#endif // _MSC_VER

#define IMPORT_VARIABLE(t)              EXPORT_VARIABLE(IMPORT_TYPE,t)
#define IMPORT_FUNCTION(t,n)            EXPORT_FUNCTION(IMPORT_TYPE,t,n)
#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __GCTYPDEF_H
