/***************************************************************************
 *                                                                         *
 *   GALFILH.H                                                             *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Libraries - Header for interface into the File Libraries         *
 *                                                                         *
 *                                                 - D. Pitchford  9/28/93 *
 *                                                                         *
 ***************************************************************************/

#ifndef __GALFILH_H
#define __GALFILH_H

#include "reserve.h"
#include "filexfer.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#ifdef GCWINNT
#ifdef __BUILDGALFIL
#define FILEXP __export
#else
#define FILEXP __import
#endif //__BUILDGALFIL
#else
#define FILEXP
#endif // GCWINNT

#define FLNAMESZ    9              /* size of Library names                */
#define FLDESCSZ   41              /* size of Library descriptions         */
#define FLLDESCS   80              /* size of long Library descriptions    */
#define FLFILENM   13              /* size of filenames                    */
#define FLKEYSIZ   13              /* size of keywords                     */
#define FLKEYLST   79              /* size of keyword string               */
#define FLNMCATS   10              /* number of top-level libs joinable    */
#define PATHSIZE   50              /* size of directory path               */

#ifdef GCV2
#define FLFILREC  105              /* record size of struct flfile & data  */
#else
#define FLFILREC fldoff(flfile,desc)/* record size of struct flfile & data */
#endif // GCV2

#define FLKEYREC   35              /* record size of keyword data          */
#define DATESZ      8              /* size of date, "srt" format           */
#define DESCSIZ   902              /* size of long description of a file   */
#define NLISTER    17              /* number of files to list on screen    */
#define NDESCLN    15              /* number of description lines [fsd]    */
#define SDESCLN    50              /* size of desc line incl. nul term.    */
#define MAXKWDS   200              /* number of keywords per file          */
#define NUMSZ       8              /* size of char array for # of d/ls     */
#define NUMSZP      "%07ld"        /* number of downloads, sprintf template*/
#define NOTAPPED    "0000000"      /* "srt" format date of unapproved file */
#define FLOWSTS    10              /* number of btuchi() calls to stack up */
#define NLDLIN      5              /* number of lines in long description  */
#define ULDAYS      7              /* number of days to count new files    */
#define MISCSIZE   80              /* size of flmisc text variable         */
#define NVIEWS    100              /* number of custom view extensions     */
#define SIZKWBUF   60              /* size of buffer for keyword data      */
#define ALPHALC    50              /* incremental allocation for **alphlibs*/

                                   /* insfile() return codes               */
#define INS_DONE    1              /*   done with file, continue processing*/
#define INS_MOVE    2              /*   need to move file (cycled)         */
#define INS_RENAME  (-1)           /*   query to rename file               */
#define INS_ERROR   (-2)           /*   I/O error trying to move file      */
#define INS_BADNAME (-3)           /*   invalid file name (not DOS 8.3 fmt)*/

struct fluser {                    /* structure for saved user data        */
     CHAR lib[FLNAMESZ];           /* last Library a user was in           */
     CHAR proto[3];                /* default download transfer protocol   */
     SHORT askme;                  /* ask to logoff after default transfer */
     SHORT mytyp;                  /* user preference: search parameters   */
     SHORT mylib;                  /* user preference: current/all libs    */
     SHORT cdayin;                 /* cofdat() date of last Library access */
     CHAR newdate[DATESZ];         /* date user last did the L list option */
#ifdef GCV2
     char spare[22];               /* former spare space                   */
#endif // GCV2
};

struct flusave {                   /* structure for saving user data       */
     CHAR userid[UIDSIZ];          /* User-Id of user data belongs to      */
     CHAR modnam[MNMSIZ];          /* "File Library" module key            */
     struct fluser udata;          /* data to save on above user           */
};

struct fllib {                     /* structure for Library data           */
     CHAR libname[FLNAMESZ];       /* Library name                         */
     LONG flags;                   /* various saved bit flags              */
     SHORT day;                    /* day this Library was created         */
     SHORT time;                   /* time of day this Library was created */
     CHAR libdesc[FLDESCSZ];       /* Library short description            */
     SHORT appwait;                /* number of files awaiting approval    */
     CHAR keyreq[KEYSIZ];          /* key to see files at all              */
     CHAR libop[KEYSIZ];           /* key to be a Lib-Op (blank is OK)     */
     CHAR autoap[KEYSIZ];          /* key to auto-approve uploaded files   */
     CHAR dlkey[KEYSIZ];           /* key to download files                */
     CHAR ulkey[KEYSIZ];           /* key to upload files                  */
     CHAR overw[KEYSIZ];           /* key to overwrite files               */
     CHAR cat[FLNMCATS][FLNAMESZ]; /* top-level Libraries a member of      */
#ifdef GCV2
     CHAR path[PATHSIZE];          /* name of alternate path, if any       */
#else
     CHAR path[GCSTRPTH];          /* name of alternate path, if any       */
#endif // GCV2
     LONG dlchge;                  /* per-file charge for downloads        */
     LONG kdlchge;                 /* per-K charge for downloads           */
     LONG numfiles;                /* number of files in Library           */
     LONG totfiles;                /* number of files in Library + joined  */
     SHORT royal;                  /* royalty percentage                   */
     SHORT libs;                   /* number of joined Libraries           */
     LONG maxfil;                  /* maximum number of files in Library   */
     LONG maxbyt;                  /* maximum number of bytes in Library   */
     LONG maxbup;                  /* maximum upload size to Library       */
     CHAR primary[UIDSIZ];         /* user who is primary Lib-Op           */
     SHORT newfiles[ULDAYS];       /* added files in last x days, [0]=today*/
     LONG totbytes;                /* total number of bytes in Library     */
     USHORT cluster;               /* cluster size of Library drive        */
};

                                   /* a Library's various saved bit flags  */
#define FLGCBD 0x00000001L         /* ...copy-before-download              */
#define FLGRDO 0x00000002L         /* ...read-only lib                     */
#define FLGAUL 0x00000004L         /* ...audit uploads                     */
#define FLGADL 0x00000008L         /* ...audit downloads                   */
#define FLGFDL 0x00000010L         /* ...free downloads                    */
#define FLGFUL 0x00000020L         /* ...free uploads                      */
#define FLGDOS 0x00000040L         /* ...DOS-ONLY Library                  */
#define FLGHID 0x00000080L         /* ...hidden, join-only Library         */
#define LIBCHN 0x00000100L         /* ...Library changed, update soon      */
#define LIBONG 0x00000200L         /* ...ongoing change, update whenever   */

struct libdisk {                   /* structure for saving Library data    */
     struct fllib lib;             /* structure to save                    */
#ifdef GCV2
     char spare[240];              /* former spare space                   */
#endif // GCV2
     CHAR ldesc[NLDLIN][FLLDESCS]; /* long description                     */
};

struct flfile {                    /* structure for individual file data   */
     CHAR libname[FLNAMESZ];       /* Library the file is in               */
     CHAR filname[FLFILENM];       /* the file name of the file            */
     CHAR udate[DATESZ];           /* approval date, in "srt" format       */
     CHAR numdls[NUMSZ];           /* number of downloads, NUMSZP format   */
     CHAR fdate[DATESZ];           /* file date, "srt" format              */
     LONG siz;                     /* file size                            */
     USHORT tim;                   /* file time                            */
     CHAR ulby[UIDSIZ];            /* uploaded by                          */
     USHORT utime;                 /* time of day file was approved        */
#ifdef GCV2
     char spare[FLFILREC-84];      /* former spare space                   */
#endif // GCV2
     CHAR desc[DESCSIZ];           /* variable-length description field    */
};

struct taglib {                    /* structure for file tagging           */
     INT status;                   /* state of this tagged file, see below */
     INT usrnum;                   /* usrnum of tagging user               */
     CHAR libname[FLNAMESZ];       /* actual Library name of tagged file   */
     CHAR filname[FLFILENM];       /* file name of tagged file             */
     CHAR udate[DATESZ];           /* approval date of file, "srt" format  */
     CHAR reflib[FLNAMESZ];        /* reference Library of tagged file     */
     CHAR wldspc[FLFILENM];        /* tag specification for wildcard tags  */
     LONG tagtime;                 /* time(NULL) the file was tagged       */
     LONG size;                    /* size of tagged file                  */
     LONG copied;                  /* amount copied so far                 */
     INT nwld;                     /* number of wildcard files tagged      */
};

                                   /* status values, struct taglib         */
#define TGEMPTY  0                 /* ...empty and ready for new tag       */
#define TGLOCAL  1                 /* ...ready for d/l direct from storage */
#define TGINWAIT 2                 /* ...waiting to be copied              */
#define TGCOPY   3                 /* ...being copied to temp directory    */
#define TGDLTMP  4                 /* ...ready for d/l from temp directory */
#define TGOTHER  5                 /* ...waiting for outside control       */
#define TGSERVER 6                 /* ...under outside control             */
/* a negative value of one of the above definitions indicates completion   */

struct modeview {                  /* structure for file viewing modes     */
     CHAR ext[4];                  /* extension to store view mode for     */
     INT mode;                     /* view mode to use                     */
     VOID (*rouptr)();             /* view routine, if needed              */
};

/* seven structures for composite keys within the union in struct fluson,  */
/* and their corresponding btrieve key numbers                             */

struct key0 {                      /* LIBNAME/UDATE/FILNAME composite key  */
     CHAR libname[FLNAMESZ];
     CHAR udate[DATESZ];
     CHAR filname[FLFILENM];
};
#define COMPLUF  0                 /* btrieve key for above structure      */

struct key1 {                      /* LIBNAME/FILNAME composite key        */
     CHAR libname[FLNAMESZ];
     CHAR filname[FLFILENM];
};
#define COMPLF   1                 /* btrieve key for above structure      */

struct key2 {                      /* KEYWORD/FILNAME/LIBNAME composite key*/
     CHAR keyword[FLKEYSIZ];
     CHAR filname[FLFILENM];
     CHAR libkey[FLNAMESZ];
     CHAR origkey[FLKEYSIZ];       /* reference, not part of key           */
     CHAR libname[FLNAMESZ];       /* reference, not part of key           */
};
#define COMPKFL  0                 /* btrieve key for above structure      */

struct key3 {                      /* UDATE/FILNAME composite key          */
     CHAR udate[DATESZ];
     CHAR filname[FLFILENM];
     CHAR libkey[FLNAMESZ];
     CHAR libname[FLNAMESZ];       /* reference, not part of key           */
};
#define COMPUF   2                 /* btrieve key for above structure      */

struct key4 {                      /* FILNAME/LIBNAME composite key        */
     CHAR filname[FLFILENM];
     CHAR libkey[FLNAMESZ];
     CHAR libname[FLNAMESZ];       /* reference, not part of key           */
     CHAR exactfn[FLFILENM];       /* reference, not part of key           */
};
#define COMPFL   3                 /* btrieve key for above structure      */
#define COMPFL_K 1                 /* btrieve key for above structure(kwd) */

struct key5 {                      /* NUMDLS/LIBNAME/FILNAME composite key */
     CHAR numdls[NUMSZ];
     CHAR libkey[FLNAMESZ];
     CHAR filname[FLFILENM];
     CHAR libname[FLNAMESZ];       /* reference, not part of key           */
};
#define COMPNLF  4                 /* btrieve key for above structure      */

struct key6 {                      /* reference for DOS-Only Libraries     */
     CHAR filname[FLFILENM];
     SHORT date[NLISTER];
     SHORT time[NLISTER];
     LONG size[NLISTER];
};

struct key7 {                      /* structure for keyword insertion      */
     CHAR keyword[FLKEYSIZ];
     CHAR filname[FLFILENM];
     CHAR libname[FLNAMESZ];
};

union srch {                       /* joined Library search key union      */
     struct key0 key0;             /* libname/udate/filname                */
     struct key1 key1;             /* libname/filname                      */
};

union combo {                      /* the file key union                   */
     struct key0 key0;             /* libname/udate/filname                */
     struct key1 key1;             /* libname/filname                      */
     struct key2 key2;             /* keyword/filname/libname              */
     struct key3 key3;             /* udate/filname                        */
     struct key4 key4;             /* filname/libname                      */
     struct key5 key5;             /* numdls/libname/filname               */
     struct key6 key6;             /* DOS-Only reference                   */
};

struct zvdat {                     /* C/S compressed file viewing context  */
     INT state;                    /*   state within, 0=not being used now */
     CHAR libname[FLNAMESZ];       /*   Library name of file being viewed  */
     CHAR filname[FLFILENM];       /*   file name of file being viewed     */
     LONG size;                    /*   size of file being viewed          */
     FILE *fp;                     /*   open file pointer of file viewed   */
     CHAR filid;                   /*   type of compression used           */
     LONG pos;                     /*   current file position              */
};

struct fluson {                    /* "user online" structure              */
     VOID (*rouptr)(struct taglib *);/* miscellaneous function pointer     */
     INT keymeth;                  /* key method used                      */
     INT styp;                     /* search type selected                 */
     LONG flags;                   /* various online bit flags             */
     CHAR miscfil[FLFILENM];       /* miscellaneous file name              */
     CHAR misclib[FLNAMESZ];       /* miscellaneous Library name           */
     CHAR keylist[FLKEYLST];       /* keyword list string                  */
     INT tagcnt;                   /* temporary tag counter                */
     LONG pos;                     /* file position for unzipping files    */
     LONG filen;                   /* file length for unzipping files      */
     INT savetags;                 /* number of tagspecs saved during d/l  */
     CHAR tagk;                    /* display key                          */
     INT cursor;                   /* online tagbar                        */
     INT miscflag;                 /* miscellaneous index or flag          */
     INT kcount;                   /* keyword count                        */
     INT nlibaxs;                  /* number of libs user has access to    */
     INT index;                    /* miscellaneous index integer          */
     INT force;                    /* lib select mode: top-level lib only? */
     INT retstt;                   /* return or flag substate              */
     INT pflg;                     /* asking state, download selection     */
     INT hold;                     /* tag while viewing                    */
     INT crdrat;                   /* saved for free upload/download       */
     INT nozap;                    /* saved for free upload/download       */
     struct ffblk fb;             /* for miscellaneous fnd1st(), etc. use */
     INT autol;                    /* auto login or approve all in prog.   */
     INT dodesc;                   /* descriptions during login, see below */
     INT atend;                    /* listing scroll flags, see below      */
     CHAR lrange[FLNAMESZ];        /* searching what lib range             */
     LONG tot;                     /* amt. of file copy done               */
     CHAR srcpath[GCMAXPTH];       /* miscellaneous file path number 1     */
     CHAR destpath[GCMAXPTH];      /* miscellaneous file path number 2     */
     FILE *fsrc;                   /* miscellaneous file pointer number 1  */
     FILE *fdst;                   /* miscellaneous file pointer number 2  */
     INT state;                    /* state for unzipping files            */
     CHAR fdate[DATESZ];           /* DOS file date (FSD use)              */
     CHAR udate[DATESZ];           /* upload date (FSD use)                */
     LONG siz;                     /* file size (FSD use)                  */
     INT ftim;                     /* file time (FSD use)                  */
     LONG numdls;                  /* file number of downloads (FSD use)   */
     CHAR ulby[UIDSIZ];            /* file uploader (FSD use)              */
     INT timeul;                   /* upload time (FSD use)                */
     INT prop;                     /* propellor spinner state (/-\|)       */
     INT wtnum;                    /* wildcard tagging: number of files    */
     LONG wtsiz;                   /* wildcard tagging: cumulative size    */
     CHAR savprot[3];              /* protocol saved for concatenation     */
     CHAR newdate[DATESZ];         /* date for L list option, newest files */
     INT tdline[NLISTER];          /* line number and tag status (+/-)     */
     struct key0 tags[NLISTER];    /* displayed tagged files, libs, dates  */
     struct key1 key1;             /* miscellaneous key, mostly Lib-Op use */
     struct key2 kwdy;             /* miscellaneous keyword data file key  */
     union combo u;                /* composite key collection             */
     INT movstt;                   /* stat of move or copy of files        */
     CHAR cskwds[FLKEYLST];        /* keyword list for c/s searches        */
     struct zvdat cszview;         /* c/s view-zipfile memory              */
     LONG csidx;                   /* c/s search index, dos & keyword      */
};

                                   /* flags for struct fluson              */
#define OFTGMAN 0x00000001L        /* ...entered tag manager from filefind */
#define ABOUPRF 0x00000002L        /* ...neutralize user/system prefs CNC  */
#define RETUOPM 0x00000004L        /* ...return to operator menu from u/l  */
#define LISTALL 0x00000008L        /* ...listing all libs to offline list  */
#define DATESRC 0x00000010L        /* ...listing by user range of dates    */
#define COMFILE 0x00000020L        /* ...file is viewable inside (ascii)   */
#define LONGDSC 0x00000040L        /* ...display long Library description  */
#define DBLCLCK 0x00000080L        /* ...detect double-clicking of files   */
#define REVSRCH 0x00000100L        /* ...searching files in reverse order  */
#define USRANSI 0x00000200L        /* ...searching files in ansi mode      */
#define STOPLST 0x00000400L        /* ...stop listing files for a moment   */
#define TLSTDSP 0x00000800L        /* ...element has been displayed on list*/
#define FULLTAG 0x00001000L        /* ...prevent more interactive tagging  */
#define AXSUSER 0x00002000L        /* ...user has created u/l subdirectory */
#define XDLBEEP 0x00004000L        /* ...user warned about download access */
#define MOVFLAG 0x00008000L        /* ...copy (as opposed to move) flag    */
#define NXTEQUL 0x00010000L        /* ...get next value equal to key       */
#define REUPLOD 0x00020000L        /* ...user is re-uploading a file       */
#define UNOINJO 0x00040000L        /* ...user is busy, before searching    */
#define ENTRCNC 0x00080000L        /* ...user is using cnc facility ("&")  */
#define WLDRSLV 0x00100000L        /* ...resolving wildcard sysop operation*/
#define ISEDLIB 0x00200000L        /* ...user is editing a library now     */
#define APPTHEM 0x00400000L        /* ...approve files as they are added   */
#define DELTHEM 0x00800000L        /* ...delete files as they are unlogged */
#define OFFUPLD 0x01000000L        /* ...log off after upload to Library   */
#define INMVCPY 0x02000000L        /* ...sysop is in process of move/copy  */
#define FILCONT 0x04000000L        /* ...a c/s context has been secured    */

                                   /* values for dodesc in struct fluson   */
#define ASKDESC -1                 /* ...ask whether to enter a file desc. */
#define NEVRASK  0                 /* ...just log in all the files         */
#define DOADESC  1                 /* ...do the next file description      */
#define NIXDESC  2                 /* ...don't do the next file description*/

                                   /* values for atend in struct fluson    */
#define LSTFILS  0                 /* ...scrolling in either direction ok  */
#define LSTBACK  1                 /* ...at end, no scrolling forward      */
#define LSTFORE  2                 /* ...at beginning, no scrolling back   */
#define LSTONLY  3                 /* ...may not scroll in either direction*/
#define LSTNONE  4                 /* ...no files found in search/list     */

                                   /* values for submit() and viewing files*/
#define NOTVIEW  0                 /* ...tag file for download             */
#define DOWNLOD  1                 /* ...download file now                 */
#define CMPVIEW  2                 /* ...view with "V" protocol            */
#define LSTVIEW  3                 /* ...view with "L" protocol            */
#define ANSVIEW  4                 /* ...view with "A" protocol            */
#define CSTVIEW  5                 /* ...custom view routine, flo->rouptr  */

struct srcs {                      /* information for ongoing searches     */
     INT nlibs;                    /*   number of Libraries in keys, or 0  */
     INT nloaded;                  /*   number of Libraries loaded so far  */
     union srch *tn;               /*   "to next" unions of keys           */
     union srch *tp;               /*   "to previous" unions of keys       */
     union srch *fn;               /*   "from next" unions of keys         */
     union srch *fp;               /*   "from previous" unions of keys     */
     CHAR unions[1];               /*   var-length data for above unions   */
};

#define NUINRS 4                   /* # of union arrays in above data area */

struct libcsfil {                  /* files being d/l'ed by c/s users      */
     CHAR libname[FLNAMESZ];       /*   Library name of file               */
     CHAR filname[FLFILENM];       /*   file name of file, * for all       */
     INT status;                   /*   file copy status, see below        */
     LONG time;                    /*   time value for CD copying          */
     LONG charge;                  /*   credits user was charged for d/l   */
};

extern struct libcsfil * FILEXP lcsu;   /* pointer, and per-user arrays    */
extern struct libcsfil * FILEXP lcsarr;
extern struct libcsfil * FILEXP viewarr;

#define FREADY 1                   /* lcsarr status, file ready to d/l     */
#define CDFILE 2                   /* lcsarr status, CD file waiting       */
#define CDCOPY 3                   /* lcsarr status, CD file copying       */
#define CDDONE 4                   /* lcsarr status, copied file ready     */
#define CDDLOD 5                   /* lcsarr status, d/l of copied file    */
#define EXTCDF 6                   /* lcsarr status, special file copy     */
#define EXTCDC 7                   /* lcsarr status, external control      */

/* External CD management programs can work with C/S users also, they need */
/* to watch lcsarr[] (using setlcsu()) for files showing up as EXTCDF.     */
/* Then they must set lcsu->status to EXTCDC until the file has been       */
/* retrieved.  Afterwards, set to CDDONE telling the system that the file  */
/* is in the proper copydir ready for d/l.                                 */

extern struct fluser * FILEXP flu; /* current user pointed to (disk)       */
extern struct fluser * FILEXP fluarr;   /* memory array                    */

extern struct fluson * FILEXP flo;      /* online user pointed to          */

extern struct flusave FILEXP flusmem;   /* memory for loading/saving fluser*/

extern struct fllib * FILEXP curlib;    /* current Library in use          */
extern struct fllib ** FILEXP alphlibs; /* alphabetical ptrs to Libraries  */

extern struct libdisk * FILEXP libupd;  /* memory for loading/saving Libs  */
extern struct libdisk * FILEXP libedt;  /* memory for editing Libraries    */

extern struct taglib * FILEXP ftag;     /* current tagged file             */

extern struct modeview FILEXP mvarr[NVIEWS];/* custom viewing routines     */

extern struct key0 FILEXP countkey;     /* key for counting uploads in Libs*/

extern struct key7 * FILEXP kwbuf;      /* buffer for keyword insertion    */

extern INT FILEXP srcpool;         /* handle to pool of search structs     */
extern INT * FILEXP srcharr;       /* array of search handles, one per user*/
extern struct srcs * FILEXP srcu;  /* ptr to cur (srcoff()'d) search struct*/

extern union srch FILEXP srcactive;/* active, found record for speed-search*/

extern INT FILEXP curfusr;         /* cur (fluoff()'d) file library user   */

extern HMCVFILE FILEXP flmsg;      /* handle for .msg file                 */
extern FILE * FILEXP csrc;         /* pointer for general copying of files */
extern FILE * FILEXP cdst;         /* pointer for general copying of files */
extern FILE * FILEXP movs;         /* pointer for sysop copying of files   */
extern FILE * FILEXP movd;         /* pointer for sysop copying of files   */

extern DFAFILE * FILEXP flldat;    /* data file for Libraries              */
extern DFAFILE * FILEXP flfdat;    /* data file for files                  */
extern DFAFILE * FILEXP flkdat;    /* data file for keywords               */

extern CHAR * FILEXP arrower;      /* cursor key detection flag            */
extern CHAR * FILEXP tempdir;      /* default user upload temp directory   */
extern CHAR * FILEXP nochgkey;     /* key to never be charged to d/l       */
extern CHAR * FILEXP listkey;      /* key to be able to d/l file lists     */
extern CHAR * FILEXP nonkwds;      /* non-keywords                         */
extern CHAR * FILEXP flsysop;      /* key required to be Library sysop     */
extern CHAR * FILEXP defplop;      /* default primary Lib-Op               */
extern CHAR * FILEXP copydir;      /* destination directory, copied files  */
extern CHAR * FILEXP defdesc;      /* default description for a Library    */
extern CHAR * FILEXP deflname;     /* name of default Library              */
extern CHAR * FILEXP descedit;     /* memory for file descriptions         */
extern CHAR * FILEXP dargv[MAXKWDS];/* points to defdesc, as margv to input*/
extern CHAR * FILEXP defproto;     /* default d/l protocol for all users   */
extern CHAR FILEXP flmisc[MISCSIZE];/* array for misc. test variable       */
extern CHAR FILEXP movflib[FLNAMESZ];/* array for moving files from Library*/
extern CHAR FILEXP movtlib[FLNAMESZ];/* array for moving files to Library  */
extern CHAR FILEXP movfnam[FLFILENM];/* array for moving files file name   */
extern CHAR FILEXP countlib[FLNAMESZ];/* Library currently being counted   */
extern CHAR FILEXP tagtmpp[TSHLEN+1];/* memory for temporary wild file path*/
extern CHAR FILEXP tagtmpf[FLFILENM];/* memory for temporary wild file name*/

extern VOID * FILEXP libmem;       /* memory for Libraries                 */
extern VOID * FILEXP libmem2;      /* more memory for adding Libraries     */
extern VOID * FILEXP flomem;       /* memory for users online              */
extern VOID * FILEXP ftagmem;      /* memory for tagged files              */

extern INT FILEXP numlib;          /* number of libs memory allocated for  */
extern INT FILEXP numladd;         /* max. number of libs to possibly add  */
extern INT FILEXP movstt;          /* state of file move                   */
extern INT FILEXP flstt;           /* state for the File Libraries         */
extern INT FILEXP longsrch;        /* require brute force searches         */
extern INT FILEXP vdd;             /* half of the vda declaration          */
extern INT FILEXP freeuls;         /* if true, never charge while uploading*/
extern INT FILEXP dargc;           /* count of parsed words by darsdesc()  */
extern INT FILEXP notifsys;        /* if true, notify sysops of unapp files*/
extern INT FILEXP notiflop;        /* if true, notify libops of unapp files*/
extern INT FILEXP numoflib;        /* actual number of Libraries           */
extern INT FILEXP comeff;          /* estimated communications efficiency  */
extern INT FILEXP ncatlibs;        /* actual number of top-level Libraries */
extern INT FILEXP auditall;        /* if true, audit all file transfers    */
extern INT FILEXP unifile;         /* if true, require unique file names   */
extern INT FILEXP clfits;          /* if true, use cluster sizes for libs  */
extern INT FILEXP pfnceil;         /* profanity ceiling for File Libraries */
extern INT FILEXP chgabt;          /* if true, charge for aborted downloads*/
extern INT FILEXP defallib;        /* search all Libraries from d/l prompt */
extern INT FILEXP systags;         /* number of ftagmem to allocate        */
extern INT FILEXP defstyp;         /* default search/list mode             */
extern INT FILEXP defslib;         /* default search/list range, one/all   */
extern INT FILEXP movflag;         /* flag for move/copy files, to copy?   */
extern INT FILEXP stplist;         /* strip ansi always in file listings   */
extern INT FILEXP countuls[ULDAYS];/* counter of Library files added daily */
extern INT FILEXP clnlevel;        /* level of cleanup to run              */
extern INT FILEXP kwaut;           /* flag, keywords being written now     */
extern INT FILEXP maxjoin;         /* # of joined libs max for fast search */
extern INT FILEXP srcindex;        /* index for found record in speed-srch */
extern INT FILEXP fltagf;          /* is current file tag a Library tag    */
extern INT FILEXP htmldesc;        /* use live HTML in descriptions?       */

extern LONG FILEXP byteroom;       /* bytes free for uploading to a Library*/
extern LONG FILEXP thresh;         /* bytes assured free, copydir's drive  */

extern struct reserve * FILEXP librsv;/* File Libraries reservations domain*/

extern CHAR * FILEXP libedits;     /* FSD utility strings                  */
extern CHAR * FILEXP filedits;
extern CHAR * FILEXP libeditf;
extern CHAR * FILEXP fileditf;

extern GBOOL FILEXP newjoins;      /* are there new libraries joined?      */

VOID init_galfiluz(VOID);          /* initialize unzip submodule           */
INT openzip(VOID);                 /* open zip file (unzip submodule)      */
INT dizread(CHAR *b);              /* read description file (unzip submod) */

#define flf ((struct flfile *)(flfdat->data))          /* macro: cur file  */
#define spc (*((struct taglib **)(ftgptr->tagspc)))    /* macro: cur tag   */
#define kyd ((struct key2 *)(flkdat->data))            /* macro: cur kwd   */
#define totags (ftuptr->numftg+flo->tagcnt)            /* macro: # tagged  */
#define nextrec(rev,e,x,y,z)  (rev ? (e ? dfaAcqLE(x,y,z) : dfaAcqLT(x,y,z)) : \
                                     (e ? dfaAcqGE(x,y,z) : dfaAcqGT(x,y,z)))
#define nextqrec(rev,x,y,z) (rev ? dfaAcqLE(x,y,z) : dfaAcqGE(x,y,z))
#define DESCSNON "<please type a description here>"
#define DESCLNON "<please type more descriptive text here>"
#define DESCFNON "<Enter description, including keywords>"
#define DESCFNO2 "<The first line acts as a short description>"

                                   /* utilties for interface to the FSD    */
#define FLDDATE  0
#define FLDTIME  1
#define FLDNAME  2
#define FLDDOSO  3
#define FLDDESC  4
#define FLDDESC0 5
#define FLDDESC1 6
#define FLDDESC2 7
#define FLDDESC3 8
#define FLDDESC4 9
#define FLDPATH 10
#define FLDHID  11
#define FLDCBD  12
#define FLDRDO  13
#define FLDAUL  14
#define FLDADL  15
#define FLDFUL  16
#define FLDFDL  17
#define FLDCDF  18
#define FLDCDK  19
#define FLDROY  20
#define FLDMFL  21
#define FLDMBT  22
#define FLDMUP  23
#define FLDVIS  24
#define FLDDLD  25
#define FLDULD  26
#define FLDOVW  27
#define FLDAPU  28
#define FLDLOP  29
#define FLDPLOP 30
#define FLDEXIT 31

#define FFDNAME  0
#define FFDLIB   1
#define FFDDATE  2
#define FFDTIME  3
#define FFDSIZE  4
#define FFDDL    5
#define FFDULD   6
#define FFDULT   7
#define FFDDLT   8
#define FFDCHG   9
#define FFDUSER  10
#define FFDTXT00 11
#define FFDTXT01 12
#define FFDTXT02 13
#define FFDTXT03 14
#define FFDTXT04 15
#define FFDTXT05 16
#define FFDTXT06 17
#define FFDTXT07 18
#define FFDTXT08 19
#define FFDTXT09 20
#define FFDTXT10 21
#define FFDTXT11 22
#define FFDTXT12 23
#define FFDTXT13 24
#define FFDTXT14 25
#define FFDEXIT  26

/* GALFIL.C 26/01/94 16.36.56 */
VOID EXPORT init__galfil(VOID);
VOID initlibrsv(VOID);
VOID iniopts(VOID);
GBOOL psislibop(INT unum,const CHAR *lock);
CHAR *cnclib(VOID);
INT isflop(struct fllib *libptr);
INT scanlib(INT user,struct fllib *libptr);
INT wldgetag(VOID);
INT dlbgnwld(VOID);
INT tshlist(INT tshcod);
INT tshlib(INT tshcod);
LONG dnlprc(LONG siz,struct fllib *libptr);
VOID fluoff(INT unum);
VOID srcoff(VOID);
VOID scanlibs(VOID);
struct fllib *libfind(const CHAR *libname);
struct fllib *liboff(INT libnum);
struct fllib *setuaxs(VOID);
INT makwdlst(const CHAR *stg,const CHAR *filname);
INT submit(CHAR *libname,CHAR *filname,CHAR *reflib,INT view,INT quiet);
INT updusr(struct fluser *fluptr);
CHAR *userdir(INT which);
INT valname(CHAR *libname);
INT fileditv(INT fldno,CHAR *answer);
GBOOL lsinp(VOID);
VOID deresume(VOID);
GBOOL lslon(VOID);
VOID genlon(VOID);
INT srcincx(VOID);
INT srcgood(VOID);
INT srcnext(VOID);
union srch *nextsrc(INT nxteq);
VOID resetkey(CHAR *libname,CHAR *filname);
VOID rset(VOID);
INT tryMove(VOID);
INT insfile(struct fllib *libptr,CHAR *path,const struct ffblk *f,
            const CHAR *appdate,const CHAR *u,const CHAR *desc);
INT keywordy(VOID);
INT libeditv(INT fldno,CHAR *answer);
INT valpath(CHAR *path);
INT taglist(VOID);
INT zapcrd(INT yes,LONG siz,struct fllib *dlib);
struct fllib *keylib(CHAR *libfound,CHAR *libname,INT *retval);
struct fllib *nxtlib(VOID);
VOID optiprf(VOID);
VOID bgnfiled(INT display);
INT uwaitcpy(INT unum);
VOID notifu(VOID);
INT ntagged(CHAR *uid);
VOID checkoth(VOID);
VOID ulcount(VOID);
VOID inicount(CHAR *libname);
INT addkwnow(VOID);
VOID addkw(const CHAR *keyword,const CHAR *filname,const CHAR *libname);
VOID keywdaut(INT taskid);
INT delkw(const CHAR *keyword,const CHAR *filname,const CHAR *libname);
VOID copyaut(INT taskid);
VOID doalr(VOID);
VOID dsearch(INT which,INT x);
VOID fileditd(SHORT save);
VOID fileditp(INT msgno,INT amode,INT display);
VOID lsclean(VOID);
VOID lsdel(CHAR *uid);
VOID lsend(VOID);
VOID purgecpy(INT rmvdirs);
VOID lshang(VOID);
VOID genhup(VOID);
LONG flclfit(LONG filsiz,USHORT cluster);
VOID cfilmova(VOID);
VOID movecyc(VOID);
GBOOL cycdelib(INT *stt,CHAR *libname,CHAR *filname);
VOID cdellib(VOID);
VOID crencyc(VOID);
INT dupefile(VOID);
VOID autogone(VOID);
VOID doneLog(GBOOL prfNow);
VOID cautolog(VOID);
VOID cunapp(VOID);
VOID capp(VOID);
VOID cbigcpy(VOID);
VOID csearch(VOID);
VOID cfildel(VOID);
VOID cflist(VOID);
VOID entrdesc(VOID);
VOID ccopying(VOID);
VOID cdizzy(VOID);
VOID cliblst(VOID);
VOID ckeyword(VOID);
VOID cwldsrch(VOID);
VOID cwldsys(VOID);
VOID cresolve(VOID);
VOID clstcyc(VOID);
VOID lssta(VOID);
VOID flagit(INT fldspec,LONG flag);
CHAR *dprfm(INT msgno);
VOID srcdrec(INT redisplay);
VOID unprop(VOID);
VOID srcinit(INT mode,CHAR *lib);
CHAR *wldstuff(CHAR *stg);
VOID srcpaus(INT rebuild);
VOID srcukey(VOID);
VOID gosearch(VOID);
VOID libeditd(SHORT save);
GBOOL savelib(struct libdisk *sav);
VOID libeditp(INT msgno,INT amode);
VOID libkick(VOID);
VOID prfopt(INT optno,INT tot,INT ctr);
VOID prfups(VOID);
VOID mainmenu(VOID);
VOID opmenu(VOID);
VOID promptin(VOID);
VOID retmenu(INT opermenu);
VOID buildview(INT item);
VOID retoin(VOID);
VOID retoinx(VOID);
VOID retoinl(VOID);
VOID rstcrd(VOID);
VOID setbusy(VOID);
VOID statstrt(VOID);
INT getaufil(INT wipe,INT unapp);
INT candlnow(CHAR *libname,CHAR *filname);
INT chjoined(struct fllib *libptr,CHAR *check);
INT chjoin(struct fllib *libptr,struct fllib *newlib,INT unjoin);
VOID listjoin(VOID);
INT profane(const CHAR *stg);
INT wldmatch(CHAR *wild,CHAR *sfnm);
INT compwild(CHAR *wildfile,CHAR *filename);
INT space(VOID);
VOID dncfin(INT endok,LONG bytxfer,struct fllib *libptr);
INT weirddir(CHAR *dirpath);
INT isansiu(VOID);
VOID touch(CHAR *src,CHAR *dest);
VOID untagall(CHAR *libname,CHAR *filname);
INT exfile(struct fllib *libptr,struct key0 *key);
VOID cleanit(INT total);
CHAR *manytims(LONG howmany);
struct taglib *tagoff(INT index);
CHAR *isedtlib(VOID);
VOID countupl(VOID);
VOID chuldate(struct fllib *libptr,const CHAR *date,INT add);
INT dlfrom(CHAR *libname);
INT dlfroml(struct fllib *libptr);
VOID dlcant(VOID);
VOID setmisc(CHAR *stg);
INT viewmode(CHAR *ext);
INT register_modeview(CHAR *ext,INT mode,VOID (*rouptr)());
VOID cycinp(VOID);
INT totnlibs(CHAR *libname,INT index);
GBOOL initsrc(VOID);
GBOOL ccycidx(VOID);
VOID newpage(VOID);
/* GALFILUT.C 26/01/94 15.21.00 */
CHAR *checkdir(CHAR *path);
CHAR *fixpath(CHAR *path);
CHAR *compkey(const CHAR *libname,const CHAR *filname);
CHAR *rcompkey(const CHAR *libname,const CHAR *filname);
CHAR *cutpunc(CHAR *stg);
CHAR *dat2srt(const CHAR *dt);
CHAR *ddat2srt(USHORT dosDate);
LONG dnlchg(LONG siz,CHAR *libname);
CHAR *dnlmin(LONG siz);
CHAR *fzer(LONG num);
CHAR *protocol(VOID);
CHAR *srt2dat(const CHAR *dt);
CHAR *srt2datl(const CHAR *dt);
CHAR *tvcomeff(VOID);
CHAR *tvctim(VOID);
CHAR *tvdesc(VOID);
CHAR *tvdesc0(VOID);
CHAR *tvdesc1(VOID);
CHAR *tvdesc2(VOID);
CHAR *tvdesc3(VOID);
CHAR *tvdesc4(VOID);
CHAR *tvdnlmin(VOID);
CHAR *tvfapp(VOID);
CHAR *tvfdate(VOID);
CHAR *tvfdates(VOID);
CHAR *tvfname(VOID);
CHAR *tvflib(VOID);
CHAR *tvfnum(VOID);
CHAR *tvfsize(VOID);
CHAR *filsize(LONG size,LONG kval);
CHAR *tvfsizek(VOID);
CHAR *tvftimes(VOID);
CHAR *tvfulby(VOID);
CHAR *tvinit(VOID);
CHAR *tvmisc(VOID);
CHAR *tvname(VOID);
CHAR *tvtagk(VOID);
CHAR *tagk(VOID);
CHAR *tvtags(VOID);
CHAR *tvtshmsg(VOID);
CHAR *tvudate(VOID);
CHAR *tvbytu(VOID);
CHAR *tvbytt(VOID);
CHAR *tvbyto(VOID);
CHAR *tvfilt(VOID);
INT alrtag(CHAR *libname,CHAR *filname);
INT amrlib(CHAR *grp,CHAR *fil);
INT countc(CHAR *stg,CHAR chr);
INT deparse(CHAR *p);
INT dotags(INT quiet);
VOID setfull(INT isfull);
INT findbest(INT stt);
INT visilib(struct fllib *libptr);
CHAR *visxlib(struct fllib *libptr,CHAR *libmatch);
INT keyfig(VOID);
INT keyin(CHAR *key);
INT keysin(INT start);
INT kwdout(VOID);
INT nlibtagd(VOID);
INT okfname(const CHAR *filename);
INT readline(FILE *ptr);
INT srch1(VOID);
INT srch2(VOID);
GBOOL strsrep(CHAR *stg,CHAR *from,CHAR *to);
INT ulfileq(INT flag);
LONG dnlsec(LONG siz);
LONG dnlsecl(LONG siz,struct fllib *libptr);
struct fllib *nexthigh(const CHAR *oldlib);
struct fllib *nextlow(const CHAR *oldlib);
VOID bubkwds(VOID);
VOID sortlibs(VOID);
VOID darsdesc(INT limit,CHAR chr);
CHAR *lrange(CHAR *libname);
VOID dispfhdr(INT resetcur);
VOID dlcharge(LONG charge,struct fllib *l);
VOID dnlcount(CHAR *libname,CHAR *filname,LONG ct);
INT maintainFile(VOID);
VOID dofiler(CHAR *desc);
VOID gather(VOID);
VOID loadlibs(VOID);
VOID mopitup(VOID);
VOID moploop(VOID);
INT notify(INT logon);
VOID readin(INT lines,FILE *fptr,CHAR *stg);
VOID regtvars(VOID);
VOID removetg(INT n);
VOID strcrep(CHAR *stg,CHAR from,CHAR to);
VOID unbreak(VOID);
VOID iflstyp(CHAR c);
VOID iflslib(CHAR c);
VOID iaskword(CHAR *stg);
VOID iaskname(CHAR *stg);
INT ifdesced(CHAR *stg);
VOID iprefers(CHAR c);
VOID imanmnu(CHAR c);
VOID ibigcopy(CHAR *stg);
VOID iwarnmrk(CHAR *stg);
VOID idelfil(CHAR *stg);
INT isellib(CHAR *stg);
INT othrsin(CHAR *libname);
INT idellibn(CHAR *stg);
INT itagman(CHAR *stg);
INT ientdl(CHAR *stg);
INT fspex(CHAR *stg,CHAR *lib,INT sub);
INT ioverw(CHAR c);
INT ientul(CHAR *stg);
INT iulmod(CHAR *stg);
INT ucanmod(VOID);
INT ucanovw(struct fllib * pLib,struct flfile * pFile);
VOID exitview(VOID);
VOID dcurs(INT und);
INT curspos(INT set);
VOID clstags(VOID);
INT ientret(CHAR *stg);
INT iviewasc(CHAR chr);
VOID ifilistx(CHAR *stg);
INT ifilist(CHAR *stg);
VOID itranspr(CHAR chr);
VOID irename(CHAR *stg);
VOID ichain(CHAR chr);
VOID ijoin(CHAR *stg);
VOID iflblist(CHAR chr);
INT inpfunc(VOID);
INT editgo(CHAR *filen);
INT writable(struct fllib *libptr);
INT lsmenu(VOID);
INT fupfil(INT code);
INT fparsrch(CHAR *stg);
VOID retoin2(VOID);
VOID dnlstart(INT logoff);
VOID rebuild(INT cls);
VOID prtbuild(INT start,INT run);
VOID iappmenu(CHAR chr);
VOID iunapp(CHAR chr);
VOID idelmenu(CHAR chr);
VOID imovmenu(CHAR chr);
VOID imovpath(CHAR *stg);
VOID ienuadnm(CHAR *stg);
VOID idoso(CHAR chr);
VOID iclibnam(CHAR *stg);
INT oprmenu(VOID);
CHAR *inmvcpy(VOID);
VOID loadldsc(struct libdisk *libdptr);
VOID bgnlibed(VOID);
VOID cdsptags(VOID);
VOID wipetag(VOID);
INT libchg(VOID);
VOID spinner(VOID);
VOID locsysfl(CHAR *filname);
VOID notidl(VOID);
INT notapped(const CHAR *udate);
LONG libroom(struct fllib *libptr);
CHAR *libpath(struct fllib *libptr);
INT haslibkey(struct fllib *libptr,CHAR *keyname);
INT usrupd(struct fllib *libptr,CHAR *filname);
VOID chkjoin(VOID);
/* GALFILCS.C 13/09/94 10.00.00 */
VOID init_cslib(VOID);
INT vewctn(VOID);
INT csfbest(INT mode,LONG time);
VOID csclean(INT unum);
VOID sendres(CHAR *restg);
VOID sendjoin(VOID);
VOID setlcsu(INT unum);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __GALFILH_H                          */
