/***************************************************************************
 *                                                                         *
 *   ALIAS.H                                                               *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Alias names for users (from User-ID by default, intercepted by        *
 *   GALGWI.DLL if installed).                                             *
 *                                                                         *
 *                                        - RNStein  8/2/94                *
 *                                                                         *
 *   Changed so aliasing is supported whether or not MG/I is installed,    *
 *   and sealed up alias "leaks" to prevent e-mail from being stolen.      *
 *                                                                         *
 *                                        - C. Dunn  10/18/95              *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   The oaofu and ouofa vectors were kept around for existing modules     *
 *   (such as MG/I), that are no longer being built, and need the old      *
 *   aliasing functionality.                                               *
 *                                                                         *
 ***************************************************************************/

#ifndef __ALIAS_H
#define __ALIAS_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#if defined(GCWINNT)
#ifdef __BUILDALIAS
#define ALSEXP __export
#else
#define ALSEXP __import
#endif                             /* __BUILDALIAS                         */
#else
#define ALSEXP
#endif                             /* GCWINNT                              */

#define ALSSIZ 17                  /* maximum size of user's alias         */
#define ALSAPID "GALALIAS"         /* C/S App-ID                           */
#define NOALCV "NO*ALIAS"          /* no alias "convid" value              */
#define NOALID "(No Alias Created)" /* no alias return value               */

extern CHAR * ALSEXP alskey;       /* key required for Sysop alias funcs   */

extern DFAFILE * ALSEXP alsbb;     /* Btrieve pointer to GALALIAS.DAT      */

extern HMCVFILE ALSEXP alsmb;      /* file handle to GALALIAS.MCV          */

extern GBOOL ALSEXP useals;        /* use aliasing on the system?          */

extern INT ALSEXP alslgn;          /* action to take at logon              */

extern GBOOL                       /*   returns TRUE if alias in use       */
(* ALSEXP alsinuse)(               /* is alias in use?                     */
const CHAR *userid,                /*   User-ID who will have alias        */
const CHAR *alias);                /*   alias to check                     */

extern CHAR *
(* ALSEXP alsofusr)(CHAR *userid); /* convert User-ID into alias (current) */

extern CHAR *
(* ALSEXP usrofals)(CHAR *alias);  /* convert alias into User-ID (current) */

extern CHAR *
(* ALSEXP oaofu)(CHAR *userid);    /* convert User-ID into alias (old)     */

extern CHAR *
(* ALSEXP ouofa)(CHAR *alias);     /* convert alias into User-ID (old)     */

VOID
init__galalias(VOID);              /* initialize alias handler             */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __ALIAS_H                            */
