@echo off
:::
::: This batch file makes the Worldgroup baseline (generic).
:::
cls
set WGENV=
set WGDIR=
set COMPWHAT=
SET ARGS=%3 %4 %5 %6 %7 %8 %9
if "%2" == "WNTD" SET ARGS=%ARGS% -DDEBUG
if "%2" == "wntd" SET ARGS=%ARGS% -DDEBUG
if "%2" == "DOSD" SET ARGS=%ARGS% -DDEBUG
if "%2" == "dosd" SET ARGS=%ARGS% -DDEBUG
if "%2" == "WNT" SET WGENV=WNT
if "%2" == "WNTD" SET WGENV=WNT
if "%2" == "wnt" SET WGENV=WNT
if "%2" == "wntd" SET WGENV=WNT
if "%2" == "DOS" SET WGENV=DOS
if "%2" == "DOSD" SET WGENV=DOS
if "%2" == "dos" SET WGENV=DOS
if "%2" == "dosd" SET WGENV=DOS
if "%WGENV%" == "" goto BADCOMP
if "%WGDEV%" == "" goto SETVARS
set COMPWHAT=%1
if "%COMPWHAT%" == "" goto BADCOMP
if "%COMPWHAT%" == "ALL" set COMPWHAT=!devutil !client !debug !lib
if "%COMPWHAT%" == "all" set COMPWHAT=!devutil !client !debug !lib
if "%COMPWHAT%" == "debug" set ARGS=%ARGS% -DDEBUG
if "%COMPWHAT%" == "DEBUG" set ARGS=%ARGS% -DDEBUG
if "%COMPWHAT%" == "client" goto CLIENT
if "%COMPWHAT%" == "CLIENT" goto CLIENT
if not "%SRVEXTRA%" == "" set COMPWHAT=%COMPWHAT% %SRVEXTRA%
if "%WGENV%" == "" goto BADCOMP
if "%WGENV%" == "DOS" if "%WGDOS%" == "" goto DOSVARS
if "%WGENV%" == "WNT" if "%WGNT%" == "" goto WNTVARS
set GCTSTENV=x
if not "%GCTSTENV%" == "x" goto ENVSPACE

cd %WGDEV%
if "%WGENV%" == "DOS" goto CMPDOS
rem #########################################################################
rem ##  Build Borland stuff                                                ##
rem #########################################################################
galmklst /c%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mknt %COMPWHAT%
galprlst cmp.lst "call gcbuild mknt " F " -DBUILD %ARGS%"
if errorlevel 1 goto DONE

rem #########################################################################
rem ##  Build DOS compiled stuff for NT version of server                  ##
rem #########################################################################
galmklst /c%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mkdoslnt %COMPWHAT%
galprlst cmp.lst "call gcbuild mkdosl " F " -DBUILD %ARGS%"
if errorlevel 1 goto DONE

rem #########################################################################
rem ##  Build Microsoft Visual C++ if exists                               ##
rem #########################################################################
if "%MVC42%" == "" goto SKIPMVC42
galmklst /c%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mkmvc %COMPWHAT%
galprlst cmp.lst "call gcbuild mkmvc " F " -DBUILD %ARGS%"
if errorlevel 1 goto DONE
:SKIPMVC42

rem #########################################################################
rem ##  Build Java stuff if exists                                         ##
rem #########################################################################
if "%JAVA10%" == "" goto SKIPJAVA10
galmklst /c%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mkjava java %COMPWHAT%
galprlst cmp.lst "call gcbuild mkjava " F " -DBUILD %ARGS%"
if errorlevel 1 goto DONE
:SKIPJAVA10

rem #########################################################################
rem ##  Build Java 113 stuff if exists                                     ##
rem #########################################################################
if "%JAVA113%" == "" goto SKJAV113
galmklst /c%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mkjav113 java %COMPWHAT%
galprlst cmp.lst "call gcbuild mkjav113 " F " -DBUILD %ARGS%"
if errorlevel 1 goto DONE
:SKJAV113
goto DONE

:CMPDOS
galmklst /c%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mkdosp %COMPWHAT%
galprlst cmp.lst "call gcbuild mkdosp " F " -DBUILD %ARGS%"
if errorlevel 1 goto DONE
galmklst /c%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mkdosl %COMPWHAT%
galprlst cmp.lst "call gcbuild mkdosl " F " -DBUILD %ARGS%"
goto DONE

:CLIENT
if not "%SRVEXTRA%" == "" set COMPWHAT=%COMPWHAT% %SRVEXTRA%
if "%WGMAN%" == "" goto SETWGM
cd %WGMAN%
galmklst /C%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mk31w %COMPWHAT%
galprlst cmp.lst "call gcbuild mk31w " F " -DBUILD %ARGS% -DB%WGENV%"
if errorlevel 1 goto DONE
galmklst /C%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mk31v %COMPWHAT%
galprlst cmp.lst "call gcbuild mk31v " F " -DBUILD %ARGS% -DB%WGENV%"
if errorlevel 1 goto DONE
galmklst /C%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mkvb %COMPWHAT%
galprlst cmp.lst "call gcbuild mkvb " F " -DBUILD %ARGS% -DB%WGENV%"
if errorlevel 1 goto DONE
galmklst /C%WGDEV%\BIN\makefile.lst /ocmp.lst %WGENV% mkvbc %COMPWHAT%
galprlst cmp.lst "call gcbuild mkvbc " F " -DBUILD %ARGS% -DB%WGENV%"
goto DONE

:BADCOMP
echo.
echo 
echo You must specify the proper build procedures
echo.
echo Usage: MAKEWGS (what) (type)
echo.
echo      (what)-   ALL       Builds everything required for server
echo                SERVER    Builds only server code
echo                SRVUTIL   Builds only server utilities
echo                OFFLINE   Builds all offline utilities
echo                DEVUTIL   Builds all developer utilities
echo                API       Builds all API relate libraries
echo                APP       Builds all Worldgroup Apps
echo                GALME     Builds all messaging engine files
echo                CLIENT    Builds all client files
echo                LIB       Builds all pre-compiled LIB files
echo                MVC       Builds Microsoft Visual C++ apps
echo                JAVA      Builds Java Apps
echo.
pause
echo      (type)    DOS       Build Worldgroup for DOS
echo                DOSD      Build Worldgroup for DOS, debug mode
echo                WNT       Build Worldgroup for NT
echo                WNTD      Build Worldgroup for NT, debug mode
echo.
echo       You may add further compile options.  Example:
echo.
echo           MAKEWGS ALL WNTD -DSRCDBG
echo.
echo       would build everything for debug and enable source-level
echo       debugging.
echo.
goto DONE

:SETVARS
echo.
echo 
echo You must set the following environment variables before building:
echo.
echo      WGDEV- Worldgroup source root directory (usually C:\WGDEV)
echo      BC5  - Borland compiler root directory (usually C:\BC5)
echo.
echo   In addition, you'll have to set either:
echo.
echo      WGNT  - Worldgroup for NT baseline directory (usually C:\WGSERV)
echo.
echo   or
echo.
echo      WGDOS  - Worldgroup for DOS baseline directory (usually C:\WGSERV)
echo      DOSEXT - Pharlap DOS extender root directory (usually C:\RUN286)
echo.
goto DONE

:WNTVARS
echo.
echo 
echo You must set the following environment variables before building:
echo.
echo      WGDEV - Worldgroup source root directory (usually C:\WGDEV)
echo      BC5   - Borland compiler root directory (usually C:\BC5)
echo      WGNT  - Worldgroup for NT baseline directory (usually C:\WGSERV)
echo.
goto DONE

:DOSVARS
echo.
echo 
echo You must set the following environment variables before building:
echo.
echo      WGDEV - Worldgroup source root directory (usually C:\WGDEV)
echo      BC5   - Borland compiler root directory (usually C:\BC5)
echo      WGDOS - Worldgroup for DOS baseline directory (usually C:\WGSERV)
echo      DOSEXT- Pharlap DOS extender root directory (usually C:\RUN286)
echo      BUDOS - BUTIL for DOS data files (usually C:\BTRIEVE5\BUTIL.EXE)
echo.
goto DONE

:ERROR
echo 
goto DONE

:ENVSPACE
echo.
echo 
echo You are out of environment space!  Check your system manuals to find
echo out how to add more environment space to your command-line environment!
echo.
echo Under DOS, you edit the CONFIG.SYS file and put a larger /E parameter
echo in the SHELL= line:
echo.
echo      SHELL=C:\COMMAND.COM C:\ /E:2048 /P
echo .
goto DONE

:SETWGM
echo.
echo 
echo You must set the following environment variables before building:
echo.
echo      WGMAN - Worldgroup manager source directory (usually C:\WGMAN)
echo      VB3   - Your Visual Basic root directory
echo.
goto DONE

:DONE
set GCTSTENV=
set ARGS=
set WGENV=
set WGDIR=
set COMPWHAT=
