#----------------------------------------------------------
# LOGIN.CMD   Replacement Trumpet Winsock Login script file,
#             written by Galacticomm, Inc., for PPP Proxy
#             logins to Worldgroup servers. Permission is
#             granted for owners of Worldgroup software to
#             modify this file.  Do NOT include this file
#             in a ZIP file with Trumpet Winsock, however.
#             Trumpet Winsock must be retrieved by each
#             end-user from Trumpet's own FTP site, intact
#             and unedited.  Once unzipped on the end-user's
#             hard disk, the ZIP file's original LOGIN.CMD
#             file may be overwritten by this LOGIN.CMD file.


# ATTENTION SYSOP: This file assumes your Worldgroup server's
# logon sequence is as originally installed using the original
# text block CNF options.  If you've changed them, carefully
# examine this script file to be sure it will properly identify
# your server's prompts for language, User-ID, and password.


$mode = "PPP"
# alternatives are "SLIP" and "CSLIP", change TRUMPWSK.INI accordingly

$addresstype = "-P"
# alternative is "-D" for dynamic as opposed to proxy addressing

$inisection = "default vars"
%attempts = 10
%busytimeout = 10
%busywait = 5
%connecttimeout = 45

if ![load $number $inisection]
  if [query $number "Enter your Worldgroup server's phone number"]
    save $number $inisection
  end
end

if ![load $username $inisection]
  if [username "Enter your Worldgroup User-ID"]
    save $username $inisection
  end
end

if ![load $password $inisection]
  if [password "Enter your Worldgroup password"]
    save $password $inisection
  end
end

if ![load $modemsetup $inisection]
  $modemsetup = "z"
  save $modemsetup $inisection
end

#----------------------------------------------------------
#
# reset modem
#
status "Resetting modem..."
set dtr off
sleep 1
set dtr on
sleep 1
#
# initialize modem
#
status "Initializing modem..."
output "atz"\r
if ! [input 5 OK\n]
  message "Modem is not responding to ATZ"
  abort
end
sleep 1
output "at"$modemsetup\r
if ! [input 10 OK\n]
  message "Modem is not responding to init string"
  abort
end
#
# dial
#
%n = 0
repeat
  %n = %n + 1
  if %n > %attempts
    message "Too many dial attempts"
    abort
  end
  status Dialling $number...(attempt %n)
  output "atdt"$number\r
  %busy = [input %busytimeout BUSY]
  if %busy
    status "The line is busy...pausing for a while"
    sleep %busywait
    %ok = 0
  else
    %ok = [input %connecttimeout CONNECT]
  end
until %ok


input 10 "Choose a number"
status Connected.  Now logging in as $username...
output "1"\r
sleep 2
output \r
if ![input 10 "User-ID"]
  message "Cannot recognize User-ID prompt"
  abort
end
output $username"/"$mode" "$addresstype\r
if ![input 10 "PASSWORD"]
  message "Cannot recognize password prompt"
  abort
end
output $password\r
if ![input 10 "Entering Proxy "$mode" mode."]
  message "Cannot recognize Proxy "$mode" mode"
  abort
end
display \n
online
exit
