/***************************************************************************
 *
 * random.cpp - Source for the Standard Library random generator
 *
 * $Id: random.cpp,v 1.17 1995/10/12 16:58:45 lijewski Exp $
 *
 ***************************************************************************
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Hewlett-Packard Company makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 *
 ***************************************************************************
 *
 * (c) Copyright 1994, 1995 Rogue Wave Software, Inc.
 * ALL RIGHTS RESERVED
 *
 * The software and information contained herein are proprietary to, and
 * comprise valuable trade secrets of, Rogue Wave Software, Inc., which
 * intends to preserve as trade secrets such software and information.
 * This software is furnished pursuant to a written license agreement and
 * may be used, copied, transmitted, and stored only in accordance with
 * the terms of such license and with the inclusion of the above copyright
 * notice.  This software and information or any other copies thereof may
 * not be provided or otherwise made available to any other person.
 *
 * Notwithstanding any other lease or license that may pertain to, or
 * accompany the delivery of, this computer software and information, the
 * rights of the Government regarding its use, reproduction and disclosure
 * are as set forth in Section 52.227-19 of the FARS Computer
 * Software-Restricted Rights clause.
 *
 * Use, duplication, or disclosure by the Government is subject to
 * restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in
 * Technical Data and Computer Software clause at DFARS 252.227-7013.
 * Contractor/Manufacturer is Rogue Wave Software, Inc.,
 * P.O. Box 2328, Corvallis, Oregon 97339.
 *
 * This computer software and information is distributed with "restricted
 * rights."  Use, duplication or disclosure is subject to restrictions as
 * set forth in NASA FAR SUP 18-52.227-79 (April 1985) "Commercial
 * Computer Software-Restricted Rights (April 1985)."  If the Clause at
 * 18-52.227-74 "Rights in Data General" is specified in the contract,
 * then the "Alternate III" clause applies.
 *
 **************************************************************************/

#include <stdcomp.h>
#include <stddefs.h>
#include <random.h>
#if defined (__WIN16__) && defined (_RWSTDDLL)
#include <instmngr.h>
#endif

#ifndef RWSTD_NO_NEW_HEADER
#include <cstddef>
#else
#include <stddef.h>
#endif

#ifdef RWSTD_MULTI_THREAD
#include <stdmutex.h>
#endif

#ifndef RWSTD_NO_NAMESPACE
namespace std {
#endif

void __random_generator::seed (unsigned long j)
    {
      unsigned long k = 1;
      table[54]       = j;

      for (size_t i = 0; i < LENGTH - 1; i++)
      {
        size_t ii = 21 * i % LENGTH;
        table[ii] = k;
        k = j - k;
        j = table[ii];
      }
      for (int loop = 0; loop < 4; loop++)
      {
        for (size_t i = 0; i < LENGTH; i++)
            table[i] = table[i] - table[(1 + i + 30) % LENGTH];
      }

      index1 = 0;
      index2 = 31;
    }


/*
 * Seed for STL random number generator
 */
unsigned long __SEED = 161803398;


unsigned long RWSTDExport __long_random (unsigned long limit)
{
#if !defined (__WIN16__) || !defined (_RWSTDDLL)
    static __random_generator rd(__SEED);
    return rd(limit);
#else
    return getDLLRandom(limit);
#endif
}

#ifndef RWSTD_NO_NAMESPACE
}
#endif
