/*-----------------------------------------------------------------------*
 * filename - mkdir.c
 *
 * function(s)
 *        mkdir - creates a directory
 *-----------------------------------------------------------------------*/

/*
 *      C/C++ Run Time Library - Version 2.0
 *
 *      Copyright (c) 1991, 1996 by Borland International
 *      All Rights Reserved.
 *
 */

#define INCL_ERROR_H
#include <ntbc.h>

#include <dir.h>
#include <_io.h>
#include <errno.h>

/*-----------------------------------------------------------------------*

Name            mkdir - creates a directory

Usage           int mkdir(const char *pathname);

Related
functions usage int rmdir(const char *pathname);

Prototype in    dir.h

Description     mkdir takes the given pathname and creates a new
                directory with that name.

                rmdir deletes the directory given by pathname. The
                directory named by pathname

                        must be empty

                        must not be the current working directory

                        must not be the root directory

Return value    mkdir returns the value 0 if the new directory was
                created.

                rmdir returns 0 if the directory is successfully deleted.

                With either function, a return value of -1 indicates an error,
                and errno is set to one of the following values:

                        EACCES  Permission denied
                        ENOENT  Path or file name not found

*------------------------------------------------------------------------*/

int _RTLENTRY _EXPFUNC mkdir(const char *pathP)
{
    if (CreateDirectory((char *)pathP,NULL) != TRUE)
        {
        if (GetLastError() == ERROR_ALREADY_EXISTS)
            return (__IOerror(EACCES));
        else
            return (__NTerror());
        }
    else
        return(0);
}
