#ifndef __STD_NUMERIC
#define __STD_NUMERIC

/***************************************************************************
 *
 * numeric - Declarations for the Standard Library algorithms
 *
 * $Id: numeric,v 1.6 1995/08/23 23:54:42 lijewski Exp $
 *
 ***************************************************************************
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Hewlett-Packard Company makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 *
 ***************************************************************************
 *
 * (c) Copyright 1994, 1995 Rogue Wave Software, Inc.
 * ALL RIGHTS RESERVED
 *
 * The software and information contained herein are proprietary to, and
 * comprise valuable trade secrets of, Rogue Wave Software, Inc., which
 * intends to preserve as trade secrets such software and information.
 * This software is furnished pursuant to a written license agreement and
 * may be used, copied, transmitted, and stored only in accordance with
 * the terms of such license and with the inclusion of the above copyright
 * notice.  This software and information or any other copies thereof may
 * not be provided or otherwise made available to any other person.
 *
 * Notwithstanding any other lease or license that may pertain to, or
 * accompany the delivery of, this computer software and information, the
 * rights of the Government regarding its use, reproduction and disclosure
 * are as set forth in Section 52.227-19 of the FARS Computer
 * Software-Restricted Rights clause.
 *
 * Use, duplication, or disclosure by the Government is subject to
 * restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in
 * Technical Data and Computer Software clause at DFARS 252.227-7013.
 * Contractor/Manufacturer is Rogue Wave Software, Inc.,
 * P.O. Box 2328, Corvallis, Oregon 97339.
 *
 * This computer software and information is distributed with "restricted
 * rights."  Use, duplication or disclosure is subject to restrictions as
 * set forth in NASA FAR SUP 18-52.227-79 (April 1985) "Commercial
 * Computer Software-Restricted Rights (April 1985)."  If the Clause at
 * 18-52.227-74 "Rights in Data General" is specified in the contract,
 * then the "Alternate III" clause applies.
 *
 **************************************************************************/

#include <stdcomp.h>

#include <function>
#include <iterator>

#ifndef RWSTD_NO_NEW_HEADER
#include <cstdlib>
#else
#include <stdlib.h>
#endif

#ifndef RWSTD_NO_NAMESPACE
namespace std {
#endif

template <class InputIterator, class T>
T accumulate (InputIterator first, InputIterator last, T init)
{
    while (first != last) init = init + *first++;
    return init;
}

template <class InputIterator, class T, class BinaryOperation>
T accumulate (InputIterator first, InputIterator last, T init,
              BinaryOperation binary_op)
{
    while (first != last) init = binary_op(init, *first++);
    return init;
}

template <class InputIterator1, class InputIterator2, class T>
T inner_product (InputIterator1 first1, InputIterator1 last1,
                 InputIterator2 first2, T init)
{
    while (first1 != last1) init = init + (*first1++ * *first2++);
    return init;
}

template <class InputIterator1, class InputIterator2, class T,
          class BinaryOperation1, class BinaryOperation2>
T inner_product (InputIterator1 first1, InputIterator1 last1,
                 InputIterator2 first2, T init, BinaryOperation1 binary_op1,
                 BinaryOperation2 binary_op2)
{
    while (first1 != last1)
        init = binary_op1(init, binary_op2(*first1++, *first2++));
    return init;
}

template <class InputIterator, class OutputIterator, class T>
OutputIterator __partial_sum (InputIterator first, InputIterator last,
                              OutputIterator result, T*)
{
    T value = *first;
    while (++first != last)
    {
        value = value + *first;
        *++result = value;
    }
    return ++result;
}

template <class InputIterator, class OutputIterator>
inline OutputIterator partial_sum (InputIterator first, InputIterator last,
                                   OutputIterator result)
{
    return first == last ? result :
        (*result = *first,
        __partial_sum(first, last, result, RWSTD_VALUE_TYPE(first)));
}

template <class InputIterator, class OutputIterator, class T,
          class BinaryOperation>
OutputIterator __partial_sum (InputIterator first, InputIterator last,
                              OutputIterator result, T*,
                              BinaryOperation binary_op)
{
    T value = *first;
    while (++first != last)
    {
        value = binary_op(value, *first);
        *++result = value;
    }
    return ++result;
}

template <class InputIterator, class OutputIterator, class BinaryOperation>
inline OutputIterator partial_sum (InputIterator first, InputIterator last,
                                   OutputIterator result,
                                   BinaryOperation binary_op)
{
    return first == last ? result :
        (*result = *first,
        __partial_sum(first, last, result, RWSTD_VALUE_TYPE(first),binary_op));
}

template <class InputIterator, class OutputIterator, class T>
OutputIterator __adjacent_difference (InputIterator first, InputIterator last,
                                      OutputIterator result, T*)
{
    T value = *first;
    while (++first != last)
    {
        T tmp = *first;
        *++result = tmp - value;
        value = tmp;
    }
    return ++result;
}

template <class InputIterator, class OutputIterator>
inline OutputIterator adjacent_difference (InputIterator first,
                                           InputIterator last,
                                           OutputIterator result)
{
    return first == last ? result :
        (*result = *first,
        __adjacent_difference(first, last, result, RWSTD_VALUE_TYPE(first)));
}

template <class InputIterator, class OutputIterator, class T,
          class BinaryOperation>
OutputIterator __adjacent_difference (InputIterator first, InputIterator last,
                                      OutputIterator result, T*,
                                      BinaryOperation binary_op)
{
    T value = *first;
    while (++first != last)
    {
        T tmp = *first;
        *++result = binary_op(tmp, value);
        value = tmp;
    }
    return ++result;
}

template <class InputIterator, class OutputIterator, class BinaryOperation>
inline OutputIterator adjacent_difference (InputIterator first,
                                           InputIterator last,
                                           OutputIterator result,
                                           BinaryOperation binary_op)
{
    return first == last ? result :
        (*result = *first,
        __adjacent_difference(first, last, result, RWSTD_VALUE_TYPE(first),
                              binary_op));
}

#ifndef RWSTD_NO_NAMESPACE
}
#endif

#endif
