//----------------------------------------------------------------------------
// ObjectWindows
// Copyright (c) 1996, 1996 by Borland International, All Rights Reserved
//
// $Revision:   10.6  $
//----------------------------------------------------------------------------
#include <owl/pch.h>
#include <owl/listwind.h>
#include <owl/listbox.h>
#include <owl/imagelst.h>
#include <owl/menu.h>
#include <owl/editsear.rh>      
#include <owl/editfile.rh>      
#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include "listwind.rh"

const int ListWindId = 100;
const int MAX_ITEMS = 20;
const int MAX_CHARS = 25;

//----------------------------------------------------------------------------

//
// Class TInfoDialog
// ~~~~~ ~~~~~~~~~~~

class TInfoDialog : public TDialog {
  public:
    TInfoDialog(TWindow* parent, int resId, int count);
    static char strings[MAX_ITEMS][MAX_CHARS];
  protected:
    void SetupWindow(void);
  private:
    TListBox* ListBox;
    int Count;
};

char TInfoDialog::strings[MAX_ITEMS][MAX_CHARS];

TInfoDialog::TInfoDialog(TWindow* parent, int resId, int count)
:
  TDialog(parent, resId),
  Count(count)
{
  ListBox = new TListBox(this, IDC_LISTBOX);
}

void
TInfoDialog::SetupWindow()
{
  TDialog::SetupWindow();

  // Fill the list box with the list of selected indexes
  //
  for (int i = 0; i < Count; i++)
  {
    ListBox->AddString(strings[i]);
  }
}

//-----------------------------------------------------------

//
// Class TClientWindow
// ~~~~~ ~~~~~~~~~~~~~
class TClientWindow : public TWindow {
  public:
    TClientWindow(TWindow* parent= 0);
   ~TClientWindow();

  protected:
    void SetupWindow();

    void EvLButtonUp(uint modKeys, TPoint& point);
    void EvMouseMove(uint modKeys, TPoint& point);
    void LvnBeginDrag(TLwNotify& notify);

    // Event handlers
    //
    void CeLargeIcon(TCommandEnabler& ce) {
      ce.SetCheck(Type == LargeIcon ? TCommandEnabler::Checked : TCommandEnabler::Unchecked);
    }
    void CmLargeIcon();

    void CeSmallIcon(TCommandEnabler& ce) {
      ce.SetCheck(Type == SmallIcon ? TCommandEnabler::Checked : TCommandEnabler::Unchecked);
    }
    void CmSmallIcon();

    void CeList(TCommandEnabler& ce) {
      ce.SetCheck(Type == List ? TCommandEnabler::Checked : TCommandEnabler::Unchecked);
    }
    void CmList();

    void CeDetail(TCommandEnabler& ce) {
      ce.SetCheck(Type == Detail ? TCommandEnabler::Checked : TCommandEnabler::Unchecked);
    }
    void CmDetail();

    void CeAnySelected(TCommandEnabler& ce) {
      ce.Enable(ListWind->GetSelCount() > 0);
    }

    void CmShowSelected();
    void CmShowSelectionState();
    void CmShowSelStrings();
    void CmSelectAll();
    void CmUnselect();

    // Data members
    //
    TListWindow*  ListWind;
    TImageList*   ImageList;
    TImageList*   DragImage;
    bool          InDrag;
    char          Buffer[256];
    TRect         DragOffset;

    enum TListWindowType {
      LargeIcon, 
      SmallIcon, 
      List, 
      Detail
    } Type;


  DECLARE_RESPONSE_TABLE(TClientWindow);
};

DEFINE_RESPONSE_TABLE1(TClientWindow, TWindow)
  EV_WM_MOUSEMOVE,
  EV_WM_LBUTTONUP,
  EV_COMMAND       (CM_VIEWLARGEICON, CmLargeIcon),
  EV_COMMAND_ENABLE(CM_VIEWLARGEICON, CeLargeIcon),
  EV_COMMAND       (CM_VIEWSMALLICON, CmSmallIcon),
  EV_COMMAND_ENABLE(CM_VIEWSMALLICON, CeSmallIcon),
  EV_COMMAND       (CM_VIEWLIST,      CmList),
  EV_COMMAND_ENABLE(CM_VIEWLIST,      CeList),
  EV_COMMAND       (CM_VIEWDETAIL,    CmDetail),
  EV_COMMAND_ENABLE(CM_VIEWDETAIL,    CeDetail),
  EV_LVN_BEGINDRAG (ListWindId, LvnBeginDrag),
  EV_COMMAND       (CM_SHOWSELECTED,  CmShowSelected),
  EV_COMMAND_ENABLE(CM_SHOWSELECTED,  CeAnySelected),
  EV_COMMAND       (CM_SHOWSTATE,     CmShowSelectionState),
  EV_COMMAND_ENABLE(CM_SHOWSTATE,     CeAnySelected),
  EV_COMMAND       (CM_SHOWSTRINGS,   CmShowSelStrings),
  EV_COMMAND_ENABLE(CM_SHOWSTRINGS,   CeAnySelected),
  EV_COMMAND       (CM_SELECTALL,     CmSelectAll),
  EV_COMMAND       (CM_UNSELECT,      CmUnselect),
  EV_COMMAND_ENABLE(CM_UNSELECT,      CeAnySelected),
END_RESPONSE_TABLE;

TClientWindow::TClientWindow(TWindow* parent)
:
  TWindow(parent),
  ListWind(0),
  DragImage(0),
  InDrag(false)
{
  AssignContextMenu(new TPopupMenu(TMenu(*GetApplication(), IDM_VIEW)));
  Attr.Style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

  // Initialize ImageList
  //
  ImageList = new TImageList(TSize(20, 20), ILC_COLOR4, 15, 5);
  ImageList->Add(TBitmap(*GetApplication(), CM_FILENEW));
  ImageList->Add(TBitmap(*GetApplication(), CM_FILEOPEN));
  ImageList->Add(TBitmap(*GetApplication(), CM_FILESAVE));
  ImageList->Add(TBitmap(*GetApplication(), CM_FILESAVEAS));
  ImageList->Add(TBitmap(*GetApplication(), CM_FILEPRINT));

  ImageList->Add(TBitmap(*GetApplication(), CM_EDITCUT));
  ImageList->Add(TBitmap(*GetApplication(), CM_EDITCOPY));
  ImageList->Add(TBitmap(*GetApplication(), CM_EDITPASTE));
  ImageList->Add(TBitmap(*GetApplication(), CM_EDITFIND));
  ImageList->Add(TBitmap(*GetApplication(), CM_EDITREPLACE));
  ImageList->Add(TBitmap(*GetApplication(), CM_EDITFINDNEXT));
}

TClientWindow::~TClientWindow()
{
  delete ImageList;
}

void
TClientWindow::SetupWindow()
{
  TWindow::SetupWindow();

  // Create Listview control
  //
  Type = Detail;
  ListWind = new TListWindow(this, ListWindId, 40, 40, 400, 200);
  ListWind->Attr.Style |= LVS_SHAREIMAGELISTS | LVS_REPORT;
  ListWind->Create();
  ListWind->SetImageList(*ImageList, TListWindow::Normal);

  TListWindColumn column("Column", 100);
  ListWind->InsertColumn(0, column);

  for (int i = 0; i < ImageList->GetImageCount(); i++) {
    sprintf(Buffer, "Item %d", i);
    TListWindItem item(Buffer);
    item.SetImageIndex(i);
    ListWind->AddItem(item);
  }
}

void
TClientWindow::EvLButtonUp(uint, TPoint&)
{
  if (InDrag) {
    InDrag = false;
    ReleaseCapture();
    TImageList::DragLeave(*this);
    TImageList::EndDrag();
    delete DragImage;
    DragImage = 0;
    ShowCursor(true);
  }
}

void
TClientWindow::EvMouseMove(uint, TPoint& point)
{
  if (InDrag) {
    TImageList::DragMove(point.x + DragOffset.left, point.y + DragOffset.top);
  }
}

void
TClientWindow::LvnBeginDrag(TLwNotify& notify)
{
  InDrag = true;
  TPoint point;
  DragImage = new TImageList(ListWind->CreateDragImage(notify.iItem, &point));

  ListWind->GetItemRect(notify.iItem, &DragOffset, TListWindow::Bounds);

  DragImage->BeginDrag(0, point.x, point.y);
  SetCapture();
  ShowCursor(false);
  TImageList::DragEnter(*this, point.x, point.y);
}

void
TClientWindow::CmLargeIcon()
{
  Type = LargeIcon;
  ListWind->ModifyStyle(LVS_SMALLICON|LVS_REPORT|LVS_LIST, LVS_ICON);
  ListWind->SetImageList(*ImageList, TListWindow::Normal);
/*
  delete ListWind;
  ListWind = new TListWindow(this, ListWindId, 40, 40, 400, 200);
  ListWind->Attr.Style |= LVS_SHAREIMAGELISTS | LVS_ICON;
  ListWind->Create();

  ListWind->SetImageList(*ImageList, TListWindow::Normal);

  for (int i = 0; i < ImageList->GetImageCount(); i++) {
    sprintf(Buffer, "Item %d", i);
    TListWindItem item(Buffer);
    item.SetImageIndex(i);
    ListWind->InsertItem(item);
  }
*/
}

void
TClientWindow::CmSmallIcon()
{
  Type = SmallIcon;
  ListWind->ModifyStyle(LVS_ICON|LVS_REPORT|LVS_LIST, LVS_SMALLICON);
  ListWind->SetImageList(*ImageList, TListWindow::Small);
/*
  delete ListWind;

  ListWind = new TListWindow(this, ListWindId, 40, 40, 400, 200);
  ListWind->Attr.Style |= LVS_SHAREIMAGELISTS | LVS_SMALLICON;
  ListWind->Create();

  ListWind->SetImageList(*ImageList, TListWindow::Small);

  for (int i = 0; i < ImageList->GetImageCount(); i++) {
    sprintf(Buffer, "Item %d", i);
    TListWindItem item(Buffer);
    item.SetImageIndex(i);
    ListWind->InsertItem(item);
  }
*/
}

void
TClientWindow::CmList()
{
  Type = List;
  ListWind->ModifyStyle(LVS_ICON|LVS_REPORT|LVS_SMALLICON, LVS_LIST);
/*
  delete ListWind;

  ListWind = new TListWindow(this, ListWindId, 40, 40, 400, 200);
  ListWind->Attr.Style |= LVS_SHAREIMAGELISTS | LVS_LIST;
  ListWind->Create();

  for (int i = 0; i < ImageList->GetImageCount(); i++) {
    sprintf(Buffer, "Item %d", i);
    TListWindItem item(Buffer);
    ListWind->InsertItem(item);
  }
*/
}

void
TClientWindow::CmDetail()
{
  Type = Detail;
  ListWind->ModifyStyle(LVS_ICON|LVS_LIST|LVS_SMALLICON, LVS_REPORT);
  ListWind->SetImageList(*ImageList, TListWindow::State);
/*
  delete ListWind;

  ListWind = new TListWindow(this, ListWindId, 40, 40, 400, 200);
  ListWind->Attr.Style |= LVS_SHAREIMAGELISTS | LVS_REPORT;
  ListWind->Create();

  ListWind->SetImageList(*ImageList, TListWindow::State);

  TListWindColumn column("Column", 100);
  ListWind->InsertColumn(0, column);

  for (int i = 0; i < ImageList->GetImageCount(); i++) {
    sprintf(Buffer, "Item %d", i);
    TListWindItem item(Buffer);
    item.SetStateImage(i);
    ListWind->InsertItem(item);
  }
*/
}

void
TClientWindow::CmShowSelected()
{
  int indexes[MAX_ITEMS];
  int count = ListWind->GetSelIndexes(indexes, MAX_ITEMS);

  // Fill the dialog's string buffer
  //
  for (int i = 0; i < count; i++)
    itoa(indexes[i], TInfoDialog::strings[i], 10);

  // Now show the dialog
  //
  TInfoDialog showSel(this, IDD_SHOWSELECT, count);
  showSel.Execute();
}

void
TClientWindow::CmShowSelectionState()
{
  // Enumerate all items and fill the dialog's string buffer
  //
  int count = ListWind->GetItemCount();
  for (int i = 0; i < count; i++) {
    wsprintf(TInfoDialog::strings[i],
      "Item %d %s", i, ListWind->IsSelected(i) ? "selected" : "not selected");
  }

  // Show the dialog
  //
  TInfoDialog showSel(this, IDD_SHOWSELECT, count);
  showSel.Execute();
}

void
TClientWindow::CmShowSelStrings()
{
  // allocate an array of strings to receive data from the list view
  //
  char* bufferArray[MAX_ITEMS];
  for (int i = 0; i < ListWind->GetSelCount(); i++)
    bufferArray[i] = new char[MAX_CHARS];

  // fetch the strings from all selected items
  //
  int count = ListWind->GetSelStrings(bufferArray,
                MAX_ITEMS, MAX_CHARS);

  // copy the strings to the dialog's buffer
  //
  for (int i = 0; i < count; i++) {
    lstrcpy(TInfoDialog::strings[i], bufferArray[i]);
    delete [] bufferArray[i];
  }

  // show the dialog
  //
  TInfoDialog showSel(this, IDD_SHOWSELECT, count);
  showSel.Execute();
}

void
TClientWindow::CmSelectAll()
{
  ListWind->SetSelItemRange(true, 0, ListWind->GetItemCount() - 1);
}

void
TClientWindow::CmUnselect()
{
  int indexes[MAX_ITEMS];
  int count = ListWind->GetSelIndexes(indexes, MAX_ITEMS);
  ListWind->SetSelIndexes(indexes, count, false);
}

//----------------------------------------------------------------------------

//
// Class TSampleApp
// ~~~~~ ~~~~~~~~~~
class TSampleApp : public TApplication {
  public:
    TSampleApp()
    :
      TApplication()
    {
    }

    void InitMainWindow();
};

void
TSampleApp::InitMainWindow()
{
  SetMainWindow(new TFrameWindow(0, "ListWindow Example", new TClientWindow));
  GetMainWindow()->AssignMenu(IDM_MENU1);
}

int
OwlMain(int /*argc*/, char* /*argv*/[])
{
  return TSampleApp().Run();
}
