;[]-----------------------------------------------------------------[]
;|      H_CHKSTK.ASM -- Windows stack check function                 |
;[]-----------------------------------------------------------------[]

;
;       C/C++ Run Time Library - Version 6.5
; 
;       Copyright (c) 1987, 1994 by Borland International
;       All Rights Reserved.
; 

        INCLUDE RULES.ASI

; calls to these routines are generated by the compiler to allocate
; stack space if available.  Aborts with message on failure.

MARGIN    equ   1088
pStackTop equ   0Ah

extrn   __errorExitBox:DIST

_DATA   segment
        _stkovrmsg db "Runtime Error: Stack Overflow", 0
        ends

_TEXT   segment
        assume cs:_TEXT
;
;       F_CHKSTK@ - Allocates local space.
;
;       ax      number of bytes for local space

        public  N_CHKSTK@
        public  F_CHKSTK@
        public  __aNchkstk
        public  __aFchkstk

__aNchkstk:
N_CHKSTK@:      pop     bx
                push    cs
                push    bx
__aFchkstk:
F_CHKSTK@:
                pop     bx              ; get return address
                pop     dx
                sub     ax, sp
                jae     overflow
                neg     ax
                mov     cx, ss:[pStackTop]
                add     cx, MARGIN
                cmp     ax, cx          ;StackMax + MARGIN
                jbe     overflow
                mov     sp, ax
                push    dx              ; Note: may use up to four bytes
                push    bx              ; of the reserved stack buffer
                retf
overflow:
                mov    ax, 3
                push   ax
IF LDATA
                push   ds
ENDIF
                lea    ax, _stkovrmsg
                push   ax
                call   __errorExitBox   ; doesn't return!
                ends
                END

