;[]------------------------------------------------------------[]
;|      FTOL.ASM -- Float to Long conversion                    |
;[]------------------------------------------------------------[]

;
;       C/C++ Run Time Library - Version 6.5
; 
;       Copyright (c) 1987, 1994 by Borland International
;       All Rights Reserved.
; 

        NAME    Ftol

include RULES.ASI

emul            ; generate emulated '87 code

CSeg@

; FTOL@
; Calls to FTOL@ are generated by the compiler for code
; that needs to convert a floating point type to an integral type.
; Input: floating point number on the top of the '87.
; Output: a (signed or unsigned) long in AX, DX.
; All other registers preserved.
; Proc is far, independent of memory model.

; Caution: Overflows are ignored.

temp1   equ     [bp-2]
temp2   equ     [bp-10]

ifdef   FCall

PubSym@ FTOL@, <PROC FAR>, __PASCAL__
PubSym@ F_FTOL@, <LABEL FAR>, __PASCAL__

endif

ifdef   NCall

PubSym@ N_FTOL@, <PROC NEAR>, __PASCAL__

endif

        push    bp
        mov     bp, sp
        sub     sp, 10
        fstcw   temp1                   ; save the control word
        fwait
        mov     al, temp1.BY1
        or      temp1.BY1, 0Ch
        fldcw   temp1
        fistp   qword ptr temp2         ; convert to 64-bit integer
        mov     temp1.BY1, al
        fldcw   temp1                   ; restore the control word
        mov     ax, temp2.W0            ; return LS 32 bits
        mov     dx, temp2.W1
        mov     sp, bp
        pop     bp
        ret

ifdef   FCall
EndProc@ FTOL@, __PASCAL__
else
EndProc@ N_FTOL@, __PASCAL__
endif

CSegEnd@

end
