Structures for Ultimate BBS  -  UDGs 
-------------------------------------
TYPE user_record = RECORD
  bbsname  : string[20]; { Real Name }
  sysop    : string[20]; { Sysop Name }
  bbs      : string[30]; { BBS Name }
  phonenum : string[8];  { Phone Number }
  passw    : string[8];  { Password for board }
  charge   : byte;       { How much charged per caller }
  softype  : byte;       { Software type }
  money    : longint;    { Amount of Money }
  hdsize   : longint;    { Hard Drive size }
  hdnum    : integer;    { # of Hard Drives }
  cdnum    : integer;    { # OF CD-ROMS }
  nodes    : integer;    { # OF Nodes }
  maxnode  : byte;       { Max # of nodes the software allows }
  networks : byte;       { Which network are you in }
  doornum  : integer;    { # of Door games }
  regboard : boolean;    { Registred board? }
  tapeback : longint;    { Amount of megs on Tape Back-up }
  tapemax  : integer;    { # of Tapes }
  avgcalls : integer;    { Average number of callers }
  gone     : boolean;    { Player Deleted? } 
  days     : byte;       { Turns a day }
  dials    : byte;       { Dials a day }
  lastply  : word;       { Last date played }
  comp     : integer;    { # of Computers }
  iact     : byte;       { Type of Internet Access: 0=None,1=56K,2=T1 Line,3=T3 Line }
  debt     : longint;    { Sysop's debt }
  bbstype  : byte;       { 0 = Normal, 1 = Pirate, 2 = Adult} 
  nodel    : boolean;    { FALSE = Can be deleted, TRUE = Cannot be deleted }
  onnow    : boolean;    { Is the player on now? Yes/No}
END;

TYPE software_record = RECORD
  name     : string[50]; { Name of software }
  price    : integer;    { Price of Software }
  addnode  : integer;    { Price increase for each node }
  hack1    : integer;    { Hack Random 1 }
  hack2    : integer;    { Hack Random 2 }
  version  : string[7];  { Version number }
  logonseq : string[30]; { Logon Prompt }
  logonscr : string[60]; { Logon Screen directory and file name }
  nameclr  : string[3];  { BBS Name Color }
  lineclr  : string[3];  { Underline FOR BBS Name Color }
  boxclr   : string[3];  { Box Color }
  typeclr  : string[3];  { Types Color }
  prclr    : string[3];  { Types ":" color }
  dataclr  : string[3];  { Data Color }
END;

TYPE auto_record = RECORD
  ln1, ln2 : ARRAY[1..5] OF string[78];  { Lines 1 and 2  }
  name     : ARRAY[1..5] OF string[30];  { Name  }
END;

- Ultimate BBS's drop file format

DOORx.DAT (x = node number)

Line 1 Player record number
Line 2 Player's first name
Line 3 Player's last name
Line 4 Time left
Line 5 Graphics ( 1 = ASCII, 2 and above ANSI, 5 RIP )
Line 6 Com Port
Line 7 Baud rate
Line 8 Locked baud rate

Example:

8
Josh
Eckerman
20
2
1
28800
57600

Todays News
-------------------------------------
Todays News is stored in NEWS.DAT.  Its a text file, so all you have to
do is just append your information to it.


E-Mail
-------------------------------------
EMAILx.DAT, where x is the players record number.  EMAILx.DAT is also
a text file.  <FROM>:x (x = senders record number).  A message to Josh #2
from Craig #12 would look like this:

EMAIL2.DAT

From: Craig

Hey Josh, what are you up to?
<FROM>:12


Color Codes
-------------------------------------
Ultimate BBS's color codes are easy to use.  The have the exact same
format as PCBoard's @Xxx codes.  Except it uses a '|' instead of the '@X'
symbol, |xx.

 - The first x is the background color
   1 = Blue
   2 = Green
   3 = Cyan
   4 = Red
   5 = Purple
   6 = Brown
   7 = Gray


 - The second x is the foreground color
   1 = Blue     6 = Brown          B = Bright Cydn
   2 = Green    7 = Gray           C = Bright Red
   3 = Cyan     8 = Dark Gray      D = Bright Purple
   4 = Red      9 = Bright Blue    E = Yellow
   5 = Purple   A = Bright Green   F = White

- To have text blink make the background color 8
   
