{
  "RSDRIVER.PAS"  ( UNIT : RSDRIVER )  qrQRQbhCoC^[tFCX

}

unit rsdriver;

{----------------------------------------------------------------------}
interface

uses header, jmpcall, dos, kernel, timer;

procedure setrs;
procedure removers;

procedure execrsfunc;
function  MaxCnDrv:byte;
function  rstitle:string;

procedure flowctrl( switch : boolean );
function  outready: boolean;
procedure xmitchar(ch: char);
procedure xmitline(buffer:string);
function  cts:boolean;
function  inready:boolean;
function  breakdetect:char;
function  recvchar:char;
function  recvline:string;
procedure setbaud(speed:rate);
procedure flushed;
procedure getcplt(modemcode:string);
procedure clearmodem;
procedure setup;
function  badframe: boolean;
procedure raiseRTS;
procedure linecut;
procedure hangup;

function  txbufptr(chn:byte):word;
function  rxbufptr(chn:byte):word;

procedure flushwait;

{----------------------------------------------------------------------}
implementation

const
  drvreqrev:revstr='RTRS$102';  { revision  1.02 }

{$IFDEF PRIORITY}
  priority_countnum=64;
{$ENDIF}

  rsinit1   = $0000;
  rsflow1   = $0100;
  gettxlen1 = $0200;
  getrxlen1 = $0300;
  rssend1   = $0400;
  rsrecv1   = $0500;
  initbuf1  = $0600;
  getstat1  = $0700;
  chkcts1   = $0800;
  dropdtr1  = $0900;
  raiserts1 = $0A00;
  break1    = $0B00;
 {reserved  = $0C00;}


var
  rectp:pointer;
  tempp:pointer;

procedure execrsfunc; assembler;
  asm
    les bx,rsdrv
    mov bx,driverhead(es:[bx]).funccall
    mov si,ax
    push es
    push bx
    call callproc
    mov ax,si
  end;

procedure setrs;
  begin
    if rsdrv^.revision<>drvreqrev then runerror(253);
    callproc(@mem[seg(rsdrv^):rsdrv^.setup]);
    writeln('[33mRS232C-',MaxCnDrv,'[m([33m',MaxCnNum,'[m)  [ [32m'+
      rstitle+'[m ] [33menabled.[m');
    dispose(rsdrv^.cmdline);
  end;

procedure removers;
  begin
    callproc(@mem[seg(rsdrv^):rsdrv^.remove]);
  end;

function MaxCnDrv:byte; assembler;
  asm
    les bx,rsdrv
    mov al,driverhead(es:[bx]).channels
  end;

function rstitle:string;
  begin
    rstitle:=rsdrv^.title;
  end;

{---------------------------}

function channel(AHAL: word): word; assembler;
  asm
    mov al,cn
    dec al
    xor ah,ah
    mov cl,12
    shl ax,cl
    or ax,AHAL
  end;

procedure flowctrl(switch:boolean); assembler;
  asm
    push bp
    push ds
    cmp cn,0
    jz @e
    mov ax,rsflow1
    push ax
    call channel
    cmp switch,0
    jnz @1
    or ax,1
 @1:call execrsfunc
 @e:pop ds
    pop bp
  end;

function outready: boolean; assembler;
  asm
    push bp
    push ds
    mov al,1
    cmp cn,0
    jz @e
    mov ax,gettxlen1
    push ax
    call channel
    call execrsfunc
    les bx,rsdrv
    mov bx,driverhead(es:[bx]).txbufs
    or bx,bx
    jnz @1
    or al,al
    jz @2
    xor al,al
    jmp @e
 @2:mov al,1
    jmp @e
 @1:dec bx
    sub bx,ax
    mov al,bl
    or al,bh
 @e:pop ds
    pop bp
  end;

procedure xmitchar(ch: char); assembler;
{$IFDEF PRIORITY}
  asm
    push bp
    push ds
    cmp cn,0
    jz @x
 @1:call outready
    cmp al,0
    jnz @2
    call cts
    cmp al,0
    jz @e
    jmp @1
 @2:mov ax,rssend1
    push ax
    call channel
    mov al,&ch
    call execrsfunc
 @x:mov al,cn
    xor ah,ah
    shl al,1
    shl al,1
    mov bx,offset cnarg
    add bx,ax
    les bx,[bx]
    inc es:cnargrec([bx]).priority
    cmp es:cnargrec([bx]).priority,maxpriority
    jbe @e
    mov es:cnargrec([bx]).priority,maxpriority
 @e:pop ds
    pop bp
  end;
{$ELSE}
  asm
    push bp
    push ds
    cmp cn,0
    jz @e
 @1:call outready
    cmp al,0
    jnz @2
    call kernel.transfernext
    jmp @1
 @2:mov ax,rssend1
    push ax
    call channel
    mov al,&ch
    call execrsfunc
 @e:call kernel.transfernext
    pop ds
    pop bp
  end;
{$ENDIF}

procedure xmitline(buffer:string);
  var
    loop : integer;
    i    : integer;
    ch   : char;
  begin
    waiting(seccnt div 4);      {wait 0.25sec}
    for loop := 1 to length(buffer) do begin
      ch := buffer[loop];
      xmitchar(ch);
      waiting(seccnt div 40);   {wait 0.025sec}
    end;
    waiting(seccnt div 2 + seccnt)  {wait 1.5sec}
  end;

function cts: boolean; assembler;
(*̊֐̓f̃LAΐ^ԂB̓OCЂς
@`FbNBɁA[vɂ͕KȂƁAؒfɃ[v
@邱ƂoȂ̂ŒӁB
  ex.
    repeat {.....} until not cts;
    while cts do begin {.....} end;
*)
  asm
    push ds
    xor ah,ah
    mov al,cn
    mov cl,2
    shl ax,cl
    mov bx,offset cnarg
    add bx,ax
    les bx,[bx]
    mov al,0ffh
    cmp cn,0
    jz @x
    cmp cnargrec(es:[bx]).checkcd,0
    jz @x
    mov ax,chkcts1
    push es
    push bx
    push ax
    call channel
    call execrsfunc
    pop bx
    pop es
    or al,ah
    jz @x
    mov al,0ffh
 @x:and al,cnargrec(es:[bx]).intime
    push ax
    call kernel.transfernext
    pop ax
    pop ds
  end;

function inready: boolean; assembler;
  asm
    push bp
    push ds
    xor al,al
    cmp cn,0
    jnz @x
    call kernel.keypressed
    jmp @e
 @x:mov ax,getrxlen1
    push ax
    call channel
    call execrsfunc
    or al,ah
 @e:pop ds
    pop bp
  end;

function breakdetect: char; assembler;
  asm
    push bp
    push ds
    cmp cn,0
    jz @x
    mov ax,break1
    push ax
    call channel
    call execrsfunc
    jmp @e
 @x:mov al,1
    call exectmfunc
 @e:pop ds
    pop bp
  end;

function recvchar: char; assembler;
{$IFDEF PRIORITY}
  asm
    push bp
    push ds
    cmp cn,0
    jz @x
    mov ax,rsrecv1
    push ax
    call channel
    call execrsfunc
 @x:mov cl,cn
    xor ch,ch
    shl cl,1
    shl cl,1
    mov bx,offset cnarg
    add bx,cx
    les bx,[bx]
    inc es:cnargrec([bx]).priority
    cmp es:cnargrec([bx]).priority,maxpriority
    jbe @e
    mov es:cnargrec([bx]).priority,maxpriority
 @e:pop ds
    pop bp
  end;
{$ELSE}
  asm
    push bp
    push ds
    cmp cn,0
    jz @e
    mov ax,rsrecv1
    push ax
    call channel
    call execrsfunc
 @e:pop ds
    pop bp
  end;
{$ENDIF}

function recvline : string;
  var
    i  : byte;
    wk : string;
    ch : char;
  begin
    i := 0;
    repeat
      if inready then begin
        ch := recvchar;
        if ch <> cr then begin
          inc(i);
          wk[i] := ch;
        end;
      end
      else TransferNext;
    until (ch = cr) or (i=40);
    wk[0] := chr(i);
    while (ch<>lnfd) and (ch <>null) do ch := recvchar;
    if i<>40 then recvline := wk else recvline := '?????';
  end;

procedure setbaud(speed: rate); assembler;
  asm
    push bp
    push ds
    cmp cn,0
    jz @e
    mov ax,rsinit1
    push ax
    call channel
    or al,speed
    call execrsfunc
 @e:pop ds
    pop bp
  end;

procedure clearSIO;
(* RS-232C Ԃɐݒ *)
begin
{ flushed;          NOBUYA }
{ flowctrl(true);   NOBUYA }
  raiseRTS;
  setbaud(cnarg[cn]^.initspeed);
{ setbaud(bau9600); NOBUYA }
end;

{ NOBUYA :֐ύX. }
procedure resetSIO;
var
  speed: rate;
begin
  speed := cnarg[cn]^.initspeed;
  asm
    cmp  cn,0
    jz   @e
    mov  ax,rsinit1
    push ax
    call channel
    mov  al,speed
    call execrsfunc
    mov  ax,1
    push ax
    call flowctrl
 @e:
  end;
end;

procedure flushed; assembler;
  asm
    push bp
    push ds
    cmp cn,0
    jz @e
    mov ax,initbuf1
    push ax
    call channel
    call execrsfunc
 @e:pop ds
    pop bp
  end;

procedure getcplt(modemcode:string);
  var
    temp:string;
    cnt :word;
  begin
    if cn>0 then
      repeat
        clearSIO;
{       setbaud(cnarg[cn]^.initspeed); NOBUYA }
        flushed;
        xmitchar(#$0D);
        xmitline(modemcode);
        raiseRTS;
        temp:='';
        cnt:=gettcount;
        repeat
          repeat
            TransferNext;
          until not cnarg[cn]^.linelock;   (* ]vȏ点Ȃ *)
          if inready then temp:=temp+recvchar
          else raiseRTS;
        until (calctcount(cnt)>seccnt*3) or
          (pos('OK',temp)>0) or (pos('0',temp)>0);
      until (pos('OK',temp)>0) or (pos('0',temp)>0);
  end;

procedure clearmodem;        (* Modem Dependent *)
  var
    junk : string;
  begin
    if (hoststat=cn) and
      (not cnarg[cn]^.NulModem) then writeln('Modem Initializing.');
    clearSIO;
{   setbaud(cnarg[cn]^.initspeed); NOBUYA }
    flushed;
    xmitchar(#$0D);
    if cnarg[cn]^.NulModem then begin
      if cnarg[cn]^.lineexport=lnormal then
        xmitline(#$0D+#$0A+'[ESC]҂܂c'+#$0D+#$0A);
      flushed;
    end
    else begin
      getcplt('ATZ'+#$0D);
      getcplt(cnarg[cn]^.ModemInitCode);
    end;
  end;

procedure setup;
(*aarvOJñn[h*)
  begin
    resetSIO;
  end;

function badframe: boolean; assembler;
  asm
    push bp
    push ds
    cmp cn,0
    jz @e
 @s:mov ax,getstat1
    push ax
    call channel
    call execrsfunc
 @e:pop ds
    pop bp
  end;

procedure linecut; assembler;
  asm
    push bp
    push ds
    cmp cn,0
    jz @e
 @s:mov ax,dropdtr1
    push ax
    call channel
    call execrsfunc
 @e:pop ds
    pop bp
  end;

procedure raiseRTS; assembler;
  asm
    push bp
    push ds
    cmp cn,0
    jz @e
 @s:mov ax,raiserts1
    push ax
    call channel
    call execrsfunc
 @e:pop ds
    pop bp
  end;

procedure hangup;
  begin
    if cn>0 then begin
      if cnarg[cn]^.NulModem then cnarg[cn]^.intime := false
      else begin
        linecut;
        waiting(seccnt*3);
        raiseRTS;
        setup;
      end;
    end
    else cnarg[cn]^.intime := false
  end;

{----------------------------------------------------}

{ for monitoring. }

function txbufptr(chn:byte):word; assembler;
  asm
    push bp
    push ds
    mov al,chn
    dec al
    xor ah,ah
    mov cl,12
    shl ax,cl
    or ax,gettxlen1
    call execrsfunc
    pop ds
    pop bp
  end;

function rxbufptr(chn:byte):word; assembler;
  asm
    push bp
    push ds
    mov al,chn
    dec al
    xor ah,ah
    mov cl,12
    shl ax,cl
    or ax,getrxlen1
    call execrsfunc
    pop ds
    pop bp
  end;

procedure flushwait;
  begin
    if cn > 0 then
      while (txbufptr(cn)>0) and cts do;
  end;


end.

