{
  "PROFSYS.PAS  ( UNIT : PROFSYS )  vtB[

}

unit profsys;

{----------------------------------------------------------------------}
interface

uses
  JmpCall, header, rsdriver,
  kernel, filmangr, monitor, io, sysopcmd, editsys;

procedure showprof(tempid: sysid; withnum: boolean);
procedure profile;

{----------------------------------------------------------------------}
implementation

procedure showprof(tempid: sysid; withnum: boolean);
  var
    tuser  :string[10];
    thandle:name;
    loop   :byte;
    temp   :string;
    test   :boolean;
  begin
  with tempid do begin
    tuser:=user+'          ';
    thandle:=handle+'              ';
    if cts and withnum then stringout('   ');
    stringout('[33mID / Handle_name[m  : [32m');
    lineout(tuser + '[m/[32m' + thandle + '[m');
    lineout('');
    if withnum or (cnarg[cn]^.access=sysop) or openprof then begin
      if withnum then stringout(' 1:');
      stringout('[33mAddress[m  : [32m');
      lineout(address+'[m');
    end;
    if withnum then stringout(' 2:');
    stringout('[33mMachine[m  : [32m');
    lineout(pasocon+'[m');
    if withnum then stringout(' 3:');
    stringout('[33mHobby[m    : [32m');
    lineout(syumi+'[m');
    if withnum then stringout(' 4:');
    stringout('[33mBirthday[m : [32m');
    if ((cnarg[cn]^.access=sysop) and
      ((cn=0) or (not Security))) or openprof then lineout(birthday+'[m')
    else lineout(copy(birthday,4,255)+'[m');
    if ((cnarg[cn]^.access=sysop) and
      ((cn=0) or (not Security))) or openprof then
      begin
      if withnum then stringout(' 5:');
      stringout('[33mPassword[m : [32m');
      lineout(pass+'[m');
      if withnum then stringout(' 6:');
      stringout('[33mName[m     : [32m');
      lineout(namae+'[m');
      if withnum then stringout(' 7:');
      stringout('[33mKanjiname[m: [32m');
      lineout(knamae+'[m');
      if withnum then stringout(' 8:');
      stringout('[33mID[m       : [32m');
      lineout(user+'[m');
      if withnum then stringout(' 9:');
      stringout('[33mHandle[m   : [32m');
      lineout(handle+'[m');
      if withnum then stringout('10:');
      stringout('[33mLevel[m    : [32m');
      lineout(chr(acc+ord('0'))+'[m');
      if withnum then stringout('11:');
      stringout('[33mTelephone[m: [32m');
      lineout(tel+'[m');
      if withnum then stringout('12:');
      stringout('[33mGroup ID[m : [32m');
    end;
    if ((cnarg[cn]^.access>=sigop) and
      ((cn=0) or (not Security))) or openprof then begin
      test:=false;
      for loop:=1 to 100 do
        if group[loop] then begin
          test:=true;
          str(loop,temp);
          stringout('%'+temp+' ');
        end;
      if not test then stringout('[31mݒ');
      lineout('[m');
    end;
    lineout('');
    if not withnum then begin
      if exists(profdrive+tempid.user) then begin
        outfile(profdrive+tempid.user);
        lineout('');
      end;
    end;
  end;
  end;

procedure profile;
  var
  inch   : char;
  idprof : sysid;

  procedure pid;
  var
    profnum : integer;
    tempid  : sysid;
  begin
    if cts then begin
      cnarg[cn]^.prompt := '[36mPROFILE PERSONAL[m :[36m[U[hćH[m ([33m?:userlist  0:quit[m) >';
      profnum := getid(cnarg[cn]^.prompt);
      if profnum=0 then exit;
      if (profnum < 0) or ((cnarg[cn]^.idrec.acc = 0) and
        (cnarg[cn]^.access < sysop)) then begin
        lineout('');
        lineout('[31mhc̎w肪Ⴂ܂B[m');
      end
      else begin
        lineout('');
        tempid:=cnarg[cn]^.idrec;
        showprof(tempid, false);
      end;
    end;
  end;


  procedure plist;
  var
    i      : integer;
    tempid : sysid;
  begin
    if cts then begin
      cnarg[cn]^.prompt := '[36mPROFILE LIST[m :[36mn߂̂hćH[m ([33m[RET]:allusers[m) >';
      i := getid1(cnarg[cn]^.prompt);
      if i >= 1 then begin
        lineout('');
        seekB(idfil,i-1);
        while not(eofB(idfil) or cnarg[cn]^.cancelled) do begin
          readB(idfil, @tempid);
          if cts and not ((tempid.acc = 0) and
            (cnarg[cn]^.access < sysop)) then
          showprof(tempid, false);
          inc(i);
          seekB(idfil,i-1);
        end;
        if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
      end
      else begin
        lineout('');
        lineout('[31mhc̎w肪Ⴂ܂B[m');
      end;
    end;
  end;


procedure psearch;
  var
    key    : string;
    tempid : sysid;
    innum  : char;
    temp   : integer;
    dumy   : integer;
    prompt : string;  { local redefine }
    chk    : boolean;
  function selstr(inch:char):string;
    begin
      case inch of
        'N':selstr:='Ȱ';
        'K':selstr:='Ŏ';
        'S':selstr:='';
        'A':selstr:='Z';
        'T':selstr:='dbԍ';
        'M':selstr:='gp@';
        'H':selstr:='';
        'B':selstr:='a';
        'G':selstr:='ٰID';
      end;
    end;
begin
  if cts then begin
    repeat
      lineoutifneed;
      if cnarg[cn]^.inbuffer='' then begin
        prompt:='[36mΏ[m ([33mN: M:@ H: B:a';
        if cnarg[cn]^.access>=sigop then prompt:=prompt+' G:ٰ';
        if cnarg[cn]^.access=sysop then
          prompt:=prompt+' K:Ҳ S: A:Z T:db';
        lineout(prompt+'[m)');
      end;
      lineoutifneed;
      prompt:='[36mPROFILE SEARCH[m :[36mڂIĉ[m ([33m0:quit[m) >';
      innum:=getcap(prompt);
      if (innum in ['N','M','H','B']) or
        ((cnarg[cn]^.access>=sigop) and (innum='G')) or
        ((cnarg[cn]^.access=sysop) and (innum in ['K','S','A','T'])) then begin
        lineoutifneed;
        prompt:='[36m镶܂͔ԍ[m [[32m'+selstr(innum)+
          '[m] >';
        key := getinput(prompt, 80, echo);
        lineout('');
        chk:=false;
        seekB(idfil, 0);
        while cts and not(eofB(idfil) or cnarg[cn]^.cancelled) do begin
          readB(idfil, @tempid);
          case innum of
            'T' : if pos(key, tempid.tel     )>0 then begin
                  chk:=true;
                  showprof(tempid,false);
            end;
            'K' : if pos(key, tempid.namae   )>0 then begin
                  chk:=true;
                  showprof(tempid,false);
            end;
            'S' : if pos(key, tempid.knamae  )>0 then begin
                  chk:=true;
                  showprof(tempid,false);
            end;
            'N' : if pos(key, tempid.handle  )>0 then begin
                  chk:=true;
                  showprof(tempid,false);
            end;
            'A' : if pos(key, tempid.address )>0 then begin
                  chk:=true;
                  showprof(tempid,false);
            end;
            'M' : if pos(key, tempid.pasocon )>0 then begin
                  chk:=true;
                  showprof(tempid,false);
            end;
            'H' : if pos(key, tempid.syumi   )>0 then begin
                  chk:=true;
                  showprof(tempid,false);
            end;
            'B' : if pos(copy(key,4,255), tempid.birthday)>0 then begin
                  chk:=true;
                  showprof(tempid,false);
            end;
            'G' : begin
                  val(key,temp,dumy);
                  if copy(key,1,1)='%' then val(copy(key,2,255),temp,dumy);
                  if (temp<=100) and (temp>0) and (dumy=0) then begin
                    if tempid.group[temp] then begin 
                      chk:=true;
                      showprof(tempid,false);
                    end;
                  end;
            end;
          end;
        end;
        if cnarg[cn]^.cancelled then begin
          cnarg[cn]^.cancelled:=false;
          lineout('');
          lineout('[33m𒆎~܂B[m');
        end
        else if not chk then begin
          lineout('');
          lineout('[33m܂łB[m');
        end;
      end
      else if (innum<>'0') and (innum<>'') then begin
        lineout('');
        lineout('[31mgpo܂B[m');
      end;
    until (innum = '0') or not cts;
  end;
end;


procedure pedit;
var
  number, innum, i : integer;
  wk   :byte;
  temp :string;
begin
  if cts then begin
    if cnarg[cn]^.access=sysop then begin
      cnarg[cn]^.prompt:='[36mPROFILE EDIT[m :[36mύXhc[m ([33m?:userlist  0:quit[m) >';
      number := getid(cnarg[cn]^.prompt);
    end
    else number := cnarg[cn]^.usernum;
    if number=0 then begin
      lineout('');
      lineout('[31m߂܂B[m');
      exit;
    end;
    if number > 0 then begin
      if cts and islockB(idfil, number-1) then begin
        lineout('');
        lineout('[31m`lŎgp̂ߕҏWł܂B[m');
        exit;
      end;
      lockB(idfil, number-1);
      seekB(idfil, number-1);
      readB(idfil, @idprof);
      repeat
        lineout('');
        showprof(idprof,true);
        cnarg[cn]^.prompt:='[36mPROFILE EDIT[m :[36mǂ̍ڂύX܂H[m ([33m0:quit[m) >';
        if cts and (cnarg[cn]^.access = sysop) and
          ((cn = 0) or (not Security)) then
          innum:=getint(12, 0, cnarg[cn]^.prompt)
        else innum:=getint(4, 0, cnarg[cn]^.prompt);
        case innum of
          1 : if cnarg[cn]^.access=sysop then begin
              lineout('');
              lineout('[33mZ[32mSpSOȓ[33mœ͂ĉB[m');
              idprof.address := getaddress;
              end
              else begin
                lineout('');
                lineout('[31m̍ڂ͕ύXo܂B[m');
              end;
          2 : begin
              lineout('');
              lineout('[33m@[32mpWOȓ[33mœ͂ĉB[m');
              idprof.pasocon := getpasocon;
              end;
          3 : begin
              lineout('');
              lineout('[33mȂǂ[32mSpSOȓ[33mœ͂ĉB[m');
              idprof.syumi := getsyumi;
              end;
          4 : if cnarg[cn]^.access=sysop then begin
              lineout('');
              lineout('[33ma[32m *##/##/##[33m ̌`œ͂ĉB[m');
              idprof.birthday := getbirthday;
              end
              else begin
                lineout('');
                lineout('[31m̍ڂ͕ύXo܂B[m');
              end;
          5 : begin
              lineout('');
              lineout('[33mpX[h[32mWȓ[33mœ͂ĉB[m');
              idprof.pass := getpass;
              end;
          6 : begin
              lineout('');
              lineout('[33mO[32m()[33m͂ĉB[m');
              idprof.namae := getnamae;
              end;
          7 : begin
              lineout('');
              lineout('[33mO[32m()[33m͂ĉB[m');
              idprof.knamae := getknamae;
              end;
          8 : begin
              lineout('');
              lineout('[31mύXs\̍ڂłB[m');
              end;
          9 : begin
              lineout('');
              lineout('[33mnh[32mWȓ[33mœ͂ĉB[m');
              idprof.handle := gethandle;
              end;
          10 : if number>1 then begin
              lineout('');
              lineout('[33mx͂ĉB[m ([33m0-5[m)');
              idprof.acc := getint(5, 0, 'Level >');
              end
              else if number=1 then begin
                lineout('');
                lineout('[31mrxrnõx͕ύXo܂B[m');
              end
              else begin
                lineout('');
                lineout('[31m̍ڂ͕ύXo܂B[m');
              end;
          11: if cnarg[cn]^.access=sysop then begin
              lineout('');
              lineout('[33mdbԍ [32m###-###-####[33m ̌`œ͂ĉB[m');
              idprof.tel := gettel;
              end
              else begin
                lineout('');
                lineout('[31m̍ڂ͕ύXo܂B[m');
              end;
          12: if cnarg[cn]^.access=sysop then begin
              lineout('');
              lineout('[33mύXO[vhc͂ĉB[m([33m0:quit[m)');
              wk:=getint(100,0,'[36mGroup ID[m ([33m0-100[m) >');
              if wk>0 then begin
                idprof.group[wk]:=not idprof.group[wk];
                str(wk,temp);
                lineout('');
                stringout('[31mO[vhc[32m '+temp+'[31m ́A');
                if idprof.group[wk] then
                  lineout('[36mݒ [31m܂B[m')
                else lineout('[31m [31m܂B[m');
              end
              else begin
                lineout('');
                lineout('[31m~܂B[m');
              end;
              end
              else begin
                lineout('');
                lineout('[31m̍ڂ͕ύXo܂B[m');
              end;
        end;
      until (innum=0) or not cts;
      seekB(idfil, number-1);
      writeB(idfil, @idprof);
      unlockB(idfil);
      for i:=0 to MaxCnNum do begin
        if cnarg[i]^.usernum=number then
          with idprof do with cnarg[i]^ do begin
          password := pass;
          caller := user;
          handle_name := handle;
          access := acc;
        end;
      end;
      lineout('');
    end
    else lineout('[31mhc̎w肪Ⴂ܂B[m');
  end;
end;


procedure pwrite;
  var
    inch : char;
    rslt : byte;
  begin
    if cts then begin
      if not exists(profdrive+cnarg[cn]^.caller) then begin
        lineout('');
        lineout('[33mVvtB[ݒ肵܂B[m');
      end
      else if not setfile(profdrive+cnarg[cn]^.caller) then begin
        lineout('');
        lineout('[31mGfBbgobt@܂B[m');
        exit;
      end;
      compose(eline);  (* ҏWpɃx^GfB^͎gȂ *)
      repeat
        lineoutifneed;
        inch := getcap('[36mPROFILE EDIT[m ([33mW:write  E:edit  0:quit[m) >');
        case inch of
          'E': compose(eline);  (* ҏWpɃx^GfB^͎gȂ *)
          'W': begin
             if cts then begin
               lineout('');
               stringout('[32mݒ ...');
               if not getfile(nametemp) then begin
                 lineout(' [31mGfBbgobt@܂B[m');
                 exit;
               end;
               FileCopy(nametemp, profdrive+cnarg[cn]^.caller, rslt);
               if rslt = 0 then lineout(' [33mI܂B[m')
               else lineout(' [31m݂Ɏs܂B[m');
             end;
             end;
          '0': begin
             lineout('');
             if getyesno(
               '[36m~Ă낵łH[m (Y/[33m[N][m) >')
               <>'Y' then begin
               lineout('');
               lineout('[33ms܂B[m');
               inch:=#$00;
             end
             else begin
               lineout('');
               lineout('[31m݂𒆎~܂B[m');
             end;
          end;
        end;
      until (inch = '0') or (inch = 'W') or not cts;
    end;
  end;


begin {of profile}
  cnarg[cn]^.CnStat := zprofile;
  if hoststat = 0 then dispstatus(cn);
  if cts then begin
    if cnarg[cn]^.access < reg then begin
      lineout('');
      lineout('[31mQXg͎gpo܂B[m')
    end
    else if cts then begin
      if cnarg[cn]^.expert=ebegin then begin
        lineout('');
        outfile(bmesdrive+j_profmenu);
      end;
      repeat
        lineoutifneed;
        cnarg[cn]^.prompt:='[36mPROFILE[m ([33mL,P,S,E,W,H,?,0[m) >';
        inch := getcap(cnarg[cn]^.prompt);
        case inch of
          'L' : plist;
          'P' : pid;
          'S' : psearch;
          'E' : pedit;
          'W' : pwrite;
          'H' : begin
                lineout('');
                outfile(bmesdrive+j_profhelp);
          end;
          '?' : begin
                lineout('');
                outfile(bmesdrive+j_profmenu);
          end;
        end;
      until (inch = '0') or not cts;
    end;
  end;
end;


end.

