{
  "MAILSYS.PAS  ( UNIT : MAILSYS )  [VXe
}

unit mailsys;

{----------------------------------------------------------------------}
interface

uses
  Dos, JmpCall, rsdriver,
  header, kernel, filmangr, monitor, io, editsys, profsys, boardsys;

procedure getsect;
procedure receive;
procedure enter(modes:entermode;i,j:integer);
procedure search(choice:searches);
procedure quickscan(i,j:integer);
procedure readmail;
procedure mailpilot;

{----------------------------------------------------------------------}
implementation

const
  deletedmess = -1;
  maxmess     = 9999;
  interval    = 3;     (* transfer on messagesearch *)
  intrtrans   = 7;     (* transfer on find`        *)


var
  tabloc  : integer;
  inch    : char;
  ok      : boolean;
  ent     : boolean;
  i       : byte;


function secure : boolean;
  (* ̃bZ[W@ǂ    (Ȃ̒Nĝ :-) *)
  begin
    with cnarg[cn]^.messdat do
      secure := ((cnarg[cn]^.usernum <> sender)
             and (cnarg[cn]^.usernum <> recver)
       and (cnarg[cn]^.access  <  sysop )) or (cnarg[cn]^.usernum =  0);
  end;

procedure getsect;
  var
    instr: string8;
    inch : integer;
    dumy : integer;
    recs : integer;
    buf  : secttype;
  begin
    putinfo;
    repeat
      lineoutifneed;
      if cnarg[cn]^.inbuffer='' then sectheader('Message');
      cnarg[cn]^.prompt:='[36mSELECT[m :[36m{[h  {[hԍ[m ([33mnn,#nn,name,I,A,L,N,S,H,?,Q[m) >';
      instr:=allcaps(getinput(cnarg[cn]^.prompt,8,echo));
      if instr='I' then outinfo
      else if instr='L' then listsections
      else if instr='A' then allsections
      else if instr='$' then custboard
      else if instr='?' then begin
        lineout('');
        outfile(bmesdrive+j_selmenu);
      end
      else if instr='H' then begin
        lineout('');
        outfile(bmesdrive+j_selhelp);
      end
      else if instr='N' then search(snews)
      else if instr='S' then search(ssearch)
      else if instr='Q' then cnarg[cn]^.sect.attrib:=anone
      else if copy(instr,1,1)='#' then begin   (* Δԍw *)
        val(copy(instr,2,255),inch,dumy);
        if (dumy>0) or (inch>=filesizeB(mbdfil)) or
          (inch=0) or (length(instr)=1) then begin
          lineout('');
          lineout('[31m{[h܂B[m');
        end
        else begin
          seekB(mbdfil,inch);
          readB(mbdfil,@buf);
          if paththru(buf) then begin
            cnarg[cn]^.sect:=buf;
            putinfo;
          end;
        end;
      end
      else begin
        val(instr,inch,dumy);
        if (inch>0) and (inch<11) then begin  (* ԍw *)
          if cnarg[cn]^.sect.downb[inch-1]=0 then begin
            lineout('');
            lineout('[31m{[h܂B[m');
          end
          else begin
            seekB(mbdfil,cnarg[cn]^.sect.downb[inch-1]);
            readB(mbdfil,@buf);
            if testin(buf,true) then begin
              cnarg[cn]^.sect:=buf;
              putinfo;
            end;
          end;
        end
        else if (inch<0) or (inch>10) then begin
          lineout('');
          lineout('[31m{[h̎w肪Ⴂ܂B[m');
        end
        else if (inch=0) and (dumy=0) then begin  (* Kwオ *)
          if (cnarg[cn]^.sect.number=1) or (cnarg[cn]^.sect.back=0) then
            cnarg[cn]^.sect.attrib:=anone
          else begin
            seekB(mbdfil,cnarg[cn]^.sect.back);
            readB(mbdfil,@cnarg[cn]^.sect);
            putinfo;
          end;
        end
        else if dumy>0 then begin  (* Ύw({[h) *)
          seekB(mbdfil,1);
          repeat
            readB(mbdfil,@buf);
          until eofB(mbdfil) or (buf.bname=instr) or not cts;
          if (buf.bname<>instr) and (instr<>'') then begin
            lineout('');
            lineout('[31m{[h܂B[m');
          end
          else if (instr<>'') and paththru(buf) then begin
            cnarg[cn]^.sect:=buf;
            putinfo;
          end;
        end;
      end;
    until (cnarg[cn]^.sect.attrib<>amenu) or not cts;
  end;

procedure status2;
  var
    temp: string;
  begin
    if cts then begin
      lineoutIfNeed;
      if cnarg[cn]^.firstmess <> 0 then begin
        str(cnarg[cn]^.firstmess, temp);
        stringout('[33mbZ[W [32m#' + temp);
        str(cnarg[cn]^.lastmess, temp);
        lineout(
          ' [33m [32m#'+temp+' [33m܂œo^Ă܂B[m');
      end
      else lineout('[31mbZ[W͓o^Ă܂B[m');
      lineout('');
    end;
  end;


procedure initmess;
{
  messcount = LbZ[Wi폜܂ށj
  nextmess  = ̃bZ[Wɕtԍ
}
  var
    dumy : integer;
  begin
    cnarg[cn]^.messcount := 0;
    cnarg[cn]^.firstmess := 0;
    cnarg[cn]^.lastmess := 0;
    cnarg[cn]^.nextmess := 1;
    if filesizeB(mesfil) > 0 then begin
      seekB(mesfil, 0);
      readB(mesfil, @cnarg[cn]^.messdat);
      cnarg[cn]^.firstmess := cnarg[cn]^.messdat.number;
      cnarg[cn]^.messcount := filesizeB(mesfil);
      seekB(mesfil, cnarg[cn]^.messcount-1);
      readB(mesfil, @cnarg[cn]^.messdat);
      cnarg[cn]^.lastmess := cnarg[cn]^.messdat.number;
      cnarg[cn]^.nextmess := cnarg[cn]^.lastmess+1;
    end;
  end;

function ismess(snd,rcv:integer;sch:string):boolean;
  var
    sndbl,rcvbl,sstr:boolean;
  begin
    with cnarg[cn]^.messdat do begin
      if snd=-1 then sndbl:=false
      else sndbl:=(snd=sender);
      if rcv=-1 then rcvbl:=not sndbl
      else rcvbl:=(rcv=recver) xor sndbl;   (* [₱ *)
      if sch='' then sstr:=true
      else sstr:=(pos(sch,subject)>0);
      ismess:=(sndbl or rcvbl) and
        (rec>0) and (recver<>deletedmess) and
        (cnarg[cn]^.sect.r<=cnarg[cn]^.access) and sstr;
    end;
  end;

function iscanreadmess(snd,rcv:integer):boolean;
  begin
    iscanreadmess:=ismess(snd,rcv,'');
    {and not ((cnarg[cn]^.sect.number=0) and cnarg[cn]^.messdat.recved); }
  end;

function findspeed(startmess: integer): integer;
  var
    loop : integer;
    tm   : byte;
  begin
    initmess;
    loop:=startmess;
    if loop<cnarg[cn]^.messcount then begin
      repeat
        for tm:=0 to intrtrans do transfernext;
        seekB(mesfil,loop-1);
        readB(mesfil,@cnarg[cn]^.messdat);
        inc(loop);
      until (cnarg[cn]^.messdat.recver<>deletedmess) or
        (loop>cnarg[cn]^.messcount);
      if cnarg[cn]^.messdat.recver=deletedmess then begin
        repeat
          dec(loop);
          for tm:=0 to intrtrans do transfernext;
          seekB(mesfil,loop-1);
          readB(mesfil,@cnarg[cn]^.messdat);
        until (cnarg[cn]^.messdat.recver<>deletedmess) or
          (loop=1);
      end;
      if cnarg[cn]^.messdat.recver=deletedmess then findspeed:=0
      else findspeed:=loop-1;
    end
    else findspeed:=cnarg[cn]^.messcount;
  end;

function isqref(x:integer):boolean;
  begin
    isqref:=((cnarg[cn]^.messdat.recver<>deletedmess) and
      (cnarg[cn]^.messdat.number=x));
  end;

function findmessage(x: integer): integer;
  (* findspeed Ŋ_Aǂ߂郁bZ[W{ *)
  var
    loop  : integer;
    tm    : byte;
  begin
    loop:=findspeed(x);
    if loop>0 then begin
      repeat
        for tm:=0 to intrtrans do transfernext;
        seekB(mesfil,loop-1);
        readB(mesfil,@cnarg[cn]^.messdat);
        inc(loop);
      until isqref(x) or (loop>cnarg[cn]^.messcount);
      if isqref(x) then findmessage:=loop-1
      else findmessage:=0;
    end;
  end;

function findnewmess(sdr,rcvr:integer;lsto: DateTime):integer;
  (* 肪Ƃ܂ NOBUYA                      *)
  (* iÕ\[X܂ɂnnĂi΁jj *)
  var
    top   : integer;
    bottom: integer;
    index : integer;
    ldate : longint;
    maskd : longint;
    loop  : byte;
  begin
    initmess;
    ldate:=dt2bin(lsto);
    top:=cnarg[cn]^.messcount+1;
    bottom:=0;
    if top=1 then begin
      findnewmess:=0;
      exit;
    end;
    repeat
      for loop:=0 to intrtrans do transfernext;
      index:=(top+bottom+1) div 2;
      seekB(mesfil,index-1);
      readB(mesfil,@cnarg[cn]^.messdat);
      maskd:=dt2bin(cnarg[cn]^.messdat.date);
      if maskd=ldate then begin
        if iscanreadmess(sdr,rcvr) then begin
          findnewmess:=index;
          exit;
        end;
        bottom:=index;
      end
      else if maskd<ldate then bottom:=index
      else top:=index;
    until (abs(top-bottom)<=1);
    if bottom>=cnarg[cn]^.messcount then begin
      findnewmess:=0;
      exit;
    end;
    if maskd>ldate then dec(index);
    repeat
      for loop:=0 to intrtrans do transfernext;
      inc(index);
      seekB(mesfil,index-1);
      readB(mesfil,@cnarg[cn]^.messdat);
    until iscanreadmess(sdr,rcvr) or (index=cnarg[cn]^.messcount);
    if iscanreadmess(sdr,rcvr) then findnewmess:=index
    else findnewmess:=0;
  end;


function titlesearch(s:string): integer;
  (* ΂͏ł˂ *)
  var
    count : integer;
    loop  : integer;
    brk   : char;
    tm    : byte;
  begin
    initmess;
    loop:=cnarg[cn]^.messcount;
    count:=0;
    if loop>0 then begin
      repeat
        for tm:=0 to 3 do transfernext;
        seekB(mesfil,loop-1);
        readB(mesfil,@cnarg[cn]^.messdat);
        dec(loop);
        if (isqref(cnarg[cn]^.messdat.number) and
          (pos(s,cnarg[cn]^.messdat.subject)>0)) then inc(count);
        brk:=breakdetect;
      until (loop=0) or (brk=#$13) or not cts;
        (* Ԃ|Ă邤ɗƂ܂ cts Ă *)
        (* 炢炷l̂߂ Break check ꂽ                 *)
      titlesearch:=count;
      if brk=#$13 then cnarg[cn]^.cancelled:=true;
    end
    else titlesearch:=0;
  end;

function countarticle(sdr,rcv:integer;rec:integer):integer;
  (* cA[eBN𐳊mɐ *)
  var
    loop,count:integer;
  begin
    initmess;
    loop:=cnarg[cn]^.messcount;
    count:=0;
    if loop>0 then begin
      repeat
        seekB(mesfil,loop-1);
        readB(mesfil,@cnarg[cn]^.messdat);
        dec(loop);
        if iscanreadmess(sdr,rcv) then inc(count);
      until (loop<rec) or not cts;
    end;
    countarticle:=count;
  end;


procedure headtail; (*̃bZ[W̃wb_\*)
  var
    temp    : string;
    temp2   : string;
    res     : string[20];
    message : datetime;
    years, months, dates, hours, mins, secs:word;
  begin
    if cts then with cnarg[cn]^.messdat do begin
      clock(years, months, dates, hours, mins, secs);
      message:=time(years, months, dates, hours, mins, secs);
      lineout('[33m=============================================================[32m '+message+'[m');
      stringout('[32mSection[m : ');
      if cnarg[cn]^.sect.number=0 then stringout('[35mPrivate mail[m')
      else begin
        str(cnarg[cn]^.sect.number,temp);
        temp:=copy('000'+temp,length(temp)+1,3);
        stringout('[36m'+cnarg[cn]^.sect.nam+' [m([32m#'+temp+'[m)');
        str(number:4,temp);
        stringout('  [33mNo.'+temp+'[m');
      end;
      if (cnarg[cn]^.access=sysop) and (rec>0) then begin
        str(rec:5,temp);
        lineout('   ([33mrecord[m:[31m'+temp+'[m)');
      end
      else lineout('');
      temp:=getname(sender)+' ['+gethandle(sender)+']';
      stringout('[32mSender[m  : '+temp);
      if recver>0 then
        temp:='  [32mReciever[m: '
          +getname(recver)+' ['+gethandle(recver)+']'
      else if recver=0 then begin
        str(reply:4,temp2);
        if reply>0 then temp:='    [32mMap[m ([34m'+temp2+'[m-'
        else temp:='    [32mMap[m (    |';
        str(number:4,temp2);
        temp:=temp+'[36m'+temp2+'[m';
        str(refwd:4,temp2);
        if refwd>0 then temp:=temp+'-[34m'+temp2+'[m)'
        else temp:=temp+'|    )';
      end
      else temp:='  [31mDestroyed file.[m';
      if recved then begin
        temp:=temp+'  [33m(published)[m';
      end;
      lineout(temp);
      lineout('[32mDate[m    : [32m'+date+'[m');
      res:='';
      if reply<>0 then begin
        str(reply, temp);
        if cnarg[cn]^.sect.number>0 then res:='[33mRes [#'+temp+']:[m'
        else res:='[33mRes <'+temp+'>:[m'
      end;
      lineout('[32mSubject[m : ' + res + dellastkanji(copy(subject,1,55)));
      lineout('[33m-------------------------------------------------------------------------------[m');
    end;
  end;


procedure headtailm; (* ȗ^Xg *)
  var
    temp: string;
    res : string[20];
    teln:byte;
  begin
    if cts then with cnarg[cn]^.messdat do begin
      str(number:4, temp);
      stringout(temp);
      temp:=' [36m'+getname(sender)+
        ' [33m'+gethandle(sender)+'[m';
      if cnarg[cn]^.sect.number=0 then begin
        stringout(temp);
        temp:=' [36m'+getname(recver)+' [33m'+gethandle(recver)+'[m ';
        stringout(temp);
        if recved then stringout('[35mo ')
        else stringout('[31m. ');
      end
      else stringout(temp+' [32m'+date+' ');
      res:='';
      teln:=34;
      if reply<>0 then begin
        str(reply,temp);
        if cnarg[cn]^.sect.number>0 then res:='[33mRes[#'+temp+']:[m'
        else res:='[33mRes<'+temp+'>:[m';
        teln:=44;
      end;
      lineout('[m' + dellastkanji(copy(res+subject,1,teln)));
    end;
  end;


procedure destroy(tabloc: integer);
  var
    loop     : integer;
    buf,buf2 : messages;
    recbak   : word;
  begin
    lineout('');
    stringout('[32m폜 ...');
    if tabloc>0 then begin
      recbak:=cnarg[cn]^.messdat.rec;
      while islockB(mesfil, tabloc-1) do TransferNext;
      lockB(mesfil, tabloc-1);
      seekB(mesfil, tabloc-1);
      readB(mesfil, @cnarg[cn]^.messdat);
      cnarg[cn]^.messdat.recver := deletedmess;
      cnarg[cn]^.messdat.rec := 0;
      seekB(mesfil, tabloc-1);
      writeB(mesfil, @cnarg[cn]^.messdat);
      unlockB(mesfil);
      if cnarg[cn]^.sect.number>0 then begin
        if (cnarg[cn]^.messdat.reply>0) and
          (cnarg[cn]^.messdat.refwd>0) then begin
          seekB(mesfil, cnarg[cn]^.messdat.reply-1);
          readB(mesfil, @buf);
          seekB(mesfil, cnarg[cn]^.messdat.refwd-1);
          readB(mesfil, @buf2);
          buf.refwd := cnarg[cn]^.messdat.refwd;
          buf2.reply := cnarg[cn]^.messdat.reply;
          seekB(mesfil, cnarg[cn]^.messdat.reply-1);
          writeB(mesfil, @buf);
          seekB(mesfil, cnarg[cn]^.messdat.refwd-1);
          writeB(mesfil, @buf2);
        end
        else if cnarg[cn]^.messdat.reply>0 then begin
          seekB(mesfil, cnarg[cn]^.messdat.reply-1);
          readB(mesfil, @buf);
          buf.refwd := 0;
          seekB(mesfil, cnarg[cn]^.messdat.reply-1);
          writeB(mesfil, @buf);
        end
        else if cnarg[cn]^.messdat.refwd>0 then begin
          seekB(mesfil, cnarg[cn]^.messdat.refwd-1);
          readB(mesfil, @buf);
          buf.reply := 0;
          seekB(mesfil, cnarg[cn]^.messdat.refwd-1);
          writeB(mesfil, @buf);
        end;
      end;
      killrec(recbak);
      lineout(' [33m폜܂B[m');
    end;
  end;


procedure readfile(tabloc: integer);
  var
    logs:boardlog;
    day:word;
  begin
    if cts then begin
      seekB(mesfil,tabloc-1);
      readB(mesfil,@cnarg[cn]^.messdat);
      with cnarg[cn]^.messdat do begin
        typedata(rec);
        if (recver=cnarg[cn]^.usernum) and (cnarg[cn]^.usernum>0) then begin
          recved:=true;
          seekB(mesfil, tabloc-1);
          writeB(mesfil, @cnarg[cn]^.messdat);
        end;
      end;
      if cnarg[cn]^.sect.number>0 then begin
        with logs do begin
          user:=cnarg[cn]^.usernum;
          if cnarg[cn]^.messdat.reply>0 then begin
            str(cnarg[cn]^.messdat.reply,article);
            article:='Res[#'+article+']:';
          end
          else article:='';
          article:=article+cnarg[cn]^.messdat.subject;
          article:=dellastkanji(article);
          written:=false;
          clock(year,month,day,hour,min,sec);
          date:=time(year,month,day,hour,min,sec);
          protocol:=none;  (* gp *)
        end;
        writebdlog(logs);
      end;
    end;
  end;

procedure delmessage(x: integer);
  var
    tabloc: integer;
  begin;
    tabloc := findmessage(x);
    if cts then begin
      if tabloc > 0 then begin
        if (cnarg[cn]^.usernum>0) and
          ((cnarg[cn]^.usernum=cnarg[cn]^.messdat.sender) or
          ((cnarg[cn]^.sect.number>0) and issigop) or
          ((cnarg[cn]^.sect.number=0) and
          (cnarg[cn]^.usernum=cnarg[cn]^.messdat.recver))) then begin
          lineoutifneed;
          headtail;
          lineoutifneed;
          cnarg[cn]^.prompt:='[36mKILL[m :[36m폜Ă낵łH[m (Y/[33m[N][m) >';
          if GetYesNo(cnarg[cn]^.prompt)='Y' then destroy(tabloc);
        end
        else begin
          lineout('');
          lineout('[31m̃bZ[W͍폜ł܂B[m');
        end;
      end
      else begin
        lineout('');
        lineout('[31mbZ[W܂B[m');
      end;
    end;
  end;

function getmwithlist(i,j:integer;s:string):integer;
  var w:integer;
  begin
    repeat
      lineoutifneed;
      w:=getint(cnarg[cn]^.nextmess-1,0,s);
      if w=-1 then quickscan(i,j);
    until (w>=0) or not cts;
    getmwithlist:=w;
  end;

procedure deletex(i,j:integer);
  var
    w : integer;
  begin
    cnarg[cn]^.CnStat := zkill;
    if hoststat = 0 then dispstatus(cn);
    if cts then begin
      cnarg[cn]^.prompt := '[36mKILL[m :[36mԂ폜܂H[m ([33m?:titlelist  [RET]:quit[m) >';
      w:=getmwithlist(i,j,cnarg[cn]^.prompt);
      if w>0 then delmessage(w)
      else begin
        lineout('');
        lineout('[31m폜𒆎~܂B[m');
      end;
    end;
  end;

procedure newheader(var entry: messages;modes:entermode;j,k:integer;
  var ok: boolean);
  var
    temp, tonum : integer;
    ch : char;
    i  : integer;
  procedure e_res;
  var
    messtmp : messages;
    nowrite : boolean;
    temp   : string;
    lenres : byte;
    i : integer;
    w : integer;
  begin
    messtmp := entry;
    cnarg[cn]^.prompt := '[36mRESPONSE[m :[36mԂ̃X|XłH[m ([33m?:titlelist  [RET]:quit[m) >';
    w:=getmwithlist(j,k,cnarg[cn]^.prompt);
    if w>0 then begin
      tabloc := findmessage(w);
      nowrite:=(cnarg[cn]^.sect.w>cnarg[cn]^.access) or
        ((cnarg[cn]^.sect.number=0) and
        (cnarg[cn]^.usernum<>cnarg[cn]^.messdat.recver));
    end
    else tabloc := 0;
    cnarg[cn]^.refwds:=tabloc;
    if tabloc>0 then begin
      if not nowrite then begin
        with cnarg[cn]^.messdat do begin
          lineoutifneed;
          if cnarg[cn]^.inbuffer='' then
            lineout('[32mX|XԂ܂[m ([33m[RET]:^CgύXȂ[m)');
          str(tabloc,temp);
          lenres:=sizeof(messtmp.subject);
          if cnarg[cn]^.sect.number>0 then temp:='[33mRes [#'+temp+']:[m'
          else begin
            str(reply+1,temp);
            temp:='[33mRes <'+temp+'>:[m';
          end;
          lineoutifneed;
          if cnarg[cn]^.inbuffer='' then lineout('[32m[m >'+temp+
            dellastkanji(copy(subject,1,lenres))+'[m');
          cnarg[cn]^.prompt := '[36m[m >'+temp;
          messtmp.subject:=getinputguide(cnarg[cn]^.prompt,lenres,echo);
          if messtmp.subject='' then messtmp.subject := subject;
          messtmp.section := section;
          if cnarg[cn]^.sect.number>0 then messtmp.reply:=number
          else begin
            messtmp.reply:=reply+1;
            tonum:=sender;
            messtmp.recver:=tonum;
          end;
        end;
        entry:=messtmp;
      end
      else begin
        lineout('');
        lineout('[31m̃{[hɏƂ͏o܂B[m');
        ok:=false;
      end;
    end
    else begin
      lineout('');
      lineout('[31mbZ[W܂B[m');
      ok := false;
    end;
  end;

begin {of newheader}
  if cts then begin
    ok := true;
    ent:=false;
    cnarg[cn]^.refwds:=0;
    case modes of
      email : begin   (* [ *)
          ent:=true;
        end;
      eboard : begin   (* {[h *)
          if cnarg[cn]^.sect.w > cnarg[cn]^.access then begin
            lineout('');
            lineout('[31m̃{[hɏ͏o܂B[m');
            ok := false;
            Exit;
          end;
        end;
      eres : begin   (* X|X *)
          if cnarg[cn]^.sect.w > cnarg[cn]^.access then begin
            lineout('');
            lineout('[31m̃{[hɏ͏o܂B[m');
            ok := false;
            Exit;
          end;
          if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
            lineout('');
            lineout('[31m̃{[hŃX|X͏o܂B[m');
            ok := false;
            Exit;
          end;
          e_res;
          if not ok then exit;            (* I *)
        end;
    end;
    if cnarg[cn]^.sect.number>0 then begin
      tonum:=0;
      entry.recver:=0;
      entry.section:=cnarg[cn]^.sect.number;
    end
    else begin
      entry.section:=0;
      if cnarg[cn]^.access>=reg then begin
        if modes=email then begin
          cnarg[cn]^.prompt:=
            '[36m̂hćH[m ([33m?:userlist  0:quit[m) >';
          lineoutifneed;
          tonum:=getid(cnarg[cn]^.prompt);
          if cnarg[cn]^.idrec.acc=twit then tonum:=0;
        end;
        entry.recver := tonum;
      end
      else begin
        tonum:=findid(sysopmail);  (* QXg̃[ *)
        entry.recver:=tonum;
      end;
    end;
    if (cnarg[cn]^.sect.number=0) and (tonum=0) then begin
      lineout('');
      lineout('[31mhc̎w肪Ⴂ܂B[m');
      ok:=false;
    end
    else if modes<>eres then begin
      cnarg[cn]^.prompt:='[36m[m >';
      lineoutifneed;
      entry.subject:=
        getinputguide(cnarg[cn]^.prompt,sizeof(entry.subject),echo);
      entry.reply:=0;
    end;
    clock(year, month, date, hour, min, sec);
    entry.date:=time(year, month, date, hour, min, sec);
    entry.sender:=cnarg[cn]^.usernum;
    entry.number:=cnarg[cn]^.nextmess; {ݷ÷ ¹}
    entry.recved:=false;
    entry.refwd:=0;
  end;
  lineout('');
end;

function storemess:boolean;
  (*90/10/18 bZ[Wi[@:͂C[WA[JCut@CɊi[*)
  var
    fst : word;
    i   : byte;
    j   : byte;
    k   : byte;
    buf : filbuffer;
  begin
    if cts then begin
      initarc;
      fst:=firstfreerec;
      if fst=0 then begin
        lineout('[31m̧ ̋󂫗eʂ܂B[m');
        storemess:=false;
        exit;
      end;
      cnarg[cn]^.arcrec:=fst;
      assignM(nametemp);
      resetM;
      stringout('.');
      j:=0;
      k:=0;
      while not eofM and (cnarg[cn]^.arcrec<>filesizeB(arcfil)) do begin
        buf:=clearblock;
        blockreadM(buf,1);
        writeA(cnarg[cn]^.arcrec,buf);
        inc(k);
        if (k=5) and (j<40) then begin
          stringout('.');
          inc(j);
          k:=0;
        end;
        for i:=0 to 19 do TransferNext;
        if not eofM then nextfreerec(cnarg[cn]^.arcrec);
      end;
      endmark(cnarg[cn]^.arcrec);
      if cnarg[cn]^.arcrec<>filesizeB(arcfil) then begin
        cnarg[cn]^.messdat.rec:=fst;     (* R[hԍm *)
        storemess:=true;
      end
      else begin
        killrec(fst);
        storemess:=false;
      end;
      closeM;
    end
    else storemess:=false;
  end;

procedure enter(modes:entermode;i,j:integer);
  var
    inch:char;
    temp:string[2];
    buf :messages;
    bkup:where;
    logs:boardlog;
  begin
    bkup:=cnarg[cn]^.CnStat;
    cnarg[cn]^.CnStat := zenter;
    if hoststat = 0 then dispstatus(cn);
    if cts then begin
      initmess;
      if cnarg[cn]^.messcount = maxmess then begin
        lineout('');
        lineout('[31m̃{[h̏ݎ󂯕t͏I܂B[m');
        exit;
      end
      else begin
        newheader(cnarg[cn]^.messdat,modes,i,j,ok);
        if not ok then exit;
      end;
      cnarg[cn]^.messdat.rec:=0;  (* R[hԍm *)
      headtail;
      lineoutifneed;
      cnarg[cn]^.prompt:=
        '[36mł낵łH[m  ([33m[Y][m/N) >';
      temp := getinput(cnarg[cn]^.prompt,2,echo);
      if (temp<>'N') and (temp<>'n') then begin
        compose(enone);
        repeat
          lineoutifneed;
          inch := getcap(
            '[36mWRITE EDIT[m ([33mW:write  E:edit  0:quit[m) >');
          case inch of
            'E': compose(eline);  (* ҏWpɃx^GfB^͎gȂ *)
            'W': begin
                 lineout('');
                 stringout('[32mݒ .');
                 if not getfile(nametemp) then begin
                   lineout('.. [31mGfBbgobt@܂B[m');
                   exit;
                 end;
                 stringout('.');
                 if storemess then begin
                   buf:=cnarg[cn]^.messdat;
                   initmess;
                   cnarg[cn]^.messdat:=buf;
                   inc(cnarg[cn]^.messcount);
                   cnarg[cn]^.messdat.number := cnarg[cn]^.nextmess;
                   while islockB(mesfil, cnarg[cn]^.messdat.number-1) do
                     transfernext;
                   lockB(mesfil, cnarg[cn]^.messdat.number-1);
                   clock(year, month, date, hour, min, sec);
                   cnarg[cn]^.messdat.date:=
                     time(year, month, date, hour, min, sec);
                   seekB(mesfil, cnarg[cn]^.messdat.number-1);
                   writeB(mesfil, @cnarg[cn]^.messdat);
                   stringout('.');
                   if cnarg[cn]^.sect.number>0 then begin
                     with logs do begin
                       user:=cnarg[cn]^.usernum;
                       if cnarg[cn]^.messdat.reply>0 then begin
                         str(cnarg[cn]^.messdat.reply,article);
                         article:='Res[#'+article+']:';
                       end
                       else article:='';
                       article:=article+cnarg[cn]^.messdat.subject;
                       article:=dellastkanji(article);
                       written:=true;
                       date:=cnarg[cn]^.messdat.date;
                       protocol:=none;  (* gp *)
                     end;
                     writebdlog(logs);
                   end;
                   if (cnarg[cn]^.refwds>0) and
                     (cnarg[cn]^.sect.number>0) then begin
                     (* Res *)
                     seekB(mesfil, cnarg[cn]^.refwds-1);
                     readB(mesfil, @buf);
                     buf.refwd:=cnarg[cn]^.messdat.number;
                     seekB(mesfil, cnarg[cn]^.refwds-1);
                     writeB(mesfil, @buf);
                   end;
                   unlockB(mesfil);
                   lineout(' [33mI܂B[m');
                 end
                 else lineout(' [31m݂Ɏs܂B[m');
            end;
            '0': begin
                 lineoutifneed;
                 if getyesno(
                   '[36m~Ă낵łH[m (Y/[33m[N][m) >')
                   <>'Y' then begin
                   lineout('');
                   lineout('[33ms܂B[m');
                   inch:=#$00;
                 end
                 else begin
                   lineout('');
                   lineout('[31m݂𒆎~܂B[m');
                 end;
            end;
          end;
        until (inch = '0') or (inch = 'W') or not cts;
      end;
    end;
    ent:=false;
    cnarg[cn]^.CnStat:=bkup;
    if hoststat = 0 then dispstatus(cn);
  end;

procedure headerlabel;
  begin
    lineout('');
    if cnarg[cn]^.sect.number=0 then
      lineout('[32mNo.  Sender            Recver            R Title[m')
    else lineout('[32mNo.  ID       Handle   Date     Time     Title[m');
    stringout('[33m---- -------- -------- -------- -------- ');
    if cnarg[cn]^.sect.number=0 then stringout('- ');
    lineout('------------------------------------[m');
  end;

procedure messagesearch(first:integer; fromnum, tonum:integer;sch:string);
  procedure editheader;
    var
      temp, wk,fromnum: integer;
    begin
      repeat
        lineoutifneed;
        cnarg[cn]^.prompt:=
          '[36mBOARD EDIT[m ([33m1:sender  2:subject  0:quit[m) >';
        temp := getint(2, 0, cnarg[cn]^.prompt);
        case temp of
          1 : begin
              fromnum:=getid('[36mM҂̂hćH[m ([33m?:userlist  0:quit[m) >');
              cnarg[cn]^.messdat.sender := fromnum;
          end;
          2 : begin
              lineoutifneed;
              cnarg[cn]^.prompt := '[36m[m >';
              cnarg[cn]^.messdat.subject:=getinputguide(cnarg[cn]^.prompt,
              sizeof(cnarg[cn]^.messdat.subject), echo);
          end;
        end;
        if temp <> 0 then begin
          lineout('');
          headtail;
        end;
      until (temp = 0) or not cts;
    end;

  const direction:array[-1..1] of string[13]=(
                 '[31mBackward','','[32mForward');
  var
    lp      : integer;
    inch    : char;
    dumy    : integer;
    dmy     : integer;
    nums    : word;
    instr   : string;
    instr1  : string[1];
    oldnum  : integer;
    matched : boolean;
    temp    : string8;
    dir     : integer;
    mcount  : integer;
    bkup    : where;
  begin {of messagesearch}
    initmess;
    mcount := cnarg[cn]^.messcount;
    cnarg[cn]^.cancelled := false;
    dir := 1;
    matched := false;
    inch := null;
    lp := first;
    while cts and (lp>0) and (lp <= mcount) and (inch <> '0')
      and (mcount <> 0) do begin
      seekB(mesfil, lp-1);
      readB(mesfil, @cnarg[cn]^.messdat);
      oldnum := cnarg[cn]^.messdat.number;
      with cnarg[cn]^.messdat do begin
        if ismess(fromnum,tonum,sch) then begin
          if not matched and (cnarg[cn]^.expert=ebegin) and
            not cnarg[cn]^.readext and not cnarg[cn]^.readext then begin
            lineout('');
            outfile(bmesdrive+j_directive);
          end;
          dir := 1;
          matched := true;
          lineout('');
          str(number:4,instr);
          if cnarg[cn]^.sect.number=0 then stringout('[35mMail stacks')
          else if sch='' then stringout('[36mRead subjects')
          else stringout('[32mSearch subjects');
          stringout('[m:[36m'+instr+'[m/[36m');
          str(mcount:4,instr);
          stringout(instr+'[m ([33mRemains[m:[32m');
          if cnarg[cn]^.readstep=1 then str((mcount-number):4,instr)
          else str((number-1):4,instr);
          lineout(instr+'[m)    ['+direction[cnarg[cn]^.readstep]+
            ' [33mmode[m]');
          headtail;
    inch:='N';
    repeat
      if inch in ['L','F','A','D','N','0'..'9','P','K'] then begin
        lineout('');
        readfile(lp);
      end;
      if cnarg[cn]^.cancelled then begin
        cnarg[cn]^.inbuffer:='';
        cnarg[cn]^.readext:=false;
        cnarg[cn]^.cancelled:=false;
      end;
      cnarg[cn]^.prompt:='[36m[RET][m:[32mnext [36mL[m:[32moop'+
        ' [36mP[m:[32mrev'+
        ' [36mA[m:[32ms [36mD[m:[32mes [36mR[m:[32mes'+
        ' [36m+[m,[36m-[m,[36mnn[m:[32msel'+
        ' [36m? [36m0[m:[32mquit[m >';
      instr :='N';
      if not cnarg[cn]^.readext then begin
        lineoutifneed;
        instr := allcaps(getinput(cnarg[cn]^.prompt,10,echo));
      end;
      inch:=instr[1];
      val(instr,nums,dmy);
      if (dmy=0) and (nums<>0) and not (inch in ['+','-']) then
        lp:=nums-cnarg[cn]^.readstep
      else case inch of
        'F' : begin
            cnarg[cn]^.readext :=true;
            lineout('');
            lineout(
              '  [33m Aœǂ݂܂ [m  if:[35m^[mCj');
        end;
        '+' : if length(instr)=1 then begin
              cnarg[cn]^.readstep := 1;
              lineout('  [33m tɓǂ݂܂ [m');
            end
            else begin
              val(copy(instr,2,255),nums,dmy);
              lp:=lp+nums-cnarg[cn]^.readstep;
              inch:='N';
        end;
        '-' : if length(instr)=1 then begin
              cnarg[cn]^.readstep := -1;
              lineout('  [33m ̂ڂēǂ݂܂ [m');
            end
            else begin
              val(copy(instr,2,255),nums,dmy);
              lp:=lp-nums-cnarg[cn]^.readstep;
              inch:='N';
        end;
        'L' : begin  (* JԂǂ *)
            headerlabel;
            headtailm;
            stringout('[33m-----------------------------------------------------------------------------');
            if cnarg[cn]^.sect.number=0 then lineout('--[m') else lineout('[m');
          end;
        'G' : begin  (* GfB^obt@Ɏ荞 *)
              lineout('');
              stringout('[32m͂荞ݒ ...');
              getdata(cnarg[cn]^.messdat.rec,nametemp);
              if setfile(nametemp) then
                lineout(' [33m荞݂܂B[m')
              else lineout(' [31m荞݂Ɏs܂B[m');
          end;
        'S' : begin
              lineout('');
              if cnarg[cn]^.access<reg then
                lineout('[31mQXg͎gpo܂B[m')
              else begin
                if sender=0 then
                  lineout('[32m҂̓QXgłB[m')
                else begin
                  lineout('[33m---------------------------------------------------------------- [32mSender profile[m');
                  seekB(idfil,sender-1);
                  readB(idfil,@cnarg[cn]^.idrec);
                  showprof(cnarg[cn]^.idrec,false);
                  lineout('[33m-------------------------------------------------------------------------------[m');
                end;
                inch:='+';
              end;
          end;
        '?' : begin
              lineout('');
              outfile(bmesdrive+j_directive);
          end;
        'D' : if cnarg[cn]^.sect.number=0 then begin
              lineout('');
              lineout('[31m[ɂ͎gpo܂B[m');
              inch:='+';
            end
            else if reply>0 then
              lp:=reply-cnarg[cn]^.readstep (* ̃bZ[Wǂ *)
            else begin
              lineout('');
              lineout('[31m̃bZ[Wn܂łB[m');
              inch:='+'; (* bZ[WēǂȂ悤I}WiC *)
        end;
        'A' : if cnarg[cn]^.sect.number=0 then begin
              lineout('');
              lineout('[31m[ɂ͎gpo܂B[m');
              inch:='+';
            end
            else if refwd>0 then
              lp:=refwd-cnarg[cn]^.readstep (* X|Xǂ *)
            else begin
              lineout('');
              lineout('[31m̃bZ[WɃX|X͂܂B[m');
              inch:='+'; (* bZ[WēǂȂ悤I}WiC *)
        end;
        'R'   : begin
                if (sender=0) and (cnarg[cn]^.sect.number=0) then begin
                  lineout('');
                  lineout('[31mQXgɃ[͏o܂B[m');
                end
                else if cnarg[cn]^.sect.w>cnarg[cn]^.access then begin
                  lineout('');
                  lineout('[31mgpo܂B[m');
                end
                else begin
                  str(number, temp);
                  cnarg[cn]^.inbuffer:= temp;
                  bkup:=cnarg[cn]^.CnStat;
                  enter(eres,fromnum,tonum);
                  initmess;
                  mcount := cnarg[cn]^.messcount;
                  seekB(mesfil, lp-1);
                  readB(mesfil, @cnarg[cn]^.messdat);
                  cnarg[cn]^.CnStat := bkup;
                  if hoststat = 0 then dispstatus(cn);
                  inch := '+';
                end;
              end;
        'E'   : if issigop then begin
                editheader;
                if islockB(mesfil, lp-1) then begin
                  lineout('');
                  lineout(
                    '[31m`lŕҏŴߕҏWo܂B[m');
                end;
                lockB(mesfil, lp-1);
                seekB(mesfil, lp-1);
                writeB(mesfil, @cnarg[cn]^.messdat);
                unlockB(mesfil);
                inch:='+';
              end;
        end;
      until inch in ['0'..'9','N','F','P','K','A','D'];
      case inch of
        'P'   : dir := -1;
        'K'   : begin
              if (cnarg[cn]^.usernum=cnarg[cn]^.messdat.sender) or
                issigop or (cnarg[cn]^.sect.number=0) then begin
                lineout('');
                cnarg[cn]^.prompt:=
                  '[36m폜Ă낵łH[m (Y/[33m[N][m) >';
                if GetYesNo(cnarg[cn]^.prompt) = 'Y' then destroy(lp);
              end
              else begin
                lineout('');
                lineout('[31m̃bZ[W͍폜ł܂B[m');
              end;
          end;
        end; {case}
      end; {if}
    end; {with}
    if cnarg[cn]^.messdat.number = oldnum then begin
      lp := lp + cnarg[cn]^.readstep * dir;
    end;
    if (lp mod interval)=0 then TransferNext;
  end; {while}
  lineout('');
  if not matched then begin
    if cnarg[cn]^.sect.number>0 then
      lineout('[32mw̃bZ[W͂܂B[m')
    else lineout('[32mw̃[͂܂B[m');
  end
  else if inch<>'0' then
    lineout('[36mDIRECTIVE[m :[33mbZ[W͈ȏłB[m')
  else lineout('[36mDIRECTIVE[m :[33mI܂B[m');
  clearB;
  end;


function getmessnum(nmax:integer;gprompt:string): integer;
var
  temp, test : integer;
  outstr, userin : string;
begin
  str(nmax:4, outstr);
  repeat
    temp:=0;
    userin:=getinput(gprompt, 5, echo);
    val(userin,temp,test);
    if (test=0) and (abs(temp)>nmax) then lineout(
       '[33ml傫܂Bō [32m'+outstr+' [33mł[m');
    if userin='?' then status2;
  until ((temp<=nmax) and (temp>0))
    or (userin='-') or (userin='') or not cts;
  if (userin='') or (userin='-') or not cts then getmessnum:=9999
  else getmessnum:=temp;
end;


function getfirst: integer;
  var
    startmess : integer;
  begin
    lineoutifneed;
    cnarg[cn]^.prompt:=
      '[36mn߂̔ԍ́H[m ([33m?:status  [RET]:from top[m) >';
    startmess := getmessnum(9999, cnarg[cn]^.prompt);
    getfirst:=findspeed(startmess)
  end;


procedure readfrom;
  var
    fromnum : integer;
    first   : integer;
  begin
    if cts then begin
      cnarg[cn]^.prompt:='[36mM҂̂hćH[m ([33m?:userlist  0:quit[m) >';
      fromnum:=getid(cnarg[cn]^.prompt);
      if fromnum<1 then begin
        lineout('');
        lineout('[31mhc܂B[m')
      end
      else begin
        first:=getfirst;                         (* sorry *)
        if first>0 then messagesearch(first,fromnum,-2,'');
      end;
    end;
  end;


procedure quickscan(i,j:integer);
  var
    loop     : integer;
    mesexist : boolean;
  begin
    mesexist:=false;
    if cts then begin
      loop:=getfirst;
      headerlabel;
      while (loop>=1) and (not cnarg[cn]^.cancelled) and cts do begin
        seekB(mesfil, loop-1);
        readB(mesfil, @cnarg[cn]^.messdat);
        with cnarg[cn]^.messdat do
          if ismess(i,j,'') then begin
            headtailm;
            mesexist := true;
          end;
        dec(loop);
      end;
      if not mesexist then lineout('[33mbZ[W͂܂.[m');
    end;
    if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
  end;


procedure rcv(prmpt:string;sdr,rcvr:integer);
  const
    nulluser: string8='';
  var
    uchar   : char;
    dumy    : string;
    temp,as : integer;
    datefrom: Datetime;
    mess    : integer;
  begin
    openboard(cnarg[cn]^.sect.number);
    initmess;
    cnarg[cn]^.readext:=false;
    if (cnarg[cn]^.expert=ebegin) and (cnarg[cn]^.inbuffer='') then begin
      lineout('');
      outfile(bmesdrive+j_readmenu);
    end;
    repeat
      clearB;
      lineoutIfNeed;
      cnarg[cn]^.readstep:=1;
      str((10000+cnarg[cn]^.sect.number):5,dumy);
      cnarg[cn]^.prompt := '[36m'+prmpt+'[m ';
      if cnarg[cn]^.sect.number>0 then begin
        cnarg[cn]^.prompt:=cnarg[cn]^.prompt+'[[32m#'+
        copy(dumy,3,3)+'[m/[32m'+
        copy(cnarg[cn]^.sect.bname+'        ',1,8)+'[m] ([33mI,';
      end
      else cnarg[cn]^.prompt:=cnarg[cn]^.prompt+'([33m';
      cnarg[cn]^.prompt:=cnarg[cn]^.prompt+'N,T,R,K,F,L,E,H,nn,?,0[m) >';
      dumy:='';
      uchar:=#$00;
      dumy := allcaps(getinput(cnarg[cn]^.prompt,80,echo));
      if (uchar in ['A','D']) then lineoutIfNeed;
      val(dumy,temp,as);
      if (temp>0) and (as=0) then begin
        if (cnarg[cn]^.access<reg) and
          (cnarg[cn]^.sect.number=0) then begin
          lineout('');
          lineout('[31mQXg͎gpo܂B[m');
        end
        else if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
          lineout('');
          lineout('[31m̃{[hł͓ǂނƂo܂B[m');
        end
        else messagesearch(findspeed(temp),sdr,rcvr,'')
      end
      else begin
        if length(dumy)=0 then uchar:=#$00
        else uchar:=dumy[1];
        if (uchar in ['I','N','T','R','K','F','L','E','H','$','?']) then
          case uchar of
              'I': if cnarg[cn]^.sect.number>0 then begin
                   lineout('');
                   outinfo;
                   end;
              'N': if (cnarg[cn]^.usernum=0) and
                     (cnarg[cn]^.sect.number=0) then begin
                     lineout('');
                     lineout('[31mQXg͎gpo܂B[m');
                   end
                   else if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                     lineout('');
                     lineout('[31m̃{[hł͌o܂B[m');
                   end
                   else begin
                     lineoutifneed;
                     datefrom:=getdays(prmpt+' NEWS');
                     lineout('');
                     if datefrom<>'' then
                       if cnarg[cn]^.sect.number=0 then begin
                         mess:=findnewmess(-1,rcvr,datefrom);
                         if mess>0 then messagesearch(mess,-1,rcvr,'')
                         else lineout(
                           '[31mbZ[W܂B[m');
                       end
                       else begin
                         mess:=findnewmess(sdr,rcvr,datefrom);
                         if mess>0 then messagesearch(mess,sdr,rcvr,'')
                         else lineout(
                           '[31mbZ[W܂B[m');
                       end;
                   end;
              'T': if (cnarg[cn]^.usernum=0) and
                     (cnarg[cn]^.sect.number=0) then begin
                     lineout('');
                     lineout('[31mQXg͎gpo܂B[m');
                   end
                   else if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                     lineout('');
                     lineout('[31m̃{[hł͓ǂނƂo܂B[m');
                   end
                   else begin
                     lineoutifneed;
                     cnarg[cn]^.readstep:=-1;
                     messagesearch(findspeed(9999),sdr,rcvr,'');
                   end;
              'F': if cnarg[cn]^.usernum=0 then begin
                     lineout('');
                     lineout('[31mQXg͎gpo܂B[m');
                   end
                   else if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                     lineout('');
                     lineout('[31m̃{[hł͓ǂނƂo܂B[m');
                   end
                   else if cnarg[cn]^.sect.number=0 then begin
                     lineout('');
                     lineout('[31mgpo܂B[m');
                   end
                   else readfrom;
              'L': if (cnarg[cn]^.usernum=0) and
                     (cnarg[cn]^.sect.number=0) then begin
                     lineout('');
                     lineout('[31mQXg͎gpo܂B[m');
                   end
                   else if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                     lineout('');
                     lineout('[31m̃{[hł̓Xg\o܂B[m');
                   end
                   else quickscan(sdr,rcvr);
              'E': if cnarg[cn]^.sect.w>cnarg[cn]^.access then begin
                     lineout('');
                     lineout('[31mgpo܂B[m');
                   end
                   else begin
                     if cnarg[cn]^.sect.number>0 then enter(eboard,sdr,rcvr)
                     else enter(email,sdr,rcvr);
                     initmess;
                   end;
              'R': if (cnarg[cn]^.sect.w>cnarg[cn]^.access) or
                     ((cnarg[cn]^.usernum=0) and (cnarg[cn]^.sect.number=0))
                     then begin
                     lineout('');
                     lineout('[31mgpo܂B[m');
                   end
                   else if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                     lineout('');
                     lineout('[31m̃{[hŃX|X͏o܂B[m');
                   end
                   else begin
                     enter(eres,sdr,rcvr);
                     initmess;
                   end;
              'K': if (cnarg[cn]^.usernum=0) and
                     (cnarg[cn]^.sect.number=0) then begin
                     lineout('');
                     lineout('[31mQXg͎gpo܂B[m');
                   end
                   else if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                     lineout('');
                     lineout('[31m̃{[hł͍폜͏o܂B[m');
                   end
                   else begin
                     deletex(sdr,rcvr);
                   end;
              '$': if cnarg[cn]^.sect.number>0 then begin
                     custboard;
                     if cnarg[cn]^.sect.attrib=amenu then exit;
                   end;
              'H': begin
                     lineout('');
                     outfile(bmesdrive+j_readhelp);
                   end;
              '?': begin
                     lineout('');
                     outfile(bmesdrive+j_readmenu);
                   end;
          end;
      end;
    until (uchar='0') or not cts;
    closeBoard;
  end;

procedure receive;
  var temp:string;
  begin
    seekB(mbdfil,1);
    readB(mbdfil,@cnarg[cn]^.sect);
{   if (cnarg[cn]^.sect.r<=cnarg[cn]^.access) or
      (cnarg[cn]^.sect.w<=cnarg[cn]^.access) then begin }
    if testin(cnarg[cn]^.sect,false) then begin
      repeat
        cnarg[cn]^.CnStat := zboard;
        if hoststat = 0 then dispstatus(cn);
        getsect;
        if cnarg[cn]^.sect.attrib=aboard then begin
          rcv('BOARD',-1,-1);
          seekB(mbdfil,cnarg[cn]^.sect.back);
          readB(mbdfil,@cnarg[cn]^.sect);
        end;
      until (cnarg[cn]^.sect.attrib=anone) or
        (cnarg[cn]^.sect.number=0) or not cts;
    end
    else begin
      lineout('');
      lineout('[31mbZ[W{[h͗po܂B[m');
    end;
  end;


procedure search(choice:searches);
  (* ݂牺үްނ̌s *)
  (* Thanks bug fix:MOTO             *)
  const
    sccnstat:array[searches] of where=(znews,zsearch);
    sccnstr:array[searches] of string[12]=('NEWS','SEARCH');
  var
    buf  : secttype;
    num  : array[1..16] of byte;  (* 16Kw *)
    loop : byte;
    i    : byte;
    ch   : char;
    lsto : string[60];
    mess : integer;
    count: integer;
    temp : string[4];
  begin
    cnarg[cn]^.CnStat:=sccnstat[choice];
    if hoststat = 0 then dispstatus(cn);
    cnarg[cn]^.cancelled:=false;
    cnarg[cn]^.readext:=false;
    lineoutifneed;
    ch:=getyesno('[36mBOARD '+sccnstr[choice]+
      '[m :[36mAœǂ݂܂H[m (Y/[33m[N][m) >');
    if ch='Y' then cnarg[cn]^.readext:=true;
    case choice of
      snews:begin
            lineoutifneed;
            lsto:=getdays(sccnstr[choice]);
      end;
      ssearch:begin
            lineoutifneed;
            lineout('[36m'+sccnstr[choice]+'[m :[36m^Cg͂ĉB[m ([33m[RET]:quit[m)');
            lsto:=getinputguide('[36m[m >',60,echo);
      end;
    end;
    if lsto='' then begin
      cnarg[cn]^.CnStat := zboard;
      if hoststat = 0 then dispstatus(cn);
      exit;
    end;
    if ch='Y' then lineout(cr+lnfd+
      '  [33m Aœǂ݂܂ [m  if:[35m^[mCj');
    lineout('');
    buf:=cnarg[cn]^.sect;
    for i:=1 to 16 do num[i]:=0;
    loop:=1;
    repeat
      case cnarg[cn]^.sect.attrib of
        amenu:begin
                if (num[loop]<10) and (cnarg[cn]^.sect.downb[num[loop]]>0) and
                  testin(cnarg[cn]^.sect,false) then begin(* wްޗL *)
                  seekB(mbdfil,cnarg[cn]^.sect.downb[num[loop]]);
                  readB(mbdfil,@cnarg[cn]^.sect);        (* wްގ擾 *)
                  inc(num[loop]);
                  inc(loop);
                end
                else begin
                  inc(num[loop]);
                  if num[loop]>=10 then begin      (* wްނ͖̌ *)
                    num[loop]:=0;
                    dec(loop);
                    seekB(mbdfil,cnarg[cn]^.sect.back);
                    readB(mbdfil,@cnarg[cn]^.sect);       (* ްނ̎擾 *)
                  end;
                end;
              end;
        aboard:begin (* ݂ްޑް޽ðȂΌs *)
              if testin(cnarg[cn]^.sect,false) and
                (cnarg[cn]^.sect.r<=cnarg[cn]^.access) then begin
                stringout(sectwithnum(cnarg[cn]^.sect));
                stringout(' ');
                for i := length(cnarg[cn]^.sect.nam) to 37-6 do
                  stringout('');
                stringout(' ');
                openboard(cnarg[cn]^.sect.number);
                initmess;
                cnarg[cn]^.readstep := 1;
                case choice of
                  snews:begin
                        mess:=findnewmess(-1,-1,lsto);
                        if mess>0 then begin
                          stringout('[32m ...[m');
                          count:=countarticle(-1,-1,mess);
                          if count>0 then begin
                            lineout('');
                            lineout('');
                          end
                          else begin   (* ꂵidj*)
                            for i:=1 to 10 do stringout(bs);
                          end;
                        end
                        else count:=0;
                  end;
                  ssearch:begin
                        count:=titlesearch(lsto);
                        if count>0 then begin
                          lineout('[32m ...[m');
                          lineout('');
                        end;
                  end;
                end;
                if cnarg[cn]^.cancelled then begin
                  closeboard;
                  cnarg[cn]^.cancelled:=false;
                  cnarg[cn]^.cnstat:=zboard;
                  cnarg[cn]^.sect:=buf;
                  if hoststat = 0 then dispstatus(cn);
                  exit;
                end;
                if count>0 then begin
                  str(count, temp);
                  case choice of
                    snews:stringout('[33mV үނ');
                    ssearch:stringout('[33mv үނ');
                  end;
                  lineout(' [32m'+temp+' [33m܂[m');
                  lineout('');
                  cnarg[cn]^.prompt:='[36mBOARD '+sccnstr[choice]+
                    '[m ([33m[RET]:readboard  S:skipboard  0:quit[m) >';
                  if cnarg[cn]^.readext then ch:=#$00
                  else ch := getcap(cnarg[cn]^.prompt);
                  if ch = '0' then begin
                    closeBoard;
                    lineout('');
                    cnarg[cn]^.sect:=buf;
                    cnarg[cn]^.CnStat := zboard;  (* by MOTO *)
                    if hoststat = 0 then dispstatus(cn);
                    exit;
                  end
                  else if (ch <> 'S') and cts then begin
                    case choice of
                      snews:messagesearch(mess,-1,-1,'');
                      ssearch:messagesearch(findspeed(1),-1,-1,lsto);
                    end;
                    lineout('');
                    stringout(sectwithnum(cnarg[cn]^.sect));
                    stringout(' ');
                    for i := length(cnarg[cn]^.sect.nam) to 37-6 do
                      stringout('');
                    stringout(' ');
                    lineout('[32mI[m');
                    repeat
                      if not cnarg[cn]^.readext then lineout('');
                      cnarg[cn]^.prompt:='[36mBOARD '+sccnstr[choice]+
                        '[m ([33m[RET]:nextboard  E:enter  0:quit[m) >';
                      ch:=#$00;
                      if not cnarg[cn]^.readext then
                        ch:=getcap(cnarg[cn]^.prompt);
                      if ch='E' then begin
                        enter(eboard,-1,-1);
                        initmess;
                      end;
                      if (not cts) or (ch='0') then begin
                        closeboard;
                        cnarg[cn]^.sect:=buf;
                        cnarg[cn]^.CnStat := zboard;  (* by MOTO *)
                        if hoststat = 0 then dispstatus(cn);
                        exit;
                      end;
                    until (ch<>'E') or not cts;
                    lineout('');
                  end
                  else lineout('');
                end
                else begin
                  case choice of
                    snews:lineout('[33mV үނ͂܂[m');
                    ssearch:lineout('[33mv үނ͂܂[m');
                  end;
                end;
                closeboard;
              end;
              seekB(mbdfil,cnarg[cn]^.sect.back);
              readB(mbdfil,@cnarg[cn]^.sect);     (* ްƭɖ߂ *)
              dec(loop);
              end;
      end;
    until (loop=0) or cnarg[cn]^.cancelled or not cts;
    if cnarg[cn]^.cancelled then begin
      cnarg[cn]^.cancelled:=false;
      lineout('');
      lineout('[36mBOARD '+sccnstr[choice]+
        '[m :[31m𒆒f܂B[m');
    end
    else begin
      lineout('');
      lineout('[36mBOARD '+sccnstr[choice]+
        '[m :[33mI܂B[m');
    end;
    cnarg[cn]^.sect:=buf;
    lineout('');
    cnarg[cn]^.CnStat := zboard;
    if hoststat = 0 then dispstatus(cn);
  end;


procedure readmail;
  begin
    cnarg[cn]^.CnStat:=zmail;
    if hoststat = 0 then dispstatus(cn);
    mailpilot;
    seekB(mbdfil,0);
    readB(mbdfil,@cnarg[cn]^.sect);
    rcv('MAIL',cnarg[cn]^.usernum,cnarg[cn]^.usernum);
  end;


procedure mailpilot;
  var
    loop,count:integer;
    temp      :string;
    brk       :char;
    ldate     :longint;
  begin
    if cts and (cnarg[cn]^.access>=reg) then begin
    seekB(mbdfil,0);
    readB(mbdfil,@cnarg[cn]^.sect);
    openBoard(0);
    loop:=findnewmess(-1,cnarg[cn]^.usernum,cnarg[cn]^.lastmail);
    lineout('');
    if loop>0 then begin
      count:=countarticle(-1,cnarg[cn]^.usernum,loop);
      if count>0 then begin
        str(count,temp);
        lineout('[36mV͂[ [32m'+temp+
          '[36m ʂ܂B[m');
      end
      else lineout('[35mV͂[͂܂B[m');
    end
    else lineout('[35mV͂[͂܂B[m');
    closeBoard;
    end;
  end;


end.

