{
  ---- coroutine, catch/throw, proced PSP manager. -----
  cautions.
  1. procedures called by callproc/callfunc must be FAR.
  2. Iflag is set after transfer, longjmp.
  ------------------------------------------------------
}

unit JmpCall;

{---------------------------------------------------------------------}
interface

uses Dos;

type
  process = pointer;         (* ss:sp *)
  jmpvec  = record
            bpsave: word;    (* save bp *)
            spsave: pointer; (* save ss,sp*)
            pcsave: pointer; (* save cs,ip*)
  end;

var BottomSize : word;   (* paragraph *)

procedure NewProcess(proced:pointer; var stack; stacksize:word;
           var proc:process);

procedure Transfer(var proc1: process; proc2:process);
function  SetJmp(var p:jmpvec): Boolean;
procedure LongJmp(var p:jmpvec);
procedure CallProc(proced:pointer);
function  CallComp(func:pointer; var x,y):integer;

{---------------------------------------------------------------------}

implementation

{$L jmpcall.obj}

procedure Transfer; external;
procedure LongJmp;  external;
function  SetJmp;   external;
procedure CallProc; external;
function  CallComp; external;

type
     pRec   = record
       offset, segment : word
     end ;

procedure NewProcess;
  type  pArray = record
            bp : word;
            pp : array[0..2] of pointer;
        end ;

        pArrayPtr = ^pArray;

  begin
    pRec(proc).segment := Seg(stack) - BottomSize + (Ofs(stack)+15)shr 4;
    pRec(proc).offset  := ( BottomSize shl 4
                          + stacksize
                          - (16 - Ofs(stack)) and 15
                          - SizeOf(pArray))
                          and $fffe ;
    with pArrayPtr(proc)^ do begin
      bp    := pRec(proc).offset;
      pp[0] := proced;
      (* CAUTION.  pp[1..2] is dummy for Transfer (ret 0008) *)
    end
  end {of NewProcess};

begin
  BottomSize := $20;  (* 512 bytes *)
end.

