{
  "FILESYS.PAS"  ( UNIT : FILESYS )  t@C{[hVXe
}

unit filesys;

{----------------------------------------------------------------------}
interface

Uses
   Dos, JmpCall, rsdriver, timer,
   header, kernel, filmangr, transsys, monitor, io, editsys, boardsys;

procedure fileboard;

{----------------------------------------------------------------------}
implementation

const
  mostfiles  = 1000;  (*P`XXX܂œo^\*)
  deletedfile= '!';
  ksize      = 1;     (*minimum increment of file size in Kbytes*)

var
  i, j : integer;

function stri(x:byte):string;
  var
    temp:string;
  begin
    str(x,temp);
    stri:=temp;
  end;

function fnspace(s:string):string;
  { insert any spaces and complete 12 letters. '????????.???' }
  var
    D2 : DirStr;
    N2 : NameStr;
    E2 : ExtStr;
  begin
    Fsplit(s,D2,N2,E2);
    fnspace:=D2+copy(N2+'        ',1,8)+copy(E2+'    ',1,4);
  end;

procedure initfile;
  var
    loopvar: integer;
    fldt   : filerec;
  begin {$I-}
    loopvar:=0;
    cnarg[cn]^.enddir:=filesizeB(filfil);
    if cnarg[cn]^.enddir > 0 then begin
      inc(cnarg[cn]^.enddir);
      repeat
        dec(cnarg[cn]^.enddir);
        seekB(filfil, cnarg[cn]^.enddir-1);
        readB(filfil, @fldt);
      until (fldt.title<>deletedfile) or (cnarg[cn]^.enddir=1);
      if fldt.title=deletedfile then cnarg[cn]^.enddir:=0;
    end;
  end; {$I+}

procedure nonecwarning;
  begin
    if (cnarg[cn]^.MNPflg=0) and
      not cnarg[cn]^.NulModem and (cn>0) then begin
      lineout('');
      lineout('[33mӁFG[t[ڑĂ܂B[m');
      lineout('      [31mf[^G[[33mN\܂B[m');
    end;
  end;

procedure lfile(no:integer;fldat:filerec);
  var
    howbig,sectmin:longint;
    temp,temp2:string;
  begin
    sectmin := ksize shl 3;
    with fldat do
      if cts and (public or (submit=cnarg[cn]^.usernum) or issigop)
        and (title<>deletedfile) then begin
        howbig := (size + sectmin - 1) div sectmin;
        str(howbig:4, temp);
        str(no:4, temp2);
        stringout(temp2);
        if ASCII then stringout(' [32mA[m ')
        else stringout(' [32mB[m ');
        stringout('[36m'+fnspace(title)+' [33m'+temp+'KB');
        str(accesses:3, temp);
        stringout(' [33m'+temp+'[m ');
        lineout(dellastkanji(copy(comment,1,48)));
      end;
  end;


procedure flt;
  begin
    lineout('[32mNo.  S Filename     Bytes  cnt Comment[m');
    lineout('[33m---- - ------------ ------ --- ------------------------------------------------[m');
  end;


  function wildcard(s1,s2:string):boolean;
    (* s1 ChJ[h *)
    var
      loop :byte;
      d    :dirstr;
      n1   :namestr;
      n2   :namestr;
      e1   :extstr;
      e2   :extstr;
      oks  :boolean;
    begin
      loop:=1;
      oks:=true;
      fsplit(s1,d,n1,e1);
      fsplit(s2,d,n2,e2);
      if length(n1)>length(n2) then
        n2:=copy(n2+'               ',1,length(n1));
      while (length(n2)>=loop) and oks and (n1[loop]<>'*') do begin
        if (n1[loop]<>'?') and (n1[loop]<>n2[loop]) then oks:=false;
        inc(loop)
      end;
      loop:=1;
      if length(e1)>length(e2) then
        e2:=copy(e2+'               ',1,length(e1));
      while (length(e2)>=loop) and oks and (e1[loop]<>'*') do begin
        if (e1[loop]<>'?') and (e1[loop]<>e2[loop]) then oks:=false;
        inc(loop)
      end;
      wildcard:=oks;
    end;

{ ------------------- }

  var
    comch     : string;
    prtcl     : integer;
    boad      : integer;
    wtr       : array[0..99] of word;
    temp      : string;
    innum     : integer;
    dumy      : integer;

  function dirpos(filename: string): integer;
    var
      loopvar: integer;
      tempbuf: filerec;
    begin
      dirpos:= 0;
      loopvar:= 0;
      if cnarg[cn]^.enddir > 0 then begin
        repeat
          inc(loopvar);
          seekB(filfil,loopvar-1);
          readB(filfil,@tempbuf);
        until (tempbuf.title=filename) or (loopvar>=cnarg[cn]^.enddir);
        if tempbuf.title=filename then dirpos:=loopvar;
      end;
    end;

  procedure addfile(filename: string;textch:protocoltype);
    var
      d:dirstr;
      n:namestr;
      e:extstr;
      logs:boardlog;
      day:word;
    begin
      initfile;
      with cnarg[cn]^.filedat do begin
        fsplit(filename,d,n,e);
        title := n+e;
        assignM(filename);
        resetM;
        size := filesizeM;
        closeM;
        ASCII := (textch=texts);
        section := 0; {dumy}
        public := true;
      end;
      seekB(filfil, cnarg[cn]^.enddir);
      writeB(filfil, @cnarg[cn]^.filedat);
      with logs do begin
        user:=cnarg[cn]^.filedat.submit;
        article:=fnspace(n+e);
        written:=true;
        date:=getclock;
        protocol:=textch;
      end;
      writebdlog(logs);
      initfile;
    end;

  procedure copyfile;
    const
      cnvtxt:array[boolean] of protocoltype=(none,texts);
    var
      temp:string;
      rslt:byte;
      i   :byte;
      fn  :string;
      D2  :dirstr;
      N2  :namestr;
      E2  :extstr;
    begin
      lineout('');
      i:=1;
      rslt:=0;
      while (cnarg[cn]^.dlnum>=i) and (rslt=0) do begin
        Fsplit(cnarg[cn]^.dllist[i].fnam,D2,N2,E2);
        if dirpos(N2+E2)=0 then begin
          stringout('[33mRs[ [32m['+N2+E2+'] ...');
          temp:=filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+N2+E2;
          FileCopy(cnarg[cn]^.dllist[i].fnam,temp,rslt);
          if rslt = 0 then begin
            with cnarg[cn]^.filedat do begin
              comment := cnarg[cn]^.dllist[i].comment;
              submit := cnarg[cn]^.dllist[i].submit;
              date := cnarg[cn]^.dllist[i].time;
              accesses := cnarg[cn]^.dllist[i].accesses;
              addfile(temp,cnvtxt[cnarg[cn]^.dllist[i].ASCII]);
              cnarg[cn]^.dllist[i].rslt := true;
              lineout(' [33mI[m');
            end;
          end
          else lineout(' [31ms[m');
        end
        else lineout(' [31m@̃t@C݂[m');
        inc(i);
      end;
    end;
{$I+}

  procedure TEXTupload(filnam: string; var successful: boolean);
  var
    inch:char;
    rslt:byte;
  begin
    if cts then begin
      compose(enone);
      repeat
        lineout('');
        inch:=getcap(
          '[36mUPLOAD EDIT[m ([33mW:write  E:edit  0:quit[m) >');
        case inch of
          'E': compose(eline);  (* ҏWpɃx^GfB^͎gȂ *)
          'W': begin
             if cts then begin
               lineout('');
               stringout('[32mݒ ...');
               if not getfile(nametemp) then begin
                 lineout(' [31mGfBbgobt@܂B[m');
                 exit;
               end;
               FileCopy(nametemp, filnam, rslt);
               if rslt = 0 then begin
                 successful := true;
                 lineout(' [33mI܂B[m');
               end
               else begin
                 successful := false;
               end;
               lineout('');
             end;
            end;
          '0': begin
                 lineout('');
                 if getyesno(
                   '[36m~Ă낵łH[m (Y/[33m[N][m) >')
                     <>'Y' then begin
                   lineout('');
                   lineout('[33ms܂B[m');
                   inch:=#$00;
                 end
                 else begin
                   successful := false;
                   lineout('');
                   lineout('[31m݂𒆎~܂B[m');
                 end;
          end;
        end;
      until (inch = '0') or (inch = 'W') or not cts;
    end;
  end;


  function alpha(filename: string): boolean;
    var
      strpos: byte;
      dots  : byte;
    begin
      dots:=0;
      alpha:=true;
      if length(filename) > 0 then
        for strpos:=1 to length(filename) do begin
          if filename[strpos]='.' then inc(dots);
          if not (filename[strpos] in
            ['.','-','_','*','?','0'..'9','A'..'Z'])
            then alpha:=false;
        end;
      if dots>1 then alpha:=false;
    end;


  function getlegal(s:string):string;
    var
      filename:string;
    begin
      repeat
        lineoutIfNeed;
        cnarg[cn]^.prompt:='[36m'+s+'[m :[36mt@C͂ĉ[m ([33m[RET]:quit[m) >';
        filename := allcaps(getinputguide(cnarg[cn]^.prompt, 12, echo));
      until alpha(filename) or (filename = '');
      getlegal := filename;
    end;


  procedure ldir;
  var
    loop:integer;
    spaces:byte;
    howbig,sectmin:integer;
    temp,temp2:string;
    sums:longint;
    sumt:word;
    sumc:word;
    dumy:dirstr;
    match1:namestr;
    match2:extstr;
    N2:namestr;
    E2:extstr;
  begin
    lineoutIfNeed;
    cnarg[cn]^.prompt:=
      '[36mMATCH [m:[36mChJ[h [m([33m[RET]:*.*[m) >';
    temp:='';
    temp:=allcaps(getinputguide(cnarg[cn]^.prompt,12,echo));
    Fsplit(temp,dumy,match1,match2);
    if match1='' then match1:='*';
    if match2='' then match2:='.*';
    lineout('');
    cnarg[cn]^.cancelled:=false;
    sums:=0;
    sumc:=0;
    sumt:=0;
    sectmin := ksize shl 3;
    initfile;
    flt;
    if cnarg[cn]^.enddir > 0 then begin
      loop :=cnarg[cn]^.enddir;
      while (loop>=1) and (not cnarg[cn]^.cancelled) do begin
        seekB(filfil, loop-1);
        readB(filfil, @cnarg[cn]^.filedat);
        Fsplit(cnarg[cn]^.filedat.title,dumy,N2,E2);
        if wildcard(match1,N2) and
          wildcard(copy(match2,2,3),copy(E2,2,3)) then
          with cnarg[cn]^.filedat do begin
            lfile(loop,cnarg[cn]^.filedat);
            if cnarg[cn]^.filedat.title<>deletedfile then begin
              sums:=sums+(size+sectmin-1) div sectmin;
              sumc:=sumc+accesses;
              inc(sumt);
            end;
          end;
        loop := loop-1;
      end;
      if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
      if sumt=0 then lineout('[35m**** Yt@C܂B[m');
      lineout('[33m---- - ------------ ------ --- ------------------------------------------------[m');
      str(sumt:4,temp);
      stringout('[32m'+temp);
      str(sums:5,temp);
      str(sumc:3,temp2);
      lineout('               '+temp+'KB '+temp2+'[m');
    end
    else begin
     if cts then lineout('[31mt@C݂܂B[m');
    end;
  end;

function dltimes(pt:protocoltype;size:longword):longword;
  const  (* 1000ubN]̂Ɋ|鎞 *)
    ratetime : array[rate] of longword =                    (* K *)
               (20,8512,4256,2128,1064,532,267,133,67,34,17,9,5,3);
    ptspeed : array[protocoltype] of longint = (10,10,16,13,11,10,11);
  var DLtime  : longword;
  begin
    dltimes:=size*ratetime[cnarg[cn]^.baud]*ptspeed[pt] div 600000;
  end;

procedure legaltab(var tabloc:word);
  var
    result  : integer;
    sizel   : longint;
    temp    : name;
    ch      : char;
    message : datetime;
    years, months, dates, hours, mins, secs:word;
  begin
    initfile;
    if (cnarg[cn]^.enddir>0) and (cnarg[cn]^.enddir>=tabloc) then begin
      seekB(filfil, tabloc-1);
      readB(filfil, @cnarg[cn]^.filedat);
      if (not (cnarg[cn]^.filedat.public)) and (not issigop) then begin
        lineout('');
        lineout('[31m̃t@C͎舵o܂B[m');
        tabloc := 0;
      end
      else if cnarg[cn]^.filedat.title=deletedfile then begin
        lineout('');
        lineout('[31m݂Ȃ폜Ă܂B[m');
        tabloc := 0;
      end
      else begin
        with cnarg[cn]^.filedat do begin
          clock(years, months, dates, hours, mins, secs);
          message:=time(years, months, dates, hours, mins, secs);
          lineout('');
          lineout('[33m===========================================[32m '+
            message+'[m');
          lineout('[32mt@C[m : [36m' + title+'[m');
          str(size, temp);
          stringout('[32mubN[m : [32m' + temp +'[m');
          str((size+7) div 8, temp);
          lineout(' ([32m'+temp+'[m)');
          lineout('[32mM[m     : [36m'+getname(submit)+'[32m '+
            date+'[m');
          lineout('[32mRg[m   : '+dellastkanji(copy(comment,1,48)));
          lineout('[33m=============================================================[m');
        end;
      end;
    end
    else begin
      lineout('');
      lineout('[31mt@C܂B[m');
      tabloc := 0;
    end;
  end;

function testbatch:boolean;
  var test:boolean;
  begin
    test:=false;
    if cnarg[cn]^.dlnum>0 then
      for i:=1 to cnarg[cn]^.dlnum do
        if not cnarg[cn]^.dllist[i].rslt then test:=true;
    if not test then cnarg[cn]^.dlnum:=0;
    testbatch:=test;
  end;

procedure addbatch(var successful:boolean);
var temp:string;
begin
  successful:=false;
  if DLMAX>cnarg[cn]^.dlnum then begin
    inc(cnarg[cn]^.dlnum);
    cnarg[cn]^.dllist[cnarg[cn]^.dlnum]:=cnarg[cn]^.dllist[0];
    successful:=true;
  end;
end;

procedure batchlist;
  procedure lbatch(no:integer;DLdat:DLlistType);
    var
      temp,temp2:string;
      D3:dirstr;
      N3:namestr;
      E3:extstr;
      howbig,sectmin:longint;
    begin
      sectmin := ksize shl 3;
      with DLdat do begin
        howbig:=(size+sectmin-1) div sectmin;
        str(howbig:4, temp);
        str(no:3, temp2);
        stringout('[32m'+temp2);
        FSplit(fnam,D3,N3,E3);
        stringout(' [36m'+fnspace(N3+E3)+' [33m'+temp+'KB [32m');
        if rslt then lineout('complete.[m')
        else lineout('false.[m');
      end;
    end;
  var i,l :integer;
  begin
    lineoutIfNeed;
    if not testbatch then lineout('[31mޯ۾ ͓o^Ă܂B[m')
    else begin
      l:=0;
      lineout('[32mNo. Filename     Bytes Successes[m');
      lineout('[33m--- ------------ ------ ---------[m');
      for i:=1 to cnarg[cn]^.dlnum do begin
        lbatch(i,cnarg[cn]^.dllist[i]);
        if not cnarg[cn]^.dllist[i].rslt then inc(l);
      end;
      cnarg[cn]^.cancelled:=false;
      lineout('[33m--- ------------ ------ ---------[m');
      lineout('[36mv [32m'+stri(l)+' [36m̃t@Cҋ@[m');
    end;
  end;


procedure batchdown;
  var
    inch   : char;
    success:boolean;
  procedure listout(pt:protocoltype);
    var
      i:byte;
      j:longword;
      s:string;
    begin
      batchlist;
      j:=0;
      for i:=1 to cnarg[cn]^.dlnum do begin
        j:=j+cnarg[cn]^.dllist[i].size;
      end;
      str(dltimes(pt,j),s);
      lineout('');
      lineout('[36mvԂ [32m'+s+' [36mł[m ([33m'+
        cnarg[cn]^.name_protocol[cnarg[cn]^.MNPflg]+'[m/[33m'+ptstrn[pt]+
        ' ][m)');
    end;
  begin
    lineoutIfNeed;
    if not testbatch then lineout('[31mޯ۾ o^Ă܂B[m')
    else begin
      cnarg[cn]^.batchmode:=true;
      cnarg[cn]^.g_option:=false;
      cnarg[cn]^.crcmode:=crc16;
      success:=false;
      if cn=0 then begin
        listout(none);
        lineout('');
        CONdownload(success);
        lineout('');
      end
      else begin
        inch := getcap('[36mBATCHDOWN[m ([33mY:YMODEM  G:YMODEM-g  Z:ZMODEM  M:M-LINK  [RET]:quit[m) >');
        case inch of
        'Y' : begin
              listout(ymod);
              lineout('');
              Ydownload(success);
              lineout('');
              end;
        'G' : begin
              listout(ymod);
              lineout('');
              cnarg[cn]^.g_option:=true;
              Ydownload(success);
              lineout('');
              end;
        'Z' : begin
              listout(zmod);
              lineout('');
              Zdownload(success);
              lineout('');
              end;
        'M' : begin
              listout(mlk);
              nonecwarning;
              lineout('');
              Mdownload(success);
              lineout('');
              end;
        else lineout('');
        end;
      end;
      cnarg[cn]^.CnStat := zbatch;
      if hoststat = 0 then dispstatus(cn);
      if inch<>'' then
        if success and cts then begin
          lineout('[32mob`_E[hɐ܂B[m');
          cnarg[cn]^.dlnum:=0;
        end
        else lineout('[31mob`_E[h~܂B[m');
    end;
  end;

procedure batchclear;
  begin
    lineoutIfNeed;
    if not testbatch then lineout('[31mޯ۾ ͓o^Ă܂B[m')
    else begin
      cnarg[cn]^.prompt:=
        '[36mޯ۾ ܂H[m  (Y/[33m[N][m) >';
      if getyesno(cnarg[cn]^.prompt)='Y' then begin
        cnarg[cn]^.dlnum:=0;
        lineout('');
        lineout('[33m܂B[m');
      end
      else begin
        lineout('');
        lineout('[31m~߂܂B[m');
      end;
    end;
  end;


procedure batch;
  var
    dumy  : boolean;
    inch  : char;
  begin
    cnarg[cn]^.CnStat := zbatch;
    if hoststat = 0 then dispstatus(cn);
    repeat
      dumy:=testbatch;
      lineoutIfNeed;
      inch := getcap('[36mBATCH[m ([33mD:batchdown  L:batchlist  C:batchclear  0:quit[m) >');
      case inch of
        'L' : batchlist;
        'D' : batchdown;
        'C' : batchclear;
        'M' : if testbatch and issigop then copyfile
              else begin
                lineout('');
                lineout('[31mgpo܂B[m');
              end;
      end;
    until (inch='0') or not cts;
    cnarg[cn]^.CnStat := zfile;
    if hoststat = 0 then dispstatus(cn);
  end;


  procedure TEXTdownload(var successful:boolean);
    begin
      successful:=false;
      with cnarg[cn]^.filedat do begin
        if ASCII then begin
          typefile(filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+title,
            false);
          successful:=not cnarg[cn]^.cancelled;
        end
        else begin
          lineout('');
          lineout(
            '[31moCi[t@CȂ̂Ń_E[ho܂B[m');
        end;
      end;
    end;


  procedure killfile(tabloc:integer);
  var
    loop: integer;
  begin
    lineout('');
    if (cnarg[cn]^.sect.w > cnarg[cn]^.access) then begin
      lineout('[31m̃{[hł͍폜o܂B[m');
      Exit;
    end;
    if tabloc > 0 then begin
      if (cnarg[cn]^.filedat.submit=cnarg[cn]^.usernum) or issigop then begin
        if getyesno('[36m폜Ă낵łH[m (Y/[33m[N][m) >')
          ='Y' then begin
          lineout('');
          stringout('[32m폜 ...');
          assignM(filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+
            cnarg[cn]^.filedat.title);
          resetM;
          if IOresult=0 then begin
            closeM;
            eraseM;
          end;
          while islockB(filfil, tabloc-1) do TransferNext;
          lockB(filfil, tabloc-1);
          seekB(filfil, tabloc-1);
          readB(filfil, @cnarg[cn]^.filedat);
          cnarg[cn]^.filedat.title := deletedfile;
          seekB(filfil, tabloc-1);
          writeB(filfil, @cnarg[cn]^.filedat);
          unlockB(filfil);
          initfile;
          lineout('[33m 폜܂B[m');
        end
        else begin
          lineout('');
          lineout('[31m~܂B[m');
        end
      end
      else begin
        lineout('[31mo^҈ȊO͍폜o܂B[m');
      end;
    end;
  end;

  function newname(tabloc: integer): string;
    var filename: string;
    begin
      newname:=cnarg[cn]^.filedat.title;
      filename:=getlegal('RENAME');
      lineout('');
      if (filename <> '') then begin
        if dirpos(filename)=0 then begin
          stringout('[32ml[ ...');
          assignM(filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+
            cnarg[cn]^.filedat.title);
          renameM(filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+
            filename);
          lineout(' [33ml[IB[m');
        end
        else lineout('[31mt@C݂܂B[m');
        newname:=filename;
      end
      else lineout('[31m̃t@C͎gĂ܂B[m');
    end;


  procedure editfile(tabloc:integer);
  var
    innum      : integer;
    sectstring : string;
  begin
    lineout('');
    if (cnarg[cn]^.sect.w > cnarg[cn]^.access) then begin
      lineout('[31m̃{[hł͕ҏWo܂B[m');
      Exit;
    end;
    if tabloc>0 then begin
        if (cnarg[cn]^.filedat.submit=cnarg[cn]^.usernum) or issigop then begin
          if islockB(filfil, tabloc-1) then begin
            lineout('[31m`lŎgp̂ߕҏWo܂B[m');
            Exit;
          end;
          lockB(filfil, tabloc-1);
          seekB(filfil, tabloc-1);
          readB(filfil, @cnarg[cn]^.filedat);
          with cnarg[cn]^.filedat do begin
            repeat
              str(section:2, sectstring);
              lineout('1:[32mComment[m : [32m'+comment+'[m');
              lineout('2:[32mText[m    : [32m'+yn[not ASCII]+'[m');
              lineout('3:[32mName[m    : [32m'+title+'[m');
              if issigop then begin
                lineout('4:[32mFrom[m    : [32m'+getname(submit)+'[m');
                lineout('5:[32mPublic[m  : [32m'+yn[not public]+'[m');
              end;
              lineout('');
              cnarg[cn]^.prompt:='[36mFILE EDIT[m :[36mύX鍀[m ([33m[RET]:quit[m) >';
              if issigop then innum:=getint(5, 0, cnarg[cn]^.prompt)
              else innum:=getint(2, 0, cnarg[cn]^.prompt);
              case innum of
                1: begin
                   cnarg[cn]^.prompt:='[36mRg[m >';
                   comment:=getinputguide(cnarg[cn]^.prompt, 48, echo);
                end;
                2: ASCII:=not ASCII;
                3: title:=newname(tabloc);
                4: begin
                   cnarg[cn]^.prompt:='[36m`hc[m >';
                   submit:=getid(cnarg[cn]^.prompt);
                end;
                5: public:=not public;
              end;
              if (innum<>2) and (innum<>0) then lineout('');
            until (innum=0) or not cts;
            {$I-}
              assignM(filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+title);
              resetM;
            {$I+}
            if IOresult=0 then begin
            size:=filesizeM;
            closeM;
          end
          else size := 0;
          seekB(filfil, tabloc-1);
          writeB(filfil, @cnarg[cn]^.filedat);
          unlockB(filfil);
        end;
      end
      else lineout('[31mo^҈ȊO͕ҏWo܂B[m');
    end
    else lineout('[31mt@C܂B[m');
  end;


  function ptconv(inch:char):protocoltype;
    begin
      case inch of   (* nĂȂ *)
        'D':ptconv:=none;
        'T':ptconv:=texts;
        'X':ptconv:=xmod;
        'S':ptconv:=xmod;
        'C':ptconv:=xmod;
        'Y':ptconv:=ymod;
        'G':ptconv:=ymod;
        'Z':ptconv:=zmod;
        'M':ptconv:=mlk;
        'B':ptconv:=btc;
      end;
    end;

procedure getdowntype(num:word);
  var
    inch:char;
    temp:string;
    logs:boardlog;
    day:word;
    success:boolean;
  begin
    success:=false;
    if cnarg[cn]^.inbuffer='' then begin
      legaltab(num);
      if num=0 then exit;
      if (cnarg[cn]^.expert=ebegin) then begin
        lineout('');
        outfile(bmesdrive+j_downhelp);
      end;
    end;
    with cnarg[cn]^.dllist[0] do begin
      tloc:=num;
      fnam:=filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+
        cnarg[cn]^.filedat.title;
      time:=cnarg[cn]^.filedat.date;
      size:=cnarg[cn]^.filedat.size;
      ASCII:=cnarg[cn]^.filedat.ASCII;
      submit:=cnarg[cn]^.filedat.submit;
      accesses:=cnarg[cn]^.filedat.accesses;
      comment:=cnarg[cn]^.filedat.comment;
      rslt:=false;
    end;
    with cnarg[cn]^ do begin
      batchmode:=false;
      crcmode:=crc16;
      g_option:=false;
      blkunit:=8;
    end;
    repeat
      lineoutifneed;
      cnarg[cn]^.prompt:=
        '[36mProtocol[m ([33mT,S,C,X,Y,G,Z,M,B,E,K,?,0,Q[m) >';
      if cn=0 then
        cnarg[cn]^.prompt:='[36mOperation[m ([33mD,B,E,K,?,0,Q[m) >';
      inch:=getcap(cnarg[cn]^.prompt);
      if ((cn>0) and (inch in ['S','C','X','Y','G','Z','M'])) or
        ((cn=0) and (inch='D')) then begin
        lineout('');
        str(dltimes(ptconv(inch),cnarg[cn]^.filedat.size), temp);
        lineout('[36mvԂ [32m'+temp+' [36mł[m ([33m'+
          cnarg[cn]^.name_protocol[cnarg[cn]^.MNPflg]+'[m/[33m'+
            ptstrn[ptconv(inch)]+' ][m)');
        if inch='M' then begin
          nonecwarning;
          lineout('');
        end;
      end;
      case inch of
        'D':if cn=0 then begin
            CONdownload(success);
            end;
        'T':if cn>0 then TEXTdownload(success);
        'S':if cn>0 then begin
            cnarg[cn]^.blkunit:=1;
            cnarg[cn]^.crcmode:=sum;
            Xdownload(success);
            end;
        'C':if cn>0 then begin
            cnarg[cn]^.blkunit:=1;
            Xdownload(success);
            end;
        'X':if cn>0 then begin
            Xdownload(success);
            end;
        'Y':if cn>0 then begin
            Ydownload(success);
            end;
        'G':if cn>0 then begin
            cnarg[cn]^.g_option:=true;
            Ydownload(success);
            end;
        'Z':if cn>0 then begin
            Zdownload(success);
            end;
        'M':if cn>0 then Mdownload(success);
        'B':addbatch(success);
        'E':editfile(num);
        'K':killfile(num);
        '?':begin
            lineout('');
            outfile(bmesdrive+j_downhelp);
        end;
      end;
    until ((inch in ['T','S','C','X','Y','G','Z','M']) and (cn>0)) or
      ((inch='D') and (cn=0)) or (inch in ['B','E','K','0','Q']) or not cts;
    if not (inch in ['E','K','0','Q']) then begin
      lineout('');
      if success then begin
        while islockB(filfil, num-1) do TransferNext;
        lockB(filfil, num-1);
        seekB(filfil, num-1);
        readB(filfil, @cnarg[cn]^.filedat);
        inc(cnarg[cn]^.filedat.accesses);
        seekB(filfil, num-1);
        writeB(filfil, @cnarg[cn]^.filedat);
        unlockB(filfil);
        with logs do begin
          user:=cnarg[cn]^.usernum;
          article:=fnspace(cnarg[cn]^.filedat.title);
          written:=false;
          clock(year,month,day,hour,min,sec);
          date:=time(year,month,day,hour,min,sec);
          protocol:=ptconv(inch);
        end;
        writebdlog(logs);
        if inch='B' then begin
          stringout('[32mޯ۾ ɒǉ܂B[m [[36m');
          str(cnarg[cn]^.dlnum:2,temp);
          stringout(temp+'[m/[36m');
          str(DLMAX:2,temp);
          lineout(temp+'[m]');
        end
        else lineout('[32m_E[hɐ܂B[m');
      end
      else if inch='B' then
        lineout('[31mȏ ޯ۾ ǉo܂B[m')
      else lineout('[31m_E[hɎs܂B[m');
    end;
    if inch='Q' then begin
      lineout('');
      lineout('[31m~܂B[m');
      cnarg[cn]^.cancelled:=true;
    end;
  end;


function flnw(lsto:datetime):byte;
  (* w{[h news *)
  var
    loop  : integer;
    temp  : datetime;
    fldt  : filerec;
    temp2 : string[4];
    count : byte;
  begin
    initfile;
    count:=0;
    loop:=filesizeB(filfil);
    if loop > 0 then repeat
      seekB(filfil, loop-1);
      {$I-} readB(filfil, @fldt); {$I+}
      temp:=fldt.date;
      if (dt2bin(temp)>=dt2bin(lsto)) and (ioresult=0) and
        (fldt.title<>deletedfile) and (fldt.public or issigop) then begin
        if count=0 then begin
          lineout('[32m ... [m');
          lineout('');
          flt;
        end;
        lfile(loop,fldt);
        inc(count);
        if count<100 then wtr[count]:=loop;
      end;
      dec(loop);
    until (loop=0) or cnarg[cn]^.cancelled or
      ((dt2bin(temp)<dt2bin(lsto)) and (fldt.title<>deletedfile)) or not cts;
    cnarg[cn]^.cancelled:=false;
    if count=0 then lineout('[33mV ̧ ͂܂[m')
    else begin
      lineout('[33m---- - ------------ ------ --- ------------------------------------------------[m');
      str(count, temp2);
      lineout(
        '[36mv [32m'+temp2+' [36m̐Vt@C܂B');
    end;
    flnw:=count;
  end;


function flsearch(fn:string):byte;
  (* w{[ȟ *)
  var
    loop    : integer;
    fldt    : filerec;
    count   : byte;
    temp    : string;
  begin
    initfile;
    count:=0;
    loop:=filesizeB(filfil);
    while (loop>=1) and not cnarg[cn]^.cancelled and cts do begin
      seekB(filfil, loop-1);
      readB(filfil, @fldt);
      if wildcard(fn,fldt.title) and (fldt.title<>deletedfile) and
        (fldt.public or issigop) then begin
        if count=0 then begin
          lineout('[32m ... [m');
          lineout('');
          flt;
        end;
        lfile(loop,fldt);
        inc(count);
        if count<100 then wtr[count]:=loop;
      end;
      dec(loop);
    end;
    cnarg[cn]^.cancelled:=false;
    if count=0 then lineout('[33mړI ̧ ͂܂[m')
    else begin
      lineout('[33m---- - ------------ ------ --- ------------------------------------------------[m');
      str(count, temp);
      lineout(
        '[36mv [32m'+temp+' [36m̃t@C𔭌܂B');
    end;
    flsearch:=count;
  end;


procedure filesearches(choice:searches);
  (* ݂牺̧ްނ̌s *)
  const
    sccnstat:array[searches] of where=(zfilenews,zfilesearch);
    sccnstr:array[searches] of string[12]=('FILE NEWS','FILE SEARCH');
  var
    buf : secttype;
    num : array[1..16] of byte;  (* 16Kw *)
    loop: byte;
    i   : byte;
    ch  : char;
    temp: string;
    lsto: datetime;
    sstr: string;
    count:byte;
  begin
    cnarg[cn]^.CnStat := sccnstat[choice];
    if hoststat = 0 then dispstatus(cn);
    lsto:='';
    sstr:='';
    case choice of
      snews:begin
            lineoutifneed;
            lsto:=getdays(sccnstr[choice]);
      end;
      ssearch:sstr:=getlegal(sccnstr[choice]);
    end;
    if (lsto='') and (sstr='') then begin
      cnarg[cn]^.CnStat := zfile;
      if hoststat = 0 then dispstatus(cn);
      exit;
    end;
    lineout('');
    buf:=cnarg[cn]^.sect;
    for i:=1 to 16 do num[i]:=0;
    loop:=1;
    repeat
      case cnarg[cn]^.sect.attrib of
        amenu:if (num[loop]<10) and (cnarg[cn]^.sect.downb[num[loop]]>0) and
                testin(cnarg[cn]^.sect,false) then begin (* wްޗL *)
                seekB(fbdfil,cnarg[cn]^.sect.downb[num[loop]]);
                readB(fbdfil,@cnarg[cn]^.sect);          (* wްގ擾 *)
                inc(num[loop]);
                inc(loop);
              end
              else begin
                inc(num[loop]);
                if num[loop]>=10 then begin       (* wްނ͖̌ *)
                  num[loop]:=0;
                  dec(loop);
                  seekB(fbdfil,cnarg[cn]^.sect.back);
                  readB(fbdfil,@cnarg[cn]^.sect); (* ްނ̎擾 *)
                end;
              end;
        aboard:begin (* ݂ްޑް޽ðȂΌs *)
              if testin(cnarg[cn]^.sect,false) and
                (cnarg[cn]^.sect.r<=cnarg[cn]^.access) then begin
                stringout(SectWithNum(cnarg[cn]^.sect));
                stringout(' ');
                for i := length(cnarg[cn]^.sect.nam) to 37-6 do
                  stringout('');
                stringout(' ');
                if cnarg[cn]^.cancelled then begin
                  cnarg[cn]^.cancelled:=false;
                  cnarg[cn]^.CnStat := zfile;
                  cnarg[cn]^.sect:=buf;
                  if hoststat = 0 then dispstatus(cn);
                  exit;
                end;
                openboard(cnarg[cn]^.sect.number+1000);
                case choice of
                  snews:count:=flnw(lsto);
                  ssearch:count:=flsearch(sstr);
                end;
                if count>0 then begin
                  repeat
                    lineout('');
                    cnarg[cn]^.prompt:='[36m'+sccnstr[choice]+
                      '[m ([33m[RET]:nextboard  D:download  0:quit[m) >';
                    ch := getcap(cnarg[cn]^.prompt);
                    if (not cts) or (ch = '0') then begin
                      closeboard;
                      lineout('');
                      cnarg[cn]^.sect:=buf;
                      cnarg[cn]^.CnStat := zfile;
                      if hoststat = 0 then dispstatus(cn);
                      exit;
                    end;
                    if ch = 'D' then begin
                      if cnarg[cn]^.dlnum<DLMAX then begin
                        cnarg[cn]^.CnStat := zbatch;
                        if hoststat = 0 then dispstatus(cn);
                        i:=count;
                        while (i>0) and (cnarg[cn]^.dlnum<DLMAX) and
                          not cnarg[cn]^.cancelled and cts do begin
                          getdowntype(wtr[i]);
                          dec(i);
                        end;
                        cnarg[cn]^.cancelled:=false;
                        cnarg[cn]^.CnStat := zfilenews;
                        if hoststat = 0 then dispstatus(cn);
                      end
                      else lineout(
                        '[31mȏ ޯ۾ ǉo܂B[m');
                    end;
                  until (ch<>'A') or not cts;
                  lineout('');
                end;
                closeboard;
              end;
              seekB(fbdfil,cnarg[cn]^.sect.back);
              readB(fbdfil,@cnarg[cn]^.sect);     (* ްƭɖ߂ *)
              dec(loop);
              end;
      end;
    until (loop=0) or cnarg[cn]^.cancelled or not cts;
    if cnarg[cn]^.cancelled then begin
      cnarg[cn]^.cancelled:=false;
      lineout('');
      lineout('[36m'+sccnstr[choice]+'[m :[31m𒆒f܂B[m');
    end
    else begin
      lineout('');
      lineout('[36m'+sccnstr[choice]+'[m :[33mI܂B[m');
    end;
    cnarg[cn]^.sect:=buf;
    lineout('');
    cnarg[cn]^.CnStat := zfile;
    if hoststat = 0 then dispstatus(cn);
  end;


procedure getfsect;
  var
    instr: string8;
    inch : integer;
    dumy : integer;
    recs : integer;
    buf  : secttype;
  begin
    putinfo;
    repeat
      lineoutifneed;
      if cnarg[cn]^.inbuffer='' then sectheader('File');
      cnarg[cn]^.prompt:='[36mSELECT[m :[36m{[h  {[hԍ[m ([33mnn,#nn,name,I,A,L,N,S,D,H,?,Q[m) >';
      instr:=allcaps(getinput(cnarg[cn]^.prompt,8,echo));
      if instr='I' then outinfo
      else if instr='L' then listsections
      else if instr='A' then allsections
      else if instr='$' then custboard
      else if instr='?' then begin
        lineout('');
        outfile(bmesdrive+j_selmenu);
      end
      else if instr='H' then begin
        lineout('');
        outfile(bmesdrive+j_selhelp);
      end
      else if instr='N' then filesearches(snews)
      else if instr='S' then filesearches(ssearch)
      else if instr='D' then batchdown
      else if instr='Q' then cnarg[cn]^.sect.attrib:=anone
      else if copy(instr,1,1)='#' then begin   (* Δԍw *)
        val(copy(instr,2,255),inch,dumy);
        if (dumy>0) or (inch>=filesizeB(fbdfil)) or
          (inch=0) or (length(instr)=1) then begin
          lineout('');
          lineout('[31m{[h܂B[m');
        end
        else begin
          seekB(fbdfil,inch);
          readB(fbdfil,@buf);
          if paththru(buf) then begin
            cnarg[cn]^.sect:=buf;
            putinfo;
          end;
        end;
      end
      else begin
        val(instr,inch,dumy);
        if (inch>0) and (inch<11) then begin  (* ԍw *)
          if cnarg[cn]^.sect.downb[inch-1]=0 then begin
            lineout('');
            lineout('[31m{[h܂B[m');
          end
          else begin
            seekB(fbdfil,cnarg[cn]^.sect.downb[inch-1]);
            readB(fbdfil,@buf);
            if testin(buf,true) then begin
              cnarg[cn]^.sect:=buf;
              putinfo;
            end;
          end;
        end
        else if (inch<0) or (inch>10) then begin
          lineout('');
          lineout('[31m{[h̎w肪Ⴂ܂B[m');
        end
        else if (inch=0) and (dumy=0) then begin  (* Kwオ *)
          if (cnarg[cn]^.sect.number=1) or (cnarg[cn]^.sect.back=0) then
            cnarg[cn]^.sect.attrib:=anone
          else begin
            seekB(fbdfil,cnarg[cn]^.sect.back);
            readB(fbdfil,@cnarg[cn]^.sect);
            putinfo;
          end;
        end
        else if dumy>0 then begin  (* Ύw({[h) *)
          seekB(fbdfil,1);
          repeat
            readB(fbdfil,@buf);
          until eofB(fbdfil) or (buf.bname=instr) or not cts;
          if (buf.bname<>instr) and (instr<>'') then begin
            lineout('');
            lineout('[31m{[h܂B[m');
          end
          else if (instr<>'') and paththru(buf) then begin
            cnarg[cn]^.sect:=buf;
            putinfo;
          end;
        end;
      end;
    until (cnarg[cn]^.sect.attrib<>amenu) or not cts;
  end;

procedure download;
  var
    temp:string;
    loop:integer;
    chk :boolean;
    dumy:dirstr;
    match1:namestr;
    match2:extstr;
    N2  :namestr;
    E2  :extstr;
  begin
    chk:=false;
    lineoutifneed;
    cnarg[cn]^.prompt:='[36mDOWNLOAD[m :[36mt@C͂ĉ[m ([33m[RET]:*.*[m) >';
    temp:='';
    temp:=allcaps(getinputguide(cnarg[cn]^.prompt,12,echo));
    Fsplit(temp,dumy,match1,match2);
    if match1='' then match1:='*';
    if match2='' then match2:='.*';
    initfile;
    if cnarg[cn]^.enddir>0 then begin
      loop :=1;
      while (loop<=cnarg[cn]^.enddir) and not cnarg[cn]^.cancelled do begin
        seekB(filfil,loop-1);
        readB(filfil,@cnarg[cn]^.filedat);
        Fsplit(cnarg[cn]^.filedat.title,dumy,N2,E2);
        if wildcard(match1,N2) and wildcard(copy(match2,2,3),copy(E2,2,3)) and
          (cnarg[cn]^.filedat.title<>deletedfile) then begin
          getdowntype(loop);
          chk:=true;
        end;
        inc(loop);
      end;
    end;
    cnarg[cn]^.cancelled:=false;
    if not chk then begin
      lineout('');
      lineout('[31mt@C܂B[m');
    end;
  end;

procedure upload;
  var
    filename  : string;
    successful: boolean;
    sectnum   : byte;
    prtcl     : integer;
    legal     : string;
    inch      : char;
  function getdrivename(s:string):char;
    begin
      if pos(':',s)>0 then getdrivename:=s[pos(':',s)-1]
      else getdrivename:='@';
    end;
  begin
    if (cnarg[cn]^.enddir >= mostfiles) or
      (diskfree(byte(getdrivename(filedrive))-$40)<lastcap) then begin
      lineout('');
      lineout('[31mgnrs̗eʂsĂ܂B[m');
      exit;
    end
    else if (cnarg[cn]^.sect.w > cnarg[cn]^.access) then begin
      lineout('');
      lineout('[31m̃{[hɂ͓o^o܂B[m');
      exit;
    end;
    filename := getlegal('UPLOAD');
    if filename <> '' then begin
      if dirpos(filename)>0 then lineout(
        '[33m̃t@C͊ɑ݂܂BOςĉB[m')
      else begin
        lineout('');
        lineout('[32mt@C̐𕪂Ղ͂ĉB[m');
        cnarg[cn]^.prompt := '[36mComment[m >';
        cnarg[cn]^.filedat.comment:=getinputguide(cnarg[cn]^.prompt,48,echo);
        filename:=filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+filename;
        if cn=0 then begin
          CONupload(filename, successful);
          lineout('');
          if successful then begin
            cnarg[cn]^.filedat.submit := cnarg[cn]^.usernum;
            cnarg[cn]^.filedat.date := cnarg[cn]^.timeon;
            cnarg[cn]^.filedat.accesses := 0;
            addfile(filename,none);
            inc(cnarg[cn]^.enddir);
            lineout('[32mAbv[hɐ܂B[m');
          end
          else lineout('[31mAbv[hɎs܂B[m');
        end
        else begin
          if (cnarg[cn]^.expert=ebegin) then begin
            lineout('');
            outfile(bmesdrive+j_uphelp);
          end;
          repeat
            lineoutifneed;
            cnarg[cn]^.prompt:=
              '[36mProtocol[m ([33mT,S,C,X,Y,G,Z,M,?,0[m) >';
            inch:=getcap(cnarg[cn]^.prompt);
            if inch in ['T','S','C','X','Y','G','Z','M','?','0'] then begin
              case inch of
                'T' : textupload(filename, successful);
                'S' : begin
                      cnarg[cn]^.crcmode := sum;
                      cnarg[cn]^.blkunit := 1;
                      lineout('');
                      Xupload(filename, successful);
                end;
                'C' : begin
                      cnarg[cn]^.crcmode := crc16;
                      cnarg[cn]^.blkunit := 1;
                      lineout('');
                      Xupload(filename, successful);
                end;
                'X' : begin
                      cnarg[cn]^.crcmode := crc16;
                      cnarg[cn]^.blkunit := 8;
                      lineout('');
                      Xupload(filename, successful);
                end;
                'Y' : begin
                      cnarg[cn]^.g_option := false;
                      lineout('');
                      Yupload(filename, successful);
                end;
                'G' : begin
                      cnarg[cn]^.g_option := true;
                      lineout('');
                      Yupload(filename, successful);
                end;
                'Z' : begin
                      cnarg[cn]^.crcmode := crc16;
                      lineout('');
                      Zupload(filename, successful);
                end;
                'M' : begin
                      nonecwarning;
                      lineout('');
                      Mupload(filename, successful);
                end;
                '?' : begin
                      lineout('');
                      outfile(bmesdrive+j_uphelp);
                end;
              end;
            end;
          until (inch in ['T','S','C','X','Y','G','Z','M','0']) or not cts;
          clearline;
          lineout('');
          if inch='0' then begin
            lineout('');
            lineout('[31m~܂B[m');
          end
          else begin
            if successful then begin
              cnarg[cn]^.filedat.submit := cnarg[cn]^.usernum;
              cnarg[cn]^.filedat.date := cnarg[cn]^.timeon;
              cnarg[cn]^.filedat.accesses := 0;
              addfile(filename,ptconv(inch));
              inc(cnarg[cn]^.enddir);
              lineout('[32mAbv[hɐ܂B[m');
            end
            else lineout('[31mAbv[hɎs܂B[m');
          end;
        end;
      end;
    end;
  end;

{----------------------------}

procedure filemenu;
  begin
    repeat
      getfsect;
      while (cnarg[cn]^.sect.attrib=aboard) and
        (cnarg[cn]^.sect.number>0) and cts do begin
        openBoard(cnarg[cn]^.sect.number+1000);
        initfile;
        if (cnarg[cn]^.expert=ebegin) and (cnarg[cn]^.inbuffer='') then begin
          lineout('');
          outfile(bmesdrive+j_filemenu);
        end;
        comch:='';
        repeat
          lineoutifneed;
          str((10000+cnarg[cn]^.sect.number):5,temp);
          cnarg[cn]^.prompt := '[36mFILE[m [[32m#'+
            copy(temp,3,3)+'[m/[32m'+
            copy(cnarg[cn]^.sect.bname+'        ',1,8)+'[m] '+
            '([33mI,L,U,D,B,N,H,nn,?,0[m) >';
          comch:=' ';
          comch:=allcaps(getinput(cnarg[cn]^.prompt,5,echo));
          val(comch,innum,dumy);
          if (innum>0) and (dumy=0) then begin
            lineoutifneed;
            if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
              lineout('[31m̃{[hł̓_E[h͏o܂B[m');
            end
            else begin
              if cnarg[cn]^.inbuffer='' then
                lineout('  [32m _E[h [m');
              getdowntype(innum);
              cnarg[cn]^.cancelled:=false;
            end;
          end
          else case comch[1] of
            'L' : begin
                  if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                    lineout('');
                    lineout('[31m̃{[hł̓Xg\o܂B[m');
                  end
                  else begin
                    ldir;
                  end;
            end;
            'B' : batch;
            'U' : upload;
            'D' : begin
                  if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                    lineout('');
                    lineout('[31m̃{[hł̓_E[h͏o܂B[m');
                  end
                  else download;
            end;
            'N' : begin
                  if cnarg[cn]^.sect.r > cnarg[cn]^.access then begin
                    lineout('');
                    lineout('[31m̃{[hł͌o܂B[m');
                  end
                  else begin
                    closeboard;
                    filesearches(snews);
                    openboard(cnarg[cn]^.sect.number+1000);
                    initfile;
                  end;
            end;
            'I' : begin
                  lineout('');
                  outinfo;
            end;
            '$' : custboard;
            'H' : begin
                  lineout('');
                  outfile(bmesdrive+j_filehelp);
            end;
            '?' : begin
                  lineout('');
                  outfile(bmesdrive+j_filemenu);
            end;
          end;
          initfile;
        until (comch = '0') or not cts;
        closeBoard;
        seekB(fbdfil,cnarg[cn]^.sect.back);
        readB(fbdfil,@cnarg[cn]^.sect);
        getfsect;
      end;
      comch:='Y';
      if testbatch then begin
        lineout('');
        cnarg[cn]^.prompt:='[36m ޯ۾ ܂BXłH[m (Y/[33m[N][m) >';
        comch:=getyesno(cnarg[cn]^.prompt);
        if cnarg[cn]^.sect.number=0 then begin
          seekB(fbdfil,1);
          readB(fbdfil,@cnarg[cn]^.sect);
        end;
      end;
    until (comch='Y') or not cts;
  end;


procedure fileboard;
  begin
    cnarg[cn]^.CnStat := zfile;
    if hoststat = 0 then dispstatus(cn);
    cnarg[cn]^.dlnum:=0;
    seekB(fbdfil,1);
    readB(fbdfil,@cnarg[cn]^.sect);
{   if (cnarg[cn]^.sect.r<=cnarg[cn]^.access) or
      (cnarg[cn]^.sect.w<=cnarg[cn]^.access) then begin }
    if testin(cnarg[cn]^.sect,false) then begin
      filemenu;
    end
    else begin
      lineout('');
      lineout('[31mt@C{[h͗po܂B[m');
    end;
  end;


end.

